/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.resbuilder.type.attrs;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.json.JSONArray;
import org.json.JSONObject;

public class AttrDefine {
    public static final Comparator<AttrDefine> COMPARATOR = new Comparator<AttrDefine>(){

        @Override
        public int compare(AttrDefine o1, AttrDefine o2) {
            return o1 == null || o1.mName == null ? (o2 == null || o2.mName == null ? 0 : -1) : o1.mName.compareTo(o2.mName);
        }
    };
    private static final Comparator<EnumFlagDefine> ENUM_FLAG_COMPARATOR = new Comparator<EnumFlagDefine>(){

        @Override
        public int compare(EnumFlagDefine o1, EnumFlagDefine o2) {
            return o1 == null || o1.mName == null ? (o2 == null || o2.mName == null ? 0 : -1) : o1.mName.compareTo(o2.mName);
        }
    };
    public final Set<EnumFlagDefine> mEnumDefines = new TreeSet<EnumFlagDefine>(ENUM_FLAG_COMPARATOR);
    public String mName;
    public String mType;

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof AttrDefine)) {
            return false;
        }
        AttrDefine o = (AttrDefine)obj;
        if (!this.mName.equals(o.mName)) {
            return false;
        }
        if (!this.mType.equals(o.mType)) {
            return false;
        }
        return this.mEnumDefines.equals(o.mEnumDefines);
    }

    public AttrDefine parse(Object o) {
        this.mName = null;
        this.mType = null;
        this.mEnumDefines.clear();
        if (o instanceof JSONObject) {
            JSONObject json = (JSONObject)o;
            this.mName = json.optString("name", null);
            this.mType = json.optString("type", null);
            JSONArray enumDefines = json.optJSONArray("enum");
            for (int i = 0; enumDefines != null && i < enumDefines.length(); ++i) {
                this.mEnumDefines.add(new EnumFlagDefine().parse(enumDefines.opt(i)));
            }
        } else {
            this.mName = String.valueOf(o).trim();
            int c = this.mName.indexOf(47);
            if (c > 0) {
                String[] enumStrings = this.mName.substring(c + 1).split("/");
                this.mName = this.mName.substring(0, c).trim();
                for (String enumString : enumStrings) {
                    if ((enumString = enumString.trim()).length() <= 0) continue;
                    this.mEnumDefines.add(new EnumFlagDefine().parse(enumString));
                }
            }
            if ((c = this.mName.indexOf(36)) > 0) {
                this.mType = this.mName.substring(c + 1).trim();
                this.mName = this.mName.substring(0, c).trim();
            }
        }
        if (this.mType == null && this.mEnumDefines.size() > 0) {
            this.mType = "enum";
        }
        return this;
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("attr");
        writer.writeAttribute("name", this.mName);
        boolean flag = "flag".equals(this.mType);
        if (!flag && this.mType != null) {
            writer.writeAttribute("format", this.mType);
        }
        for (EnumFlagDefine enumDefine : this.mEnumDefines) {
            writer.writeStartElement(flag ? "flag" : "enum");
            writer.writeAttribute("name", enumDefine.mName);
            writer.writeAttribute("value", enumDefine.mValue);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static final class EnumFlagDefine {
        public String mName;
        public String mValue;

        private EnumFlagDefine() {
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (!(obj instanceof EnumFlagDefine)) {
                return false;
            }
            EnumFlagDefine o = (EnumFlagDefine)obj;
            if (!this.mName.equals(o.mName)) {
                return false;
            }
            return this.mValue.equals(o.mValue);
        }

        public EnumFlagDefine parse(Object o) {
            if (o instanceof JSONObject) {
                JSONObject json = (JSONObject)o;
                this.mName = json.optString("name", null);
                this.mValue = json.optString("value", null);
            } else {
                this.mName = String.valueOf(o).trim();
                int c = this.mName.indexOf(32);
                if (c > 0) {
                    this.mValue = this.mName.substring(c + 1).trim();
                    this.mName = this.mName.substring(0, c).trim();
                }
            }
            return this;
        }
    }
}

