/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.resbuilder.type.attrs;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.holoeverywhere.resbuilder.type.attrs.AttrDefine;
import org.json.JSONArray;

public class StyleableDefine {
    public static final Comparator<StyleableDefine> COMPARATOR = new Comparator<StyleableDefine>(){

        @Override
        public int compare(StyleableDefine o1, StyleableDefine o2) {
            return o1 == null || o1.mName == null ? (o2 == null || o2.mName == null ? 0 : -1) : o1.mName.compareTo(o2.mName);
        }
    };
    public final Set<AttrDefine> mAttrDefines = new TreeSet<AttrDefine>(AttrDefine.COMPARATOR);
    public String mName;
    public String mParent;

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof StyleableDefine)) {
            return false;
        }
        StyleableDefine o = (StyleableDefine)obj;
        if (!this.mName.equals(o.mName)) {
            return false;
        }
        return this.mAttrDefines.equals(o.mAttrDefines);
    }

    public StyleableDefine parse(Object o, String name) {
        int c = name.lastIndexOf(60);
        if (c > 0) {
            this.mName = name.substring(0, c).trim();
            this.mParent = name.substring(c + 1).trim();
        } else {
            this.mName = name;
            this.mParent = null;
        }
        this.mAttrDefines.clear();
        if (o instanceof JSONArray) {
            JSONArray json = (JSONArray)o;
            for (int i = 0; i < json.length(); ++i) {
                this.mAttrDefines.add(new AttrDefine().parse(json.opt(i)));
            }
        } else {
            String[] defines;
            for (String define : defines = String.valueOf(o).split("/")) {
                if ((define = define.trim()).length() <= 0) continue;
                this.mAttrDefines.add(new AttrDefine().parse(define));
            }
        }
        return this;
    }

    public void write(XMLStreamWriter writer, Set<StyleableDefine> styleableNodes) throws XMLStreamException {
        writer.writeStartElement("declare-styleable");
        writer.writeAttribute("name", this.mName);
        if (this.mParent != null) {
            StyleableDefine parentNode = null;
            for (StyleableDefine node : styleableNodes) {
                if (!this.mParent.equals(node.mName)) continue;
                parentNode = node;
                break;
            }
            if (parentNode == null) {
                writer.writeComment("Couldn't find parent node: " + this.mParent);
            } else {
                for (AttrDefine define : parentNode.mAttrDefines) {
                    define.write(writer);
                }
            }
        }
        for (AttrDefine define : this.mAttrDefines) {
            define.write(writer);
        }
        writer.writeEndElement();
    }
}

