/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.resbuilder.type.attrs;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamWriter;
import org.holoeverywhere.resbuilder.BuildMojo;
import org.holoeverywhere.resbuilder.type.FileProcesser;
import org.holoeverywhere.resbuilder.type.TypeProcesser;
import org.holoeverywhere.resbuilder.type.attrs.AttrDefine;
import org.holoeverywhere.resbuilder.type.attrs.StyleableDefine;
import org.json.JSONArray;
import org.json.JSONObject;

@TypeProcesser.Type(value="attrs")
public class TypeAttrs
extends TypeProcesser {
    @Override
    public AttrsProcessResult process(BuildMojo mojo, JSONObject json) {
        AttrsProcessResult result = new AttrsProcessResult();
        result.mOutput = json.optString("output");
        JSONArray attrs = json.optJSONArray("attrs");
        for (int i = 0; attrs != null && i < attrs.length(); ++i) {
            result.mDefineNodes.add(new AttrDefine().parse(attrs.opt(i)));
        }
        JSONObject styleable = json.optJSONObject("styleable");
        if (styleable != null) {
            Iterator keys = styleable.sortedKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                result.mStyleableNodes.add(new StyleableDefine().parse(styleable.opt(key), key));
            }
        }
        return result;
    }

    public static class AttrsProcessResult
    extends FileProcesser.ProcessResult {
        private static final long serialVersionUID = -3503835014971969667L;
        private final Set<AttrDefine> mDefineNodes = new TreeSet<AttrDefine>(AttrDefine.COMPARATOR);
        private String mOutput;
        private final Set<StyleableDefine> mStyleableNodes = new TreeSet<StyleableDefine>(StyleableDefine.COMPARATOR);

        @Override
        public void flush(BuildMojo mojo) throws FileProcesser.FileProcesserException {
            if (this.mOutput == null) {
                mojo.getLog().info((CharSequence)" # Output property not set, skip");
                return;
            }
            XMLStreamWriter writer = this.openWriter(mojo, null, this.mOutput);
            try {
                TreeSet<StyleableDefine> styleable = new TreeSet<StyleableDefine>(StyleableDefine.COMPARATOR);
                styleable.addAll(this.mStyleableNodes);
                TreeSet<AttrDefine> fullAttrDefine = new TreeSet<AttrDefine>(AttrDefine.COMPARATOR);
                fullAttrDefine.addAll(this.mDefineNodes);
                for (StyleableDefine styleableDefine : styleable) {
                    TreeSet<AttrDefine> simplifiedAttrList = new TreeSet<AttrDefine>(AttrDefine.COMPARATOR);
                    for (AttrDefine a : styleableDefine.mAttrDefines) {
                        if (a.mType == null) {
                            simplifiedAttrList.add(a);
                            continue;
                        }
                        AttrDefine newAttrDefine = new AttrDefine();
                        newAttrDefine.mName = a.mName;
                        simplifiedAttrList.add(newAttrDefine);
                        fullAttrDefine.add(a);
                    }
                    styleableDefine.mAttrDefines.clear();
                    styleableDefine.mAttrDefines.addAll(simplifiedAttrList);
                }
                writer.writeComment("Start attrs definition block");
                for (AttrDefine attrDefine : fullAttrDefine) {
                    attrDefine.write(writer);
                }
                writer.writeComment("Start styleable definition block");
                for (StyleableDefine styleableDefine : styleable) {
                    styleableDefine.write(writer, this.mStyleableNodes);
                }
                writer.writeComment("End of any blocks");
            }
            catch (Exception e) {
                throw new FileProcesser.FileProcesserException(e);
            }
        }
    }
}

