/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.resbuilder.type.styles;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.holoeverywhere.resbuilder.type.strings.TypeStrings;
import org.json.JSONArray;
import org.json.JSONObject;

public class Block {
    public Map<String, String> mData = new TreeMap<String, String>(TypeStrings.COMPARATOR);
    public List<String> mInclude = new ArrayList<String>();
    private String mName;
    public String mParent;

    public String getName() {
        return this.mName;
    }

    public Block parse(JSONObject data, String name) {
        this.mName = name;
        this.mParent = null;
        this.mInclude.clear();
        this.mData.clear();
        int c = this.mName.indexOf(60);
        if (c > 0) {
            this.mParent = this.mName.substring(c + 1).trim();
            this.mName = this.mName.substring(0, c).trim();
        }
        if ((c = this.mName.indexOf(124)) > 0) {
            String[] includes = this.mName.substring(c + 1).split(" ");
            this.mName = this.mName.substring(0, c).trim();
            for (String include : includes) {
                if ((include = include.trim()).length() <= 0) continue;
                this.mInclude.add(include);
            }
        }
        if (data.has("include")) {
            JSONArray a = data.optJSONArray("include");
            for (int i = 0; i < a.length(); ++i) {
                this.mInclude.add(String.valueOf(a.opt(i)));
            }
        }
        if (data.has("parent")) {
            this.mParent = data.optString("parent");
        }
        Iterator keys = data.sortedKeys();
        while (keys.hasNext()) {
            String value;
            String key = (String)keys.next();
            if ("include".equals(key) || "parent".equals(key) || (value = String.valueOf(data.opt(key))) == null) continue;
            this.mData.put(key, value);
        }
        return this;
    }

    public void process(XMLStreamWriter writer, Map<String, Block> blocks) throws XMLStreamException {
        if (this.mParent != null) {
            writer.writeAttribute("parent", this.mParent);
        }
        for (String i : this.mInclude) {
            if (blocks.containsKey(i)) {
                writer.writeComment("Include block: " + i);
                blocks.get(i).process(writer, blocks);
                writer.writeComment("End of block " + i);
                continue;
            }
            writer.writeComment(" Block not found: " + i + " ");
        }
        TreeMap<String, String> data = new TreeMap<String, String>(TypeStrings.COMPARATOR);
        data.putAll(this.mData);
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            writer.writeStartElement("item");
            writer.writeAttribute("name", key);
            if (value.startsWith("fraction:")) {
                writer.writeAttribute("type", "fraction");
                value = value.substring("fraction:".length());
            }
            writer.writeCharacters(value);
            writer.writeEndElement();
        }
    }
}

