/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.resbuilder.type.styles;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamWriter;
import org.holoeverywhere.resbuilder.BuildMojo;
import org.holoeverywhere.resbuilder.type.FileProcesser;
import org.holoeverywhere.resbuilder.type.TypeProcesser;
import org.holoeverywhere.resbuilder.type.styles.Block;
import org.holoeverywhere.resbuilder.type.styles.IncludeRow;
import org.json.JSONArray;
import org.json.JSONObject;

@TypeProcesser.Type(value="styles")
public class TypeStyles
extends TypeProcesser {
    @Override
    public StylesProcessResult process(BuildMojo mojo, JSONObject json) {
        Block block;
        String key;
        StylesProcessResult result = new StylesProcessResult(this);
        if (json.has("include")) {
            JSONArray include = json.optJSONArray("include");
            for (int i = 0; i < include.length(); ++i) {
                result.include.add(new IncludeRow().parseRaw(include.opt(i)));
            }
        }
        if (json.has("blocks")) {
            JSONObject blocks = json.optJSONObject("blocks");
            Iterator keys = blocks.sortedKeys();
            while (keys.hasNext()) {
                key = (String)keys.next();
                block = new Block().parse(blocks.optJSONObject(key), key);
                result.blocks.put(block.getName(), block);
            }
        }
        if (json.has("data")) {
            JSONObject data = json.optJSONObject("data");
            Iterator keys = data.sortedKeys();
            while (keys.hasNext()) {
                key = (String)keys.next();
                block = new Block().parse(data.optJSONObject(key), key);
                result.data.put(block.getName(), block);
            }
        }
        result.output = json.optString("output");
        return result;
    }

    public static final class StylesProcessResult
    extends FileProcesser.ProcessResult {
        private static final Comparator<String> COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        private static final long serialVersionUID = -924473887807390792L;
        public Map<String, Block> blocks = new HashMap<String, Block>();
        public Map<String, Block> data = new HashMap<String, Block>();
        public List<IncludeRow> include = new ArrayList<IncludeRow>();
        public String output;
        private final TypeStyles processer;

        private StylesProcessResult(TypeStyles processer) {
            this.processer = processer;
        }

        @Override
        public void flush(BuildMojo mojo) throws FileProcesser.FileProcesserException {
            if (this.output == null || this.output.length() == 0) {
                mojo.getLog().warn((CharSequence)"Output field not set, skip this block");
                return;
            }
            HashMap<String, Block> blocks = new HashMap<String, Block>(this.blocks);
            HashMap<String, Block> dataS = new HashMap<String, Block>(this.data);
            for (IncludeRow i : this.include) {
                i.process(this.processer, mojo, blocks, dataS);
            }
            TreeMap<String, Block> data = new TreeMap<String, Block>(COMPARATOR);
            data.putAll(dataS);
            XMLStreamWriter writer = this.openWriter(mojo, null, this.output);
            try {
                for (Map.Entry entry : data.entrySet()) {
                    writer.writeStartElement("style");
                    writer.writeAttribute("name", ((Block)entry.getValue()).getName());
                    ((Block)entry.getValue()).process(writer, blocks);
                    writer.writeEndElement();
                }
            }
            catch (Exception e) {
                throw new FileProcesser.FileProcesserException(e);
            }
        }
    }
}

