/*
 * Decompiled with CFR 0.152.
 */
package org.hothub.core;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.hothub.base.ContentType;
import org.hothub.cookie.CookieManager;
import org.hothub.core.AbstractAttribute;
import org.hothub.core.AbstractBuilder;
import org.hothub.core.ssl.SSLManager;
import org.hothub.manager.ContextManager;
import org.hothub.pojo.FileBody;
import org.hothub.utils.RequestClientUtils;

public class RequestBuild
extends AbstractAttribute {
    private AbstractBuilder mAbstractBuilder;
    private Request.Builder builder = new Request.Builder();

    public RequestBuild(AbstractBuilder abstractBuilder) {
        if (abstractBuilder == null) {
            throw new IllegalArgumentException("builder is must not null");
        }
        if (RequestClientUtils.isEmpty(abstractBuilder.url)) {
            throw new IllegalArgumentException("request url is must not null");
        }
        this.mAbstractBuilder = abstractBuilder;
        this.url = abstractBuilder.url;
        this.params = abstractBuilder.params;
        this.headers = abstractBuilder.headers;
        this.cookies = abstractBuilder.cookies;
        this.bodyString = abstractBuilder.bodyString;
        this.bodyFile = abstractBuilder.bodyFile;
        this.useCookie = abstractBuilder.useCookie;
        this.contentType = abstractBuilder.contentType;
        this.readTimeOut = abstractBuilder.readTimeOut;
        this.writeTimeOut = abstractBuilder.writeTimeOut;
        this.connTimeOut = abstractBuilder.connTimeOut;
        this.followRedirects = abstractBuilder.followRedirects;
        this.followSslRedirects = abstractBuilder.followSslRedirects;
        this.proxyHost = abstractBuilder.proxyHost;
        this.proxyPort = abstractBuilder.proxyPort;
        this.certificate = abstractBuilder.certificate;
        this.builder.url(this.buildRequestParam());
    }

    public Request buildRequest() {
        Request.Builder methodBuild = null;
        switch (this.mAbstractBuilder.getRequestMethod()) {
            case GET: {
                methodBuild = this.builder.get();
                break;
            }
            case POST: {
                methodBuild = this.builder.post(this.buildRequestBody());
                break;
            }
            case PUT: {
                methodBuild = this.builder.put(this.buildRequestBody());
                break;
            }
            case DELETE: {
                methodBuild = this.builder.delete(this.buildRequestBody());
                break;
            }
        }
        methodBuild = this.buildRequestHeader(methodBuild);
        this.buildRequestCookie();
        return methodBuild == null ? null : methodBuild.build();
    }

    private RequestBody buildRequestBody() {
        if (this.bodyFile == null || this.bodyFile.isEmpty()) {
            FormBody.Builder formBodyBuilder = new FormBody.Builder();
            if (this.bodyString != null && !this.bodyString.isEmpty()) {
                for (Map.Entry stringStringEntry : this.bodyString.entrySet()) {
                    formBodyBuilder.add((String)stringStringEntry.getKey(), (String)stringStringEntry.getValue());
                }
            }
            return formBodyBuilder.build();
        }
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (this.bodyString != null && !this.bodyString.isEmpty()) {
            for (Map.Entry stringStringEntry : this.bodyString.entrySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + (String)stringStringEntry.getKey() + "\""}), RequestBody.create((MediaType)ContentType.get(this.contentType), (String)((String)stringStringEntry.getValue())));
            }
        }
        for (Map.Entry stringFileBodyEntry : this.bodyFile.entrySet()) {
            FileBody fileBody = (FileBody)stringFileBodyEntry.getValue();
            if (fileBody == null) continue;
            if (fileBody.getFile() != null) {
                builder.addFormDataPart(fileBody.getKey(), fileBody.getFileName(), RequestBody.create((MediaType)MediaType.parse((String)RequestClientUtils.guessMimeType(fileBody.getFileName())), (File)fileBody.getFile()));
                continue;
            }
            if (fileBody.getFileByte() == null) continue;
            builder.addFormDataPart(fileBody.getKey(), fileBody.getFileName(), RequestBody.create((MediaType)MediaType.parse((String)RequestClientUtils.guessMimeType(fileBody.getFileName())), (byte[])fileBody.getFileByte()));
        }
        return builder.build();
    }

    private String buildRequestParam() {
        if (this.url == null || this.params == null || this.params.isEmpty()) {
            return this.url;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry stringStringEntry : this.params.entrySet()) {
                stringBuilder.append(String.format("&%s=%s", stringStringEntry.getKey(), URLEncoder.encode((String)stringStringEntry.getValue(), "utf-8")));
            }
            return this.url + (RequestClientUtils.isEmpty(stringBuilder) ? "" : (this.url.lastIndexOf("?") > 0 ? stringBuilder : "?" + stringBuilder.substring(1)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return this.url;
        }
    }

    private Request.Builder buildRequestHeader(Request.Builder builder) {
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry entry : this.headers.entrySet()) {
                builder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return builder;
    }

    private void buildRequestCookie() {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            HttpUrl httpUrl = HttpUrl.parse((String)this.url);
            if (httpUrl == null) {
                return;
            }
            LinkedHashSet<Cookie> originCookie = ContextManager.get(httpUrl.host(), LinkedHashSet.class);
            if (originCookie == null) {
                originCookie = new LinkedHashSet<Cookie>();
            }
            for (Map.Entry entry : this.cookies.entrySet()) {
                originCookie.add(new Cookie.Builder().name((String)entry.getKey()).value((String)entry.getValue()).domain(httpUrl.host()).build());
            }
            ContextManager.set(httpUrl.host(), originCookie);
        }
    }

    public OkHttpClient getOkHttpClient() {
        return this.configOkHttpClient(RequestBuild.getInstance());
    }

    private List<Cookie> getRequestCookie() {
        HttpUrl httpUrl = HttpUrl.parse((String)this.url);
        LinkedHashSet cookieSet = httpUrl != null ? ContextManager.get(httpUrl.host(), LinkedHashSet.class) : null;
        return cookieSet == null ? null : new ArrayList(cookieSet);
    }

    public List<Cookie> getResponseCookie() {
        HttpUrl httpUrl = HttpUrl.parse((String)this.url);
        LinkedHashSet cookieSet = httpUrl != null ? ContextManager.get(httpUrl.host(), LinkedHashSet.class) : null;
        return cookieSet == null ? null : new ArrayList(cookieSet);
    }

    public static OkHttpClient getInstance() {
        return OkhttpClientInstance.okHttpClient;
    }

    private OkHttpClient configOkHttpClient(OkHttpClient okHttpClient) {
        if (!(this.readTimeOut > 0L || this.writeTimeOut > 0L || this.connTimeOut > 0L || this.followRedirects || this.followSslRedirects || this.useCookie || this.isUseSSL() || !RequestClientUtils.isEmpty(this.proxyHost) || this.useCookie)) {
            return okHttpClient;
        }
        OkHttpClient.Builder okhttpClientBuilder = okHttpClient.newBuilder();
        okhttpClientBuilder.followRedirects(this.followRedirects).followSslRedirects(this.followSslRedirects).readTimeout(this.readTimeOut > 0L ? this.readTimeOut : 3000L, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeOut > 0L ? this.writeTimeOut : 3000L, TimeUnit.MILLISECONDS).connectTimeout(this.connTimeOut > 0L ? this.connTimeOut : 3000L, TimeUnit.MILLISECONDS);
        if (!RequestClientUtils.isEmpty(this.proxyHost) && this.proxyPort != null && this.proxyPort > 0) {
            okhttpClientBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort)));
        }
        if (this.useCookie) {
            okhttpClientBuilder.cookieJar((CookieJar)new CookieManager(this.getRequestCookie()));
        }
        if (this.isUseSSL()) {
            if (this.certificate == null) {
                okhttpClientBuilder.sslSocketFactory(SSLManager.createSSLSocketFactory(), (X509TrustManager)new SSLManager.TrustAllCerts()).hostnameVerifier((HostnameVerifier)new SSLManager.TrustAllHostnameVerifier()).build();
            } else {
                okhttpClientBuilder.sslSocketFactory(SSLManager.createSSLSocketFactory(this.certificate)).hostnameVerifier((HostnameVerifier)new SSLManager.TrustAllHostnameVerifier()).build();
            }
        }
        return okhttpClientBuilder.build();
    }

    private boolean isUseSSL() {
        return !RequestClientUtils.isEmpty(this.url) && this.url.toLowerCase().startsWith("https");
    }

    private static class OkhttpClientInstance {
        private static OkHttpClient okHttpClient = new OkHttpClient.Builder().followSslRedirects(true).followRedirects(true).readTimeout(3000L, TimeUnit.MILLISECONDS).writeTimeout(3000L, TimeUnit.MILLISECONDS).connectTimeout(3000L, TimeUnit.MILLISECONDS).build();

        private OkhttpClientInstance() {
        }
    }
}

