/*
 * Decompiled with CFR 0.152.
 */
package org.hothub.cookie;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.hothub.manager.ContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieManager
implements CookieJar {
    public static final Logger logger = LoggerFactory.getLogger(CookieManager.class);
    private LinkedHashSet<Cookie> mCookieList;

    public CookieManager(List<Cookie> cookieList) {
        this.mCookieList = cookieList == null ? new LinkedHashSet() : new LinkedHashSet<Cookie>(cookieList);
    }

    public List<Cookie> loadForRequest(HttpUrl httpUrl) {
        LinkedHashSet<Cookie> cookiesList = (LinkedHashSet<Cookie>)ContextManager.get(httpUrl.host());
        if (cookiesList == null) {
            cookiesList = new LinkedHashSet<Cookie>();
        }
        if (!this.mCookieList.isEmpty()) {
            cookiesList.addAll(this.mCookieList);
        }
        return new ArrayList<Cookie>(cookiesList);
    }

    public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
        String host = httpUrl.host();
        LinkedHashSet<Cookie> newList = new LinkedHashSet<Cookie>(list);
        LinkedHashSet cookiesList = (LinkedHashSet)ContextManager.get(host);
        if (cookiesList != null) {
            newList.addAll(cookiesList);
        }
        ContextManager.set(host, newList);
    }
}

