/*
 * Decompiled with CFR 0.152.
 */
package org.hothub.core;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.hothub.base.OnRequestListener;
import org.hothub.base.RequestMethod;
import org.hothub.core.AbstractBuilderChain;
import org.hothub.core.RequestBuild;
import org.hothub.response.ResultBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBuilder<T extends AbstractBuilder>
extends AbstractBuilderChain<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBuilder.class);

    public ResultBody execute() {
        logger.info("RequestClient start execute with synchronous.");
        RequestBuild requestBuild = new RequestBuild(this);
        Request request = requestBuild.buildRequest();
        OkHttpClient okHttpClient = requestBuild.getOkHttpClient();
        Response response = null;
        try {
            response = okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ResultBody(request, response, this.url);
    }

    public void execute(final OnRequestListener onRequestListener) {
        logger.info("RequestClient start execute with asynchronous.");
        RequestBuild requestBuild = new RequestBuild(this);
        final Request request = requestBuild.buildRequest();
        OkHttpClient okHttpClient = requestBuild.getOkHttpClient();
        Call call = okHttpClient.newCall(request);
        call.enqueue(new Callback(){

            private ResultBody getResultBody(Response response) {
                return new ResultBody(request, response, AbstractBuilder.this.url);
            }

            public void onFailure(Call call, IOException e) {
                if (onRequestListener != null) {
                    onRequestListener.onFailure(this.getResultBody(null));
                }
            }

            public void onResponse(Call call, Response response) {
                if (onRequestListener != null) {
                    onRequestListener.onSuccess(this.getResultBody(response));
                }
            }
        });
    }

    public abstract RequestMethod getRequestMethod();
}

