/*
 * Decompiled with CFR 0.152.
 */
package org.hothub.response;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.hothub.manager.ContextManager;
import org.hothub.utils.RequestClientUtils;

public class ResultBody {
    private HttpUrl httpUrl;
    private Request request;
    private Response response;
    private ResponseBody responseBody;
    private List<Cookie> requestCookieList;
    private List<Cookie> responseCookieList;
    private String string;
    private byte[] bytes;
    private File file;
    private InputStream stream;
    private Reader reader;

    public ResultBody(Request request, Response response, String requestUrl) {
        this.request = request;
        this.response = response;
        this.httpUrl = HttpUrl.parse((String)requestUrl);
        this.responseBody = response != null ? response.body() : null;
        this.requestCookieList = request != null ? Cookie.parseAll((HttpUrl)this.httpUrl, (Headers)request.headers()) : Collections.EMPTY_LIST;
        this.responseCookieList = response != null ? Cookie.parseAll((HttpUrl)this.httpUrl, (Headers)response.headers()) : Collections.EMPTY_LIST;
        this.string = null;
        this.bytes = null;
        this.file = null;
        this.stream = null;
        this.reader = null;
        ContextManager.remove();
    }

    public String toString() {
        String result = null;
        if (RequestClientUtils.isEmpty(this.string)) {
            try {
                result = this.responseBody != null ? this.responseBody.string() : null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.string = result;
        }
        return this.string;
    }

    public byte[] toByte() {
        byte[] result = null;
        if (this.bytes == null) {
            try {
                result = this.responseBody != null ? this.responseBody.bytes() : null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bytes = result;
        }
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File toFile(String fileDirectory, String fileName) {
        File result = null;
        if (this.file == null) {
            InputStream inputStream = null;
            byte[] buf = new byte[2048];
            FileOutputStream fos = null;
            try {
                int len;
                inputStream = this.toStream();
                if (inputStream == null) {
                    File file = null;
                    return file;
                }
                File dir = new File(fileDirectory);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File file = new File(dir, fileName);
                fos = new FileOutputStream(file);
                while ((len = inputStream.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.flush();
                result = file;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.responseBody.close();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.file = result;
        }
        return this.file;
    }

    public InputStream toStream() {
        if (this.stream == null) {
            InputStream result;
            this.stream = result = this.responseBody != null ? this.responseBody.byteStream() : null;
        }
        return this.stream;
    }

    public Reader toReader() {
        if (this.reader == null) {
            Reader result;
            this.reader = result = this.responseBody != null ? this.responseBody.charStream() : null;
        }
        return this.reader;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public List<Cookie> getRequestCookie() {
        return this.requestCookieList;
    }

    public List<Cookie> getResponseCookie() {
        return this.responseCookieList;
    }
}

