/*
 * Decompiled with CFR 0.152.
 */
package org.hothub.base;

import java.nio.charset.Charset;
import okhttp3.MediaType;
import org.hothub.utils.CommonUtils;

public enum ContentType {
    URL_ENCODE("application/x-www-form-urlencoded"),
    JSON("application/json"),
    FORM_DATA("multipart/form-data");

    private String type;

    private ContentType(String type) {
        this.type = type;
    }

    public static MediaType get() {
        return ContentType.get(null, "utf-8");
    }

    public static MediaType get(ContentType contentType) {
        String mediaType = (contentType == null ? ContentType.URL_ENCODE.type : contentType.type) + "; charset=utf-8";
        return MediaType.parse((String)mediaType.toLowerCase());
    }

    public static MediaType get(ContentType contentType, String charset) {
        String mediaType = (contentType == null ? ContentType.URL_ENCODE.type : contentType.type) + "; charset=" + Charset.forName(CommonUtils.isEmpty(charset) ? "utf-8" : charset);
        return MediaType.parse((String)mediaType.toLowerCase());
    }
}

