/*
 * Decompiled with CFR 0.152.
 */
package org.hothub.core;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.hothub.base.RequestMethod;
import org.hothub.cookie.CookieHandler;
import org.hothub.core.AbstractBuilderChain;
import org.hothub.core.RequestHandler;
import org.hothub.http.OnRequestListener;
import org.hothub.http.SSLManager;
import org.hothub.response.ResultBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBuilder<T extends AbstractBuilder>
extends AbstractBuilderChain<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBuilder.class);

    public ResultBody execute() {
        RequestHandler abstractRequest = new RequestHandler(this);
        Response response = null;
        Request request = abstractRequest.buildRequest();
        OkHttpClient okHttpClient = this.getOkHttpClient(abstractRequest);
        try {
            response = okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ResultBody(request, response);
    }

    public void execute(final OnRequestListener onRequestListener) {
        logger.info("entry - execute");
        RequestHandler abstractRequest = new RequestHandler(this);
        Request request = abstractRequest.buildRequest();
        OkHttpClient okHttpClient = this.getOkHttpClient(abstractRequest);
        Call call = okHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (onRequestListener != null) {
                    onRequestListener.onFailure(null);
                }
            }

            public void onResponse(Call call, Response response) {
                if (onRequestListener != null) {
                    onRequestListener.onSuccess(null);
                }
            }
        });
    }

    private OkHttpClient getOkHttpClient(RequestHandler abstractRequest) {
        this.readTimeOut = this.readTimeOut > 0L ? this.readTimeOut : 3000L;
        this.writeTimeOut = this.writeTimeOut > 0L ? this.writeTimeOut : 3000L;
        this.connTimeOut = this.connTimeOut > 0L ? this.connTimeOut : 3000L;
        OkHttpClient.Builder okHttpClientBuild = new OkHttpClient.Builder().sslSocketFactory(SSLManager.createSSLSocketFactory(), (X509TrustManager)new SSLManager.TrustAllCerts()).readTimeout(this.readTimeOut, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeOut, TimeUnit.MILLISECONDS).connectTimeout(this.connTimeOut, TimeUnit.MILLISECONDS).hostnameVerifier((HostnameVerifier)new SSLManager.TrustAllHostnameVerifier());
        if (abstractRequest.useCookie) {
            okHttpClientBuild.cookieJar((CookieJar)new CookieHandler());
        }
        if (abstractRequest.isUseSSL()) {
            return okHttpClientBuild.build();
        }
        return okHttpClientBuild.sslSocketFactory(SSLManager.createSSLSocketFactory(), (X509TrustManager)new SSLManager.TrustAllCerts()).hostnameVerifier((HostnameVerifier)new SSLManager.TrustAllHostnameVerifier()).build();
    }

    public abstract RequestMethod getRequestMethod();
}

