/*
 * Decompiled with CFR 0.152.
 */
package org.hothub.core;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.hothub.base.ContentType;
import org.hothub.core.AbstractAttribute;
import org.hothub.core.AbstractBuilder;
import org.hothub.pojo.FileBody;
import org.hothub.utils.CommonUtils;

public class RequestHandler
extends AbstractAttribute {
    private AbstractBuilder mAbstractBuilder;
    private Request.Builder builder = new Request.Builder();

    public RequestHandler(AbstractBuilder abstractBuilder) {
        if (abstractBuilder == null) {
            throw new IllegalArgumentException("builder is must not null");
        }
        if (CommonUtils.isEmpty(abstractBuilder.url)) {
            throw new IllegalArgumentException("request url is must not null");
        }
        this.mAbstractBuilder = abstractBuilder;
        this.url = abstractBuilder.url;
        this.params = abstractBuilder.params;
        this.headers = abstractBuilder.headers;
        this.cookies = abstractBuilder.cookies;
        this.bodyString = abstractBuilder.bodyString;
        this.bodyFile = abstractBuilder.bodyFile;
        this.useCookie = abstractBuilder.useCookie;
        this.builder.url(this.buildRequestParam());
    }

    public boolean isUseSSL() {
        return !CommonUtils.isEmpty(this.url) && this.url.toLowerCase().startsWith("https");
    }

    public Request buildRequest() {
        Request.Builder methodBuild = null;
        switch (this.mAbstractBuilder.getRequestMethod()) {
            case GET: {
                methodBuild = this.builder.get();
                break;
            }
            case POST: {
                methodBuild = this.builder.post(this.buildRequestBody());
                break;
            }
            case PUT: {
                methodBuild = this.builder.put(this.buildRequestBody());
                break;
            }
            case DELETE: {
                methodBuild = this.builder.delete(this.buildRequestBody());
                break;
            }
        }
        methodBuild = this.buildRequestHeader(methodBuild);
        return methodBuild == null ? null : methodBuild.build();
    }

    private RequestBody buildRequestBody() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (this.bodyString != null && !this.bodyString.isEmpty()) {
            for (Map.Entry stringStringEntry : this.bodyString.entrySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + (String)stringStringEntry.getKey() + "\""}), RequestBody.create((MediaType)ContentType.get(this.contentType), (String)((String)stringStringEntry.getValue())));
            }
        }
        if (this.bodyFile != null && !this.bodyFile.isEmpty()) {
            for (Map.Entry stringFileBodyEntry : this.bodyFile.entrySet()) {
                FileBody fileBody = (FileBody)stringFileBodyEntry.getValue();
                if (fileBody == null) continue;
                if (fileBody.getFile() != null) {
                    builder.addFormDataPart(fileBody.getKey(), fileBody.getFileName(), RequestBody.create((MediaType)MediaType.parse((String)CommonUtils.guessMimeType(fileBody.getFileName())), (File)fileBody.getFile()));
                    continue;
                }
                if (fileBody.getFileByte() == null) continue;
                builder.addFormDataPart(fileBody.getKey(), fileBody.getFileName(), RequestBody.create((MediaType)MediaType.parse((String)CommonUtils.guessMimeType(fileBody.getFileName())), (byte[])fileBody.getFileByte()));
            }
        }
        return builder.build();
    }

    private String buildRequestParam() {
        if (this.url == null || this.params == null || this.params.isEmpty()) {
            return this.url;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry stringStringEntry : this.params.entrySet()) {
                stringBuilder.append(String.format("&%s=%s", stringStringEntry.getKey(), URLEncoder.encode((String)stringStringEntry.getValue(), "utf-8")));
            }
            return this.url + (CommonUtils.isEmpty(stringBuilder) ? "" : (this.url.lastIndexOf("?") > 0 ? stringBuilder : "?" + stringBuilder.substring(1)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return this.url;
        }
    }

    private Request.Builder buildRequestHeader(Request.Builder builder) {
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry entry : this.headers.entrySet()) {
                builder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return builder;
    }
}

