/*
 * Decompiled with CFR 0.152.
 */
package org.hothub.manager;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextManager {
    private static final Logger logger = LoggerFactory.getLogger(ContextManager.class);
    private static final ThreadLocal<Map<String, Object>> MANAGER_MAP = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    protected ContextManager() {
    }

    public static Object get(String attribute) {
        Map<String, Object> map = MANAGER_MAP.get();
        return map != null ? map.get(attribute) : null;
    }

    public static <T> T get(String attribute, Class<T> clazz) {
        return (T)ContextManager.get(attribute);
    }

    public static void set(String key, Object value) {
        Map<String, Object> map = MANAGER_MAP.get();
        map.put(key, value);
        MANAGER_MAP.set(map);
    }

    public static void remove() {
        logger.info("THREADLOCAL - REMOVE");
        MANAGER_MAP.remove();
    }
}

