/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.resources.GeneratorMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.document.PortType;
import com.sun.xml.bind.api.JAXBRIContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import org.xml.sax.Locator;

public class ServiceGenerator
extends GeneratorBase {
    public static void generate(Model model, WsimportOptions options, ErrorReceiver receiver) {
        ServiceGenerator serviceGenerator = new ServiceGenerator(model, options, receiver);
        serviceGenerator.doGeneration();
    }

    private ServiceGenerator(Model model, WsimportOptions options, ErrorReceiver receiver) {
        super(model, options, receiver);
    }

    public void visit(Service service) {
        JDefinedClass cls;
        JavaInterface intf = service.getJavaInterface();
        String className = Names.customJavaTypeClassName(intf);
        if (this.donotOverride && GeneratorUtil.classExists(this.options, className)) {
            this.log("Class " + className + " exists. Not overriding.");
            return;
        }
        try {
            cls = this.getClass(className, ClassType.CLASS);
        }
        catch (JClassAlreadyExistsException e) {
            this.receiver.error(service.getLocator(), GeneratorMessages.GENERATOR_SERVICE_CLASS_ALREADY_EXIST(className, service.getName()));
            return;
        }
        cls._extends(javax.xml.ws.Service.class);
        String serviceFieldName = JAXBRIContext.mangleNameToClassName(service.getName().getLocalPart()).toUpperCase();
        String wsdlLocationName = serviceFieldName + "_WSDL_LOCATION";
        JFieldVar urlField = cls.field(28, URL.class, wsdlLocationName);
        cls.field(28, Logger.class, "logger", (JExpression)this.cm.ref(Logger.class).staticInvoke("getLogger").arg(JExpr.dotclass(this.cm.ref(className)).invoke("getName")));
        JClass qNameCls = this.cm.ref(QName.class);
        JInvocation inv = JExpr._new(qNameCls);
        inv.arg("namespace");
        inv.arg("localpart");
        JBlock staticBlock = cls.init();
        JVar urlVar = staticBlock.decl(this.cm.ref(URL.class), "url", JExpr._null());
        JTryBlock tryBlock = staticBlock._try();
        JVar baseUrl = tryBlock.body().decl(this.cm.ref(URL.class), "baseUrl");
        tryBlock.body().assign(baseUrl, JExpr.dotclass(this.cm.ref(className)).invoke("getResource").arg("."));
        tryBlock.body().assign(urlVar, JExpr._new(this.cm.ref(URL.class)).arg(baseUrl).arg(this.wsdlLocation));
        JCatchBlock catchBlock = tryBlock._catch(this.cm.ref(MalformedURLException.class));
        catchBlock.param("e");
        catchBlock.body().directStatement("logger.warning(\"Failed to create URL for the wsdl Location: " + JExpr.quotify('\'', this.wsdlLocation) + ", retrying as a local file\");");
        catchBlock.body().directStatement("logger.warning(e.getMessage());");
        staticBlock.assign(urlField, urlVar);
        JDocComment comment = cls.javadoc();
        if (service.getJavaDoc() != null) {
            comment.add(service.getJavaDoc());
            comment.add("\n\n");
        }
        for (String doc : this.getJAXWSClassComment()) {
            comment.add(doc);
        }
        JMethod constructor = cls.constructor(1);
        constructor.param(URL.class, "wsdlLocation");
        constructor.param(QName.class, "serviceName");
        constructor.body().directStatement("super(wsdlLocation, serviceName);");
        constructor = cls.constructor(1);
        constructor.body().directStatement("super(" + wsdlLocationName + ", new QName(\"" + service.getName().getNamespaceURI() + "\", \"" + service.getName().getLocalPart() + "\"));");
        JAnnotationUse webServiceClientAnn = cls.annotate(this.cm.ref(WebServiceClient.class));
        this.writeWebServiceClientAnnotation(service, webServiceClientAnn);
        this.writeHandlerConfig(Names.customJavaTypeClassName(service.getJavaInterface()), cls, this.options);
        for (Port port : service.getPorts()) {
            JDefinedClass retType;
            if (port.isProvider()) continue;
            try {
                retType = this.getClass(port.getJavaInterface().getName(), ClassType.INTERFACE);
            }
            catch (JClassAlreadyExistsException e) {
                PortType pt;
                QName portTypeName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLPortTypeName");
                Locator loc = null;
                if (portTypeName != null && (pt = port.portTypes.get(portTypeName)) != null) {
                    loc = pt.getLocator();
                }
                this.receiver.error(loc, GeneratorMessages.GENERATOR_SEI_CLASS_ALREADY_EXIST(port.getJavaInterface().getName(), portTypeName));
                return;
            }
            this.writeDefaultGetPort(port, retType, cls);
            if (!this.options.target.isLaterThan(Options.Target.V2_1)) continue;
            this.writeGetPort(port, retType, cls);
        }
    }

    private void writeGetPort(Port port, JType retType, JDefinedClass cls) {
        JMethod m = cls.method(1, retType, port.getPortGetter());
        JDocComment methodDoc = m.javadoc();
        if (port.getJavaDoc() != null) {
            methodDoc.add(port.getJavaDoc());
        }
        JCommentPart ret = methodDoc.addReturn();
        JCommentPart paramDoc = methodDoc.addParam("features");
        paramDoc.append("A list of ");
        paramDoc.append("{@link " + WebServiceFeature.class.getName() + "}");
        paramDoc.append("to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.");
        ret.add("returns " + retType.name());
        m.varParam(WebServiceFeature.class, "features");
        JBlock body = m.body();
        StringBuffer statement = new StringBuffer("return ");
        statement.append("super.getPort(new QName(\"").append(port.getName().getNamespaceURI()).append("\", \"").append(port.getName().getLocalPart()).append("\"), ");
        statement.append(retType.name());
        statement.append(".class, features);");
        body.directStatement(statement.toString());
        this.writeWebEndpoint(port, m);
    }

    private void writeDefaultGetPort(Port port, JType retType, JDefinedClass cls) {
        String portGetter = port.getPortGetter();
        JMethod m = cls.method(1, retType, portGetter);
        JDocComment methodDoc = m.javadoc();
        if (port.getJavaDoc() != null) {
            methodDoc.add(port.getJavaDoc());
        }
        JCommentPart ret = methodDoc.addReturn();
        ret.add("returns " + retType.name());
        JBlock body = m.body();
        StringBuffer statement = new StringBuffer("return ");
        statement.append("super.getPort(new QName(\"").append(port.getName().getNamespaceURI()).append("\", \"").append(port.getName().getLocalPart()).append("\"), ");
        statement.append(retType.name());
        statement.append(".class);");
        body.directStatement(statement.toString());
        this.writeWebEndpoint(port, m);
    }

    private void writeWebServiceClientAnnotation(Service service, JAnnotationUse wsa) {
        String serviceName = service.getName().getLocalPart();
        String serviceNS = service.getName().getNamespaceURI();
        wsa.param("name", serviceName);
        wsa.param("targetNamespace", serviceNS);
        wsa.param("wsdlLocation", this.wsdlLocation);
    }

    private void writeWebEndpoint(Port port, JMethod m) {
        JAnnotationUse webEndpointAnn = m.annotate(this.cm.ref(WebEndpoint.class));
        webEndpointAnn.param("name", port.getName().getLocalPart());
    }
}

