/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing.metadata;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;

public class ServiceName {
    public static final QName subQName = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ServiceName", "wsa");
    public static final QName wsamQName = new QName("http://www.w3.org/2007/05/addressing/metadata", "ServiceName", "wsam");
    public static final QName wsawQName = new QName("http://www.w3.org/2006/05/addressing/wsdl", "ServiceName", "wsaw");
    private QName name;
    private String endpointName;

    public ServiceName() {
    }

    public ServiceName(QName name) {
        this.name = name;
    }

    public ServiceName(QName name, String endpointName) {
        this.name = name;
        this.endpointName = endpointName;
    }

    public QName getName() {
        return this.name;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public OMElement toOM(OMFactory factory, QName qname2) throws AxisFault {
        String localName = qname2.getLocalPart();
        if (!"ServiceName".equals(localName)) {
            throw new AxisFault("The local name must be 'ServiceName'.");
        }
        String prefix = qname2.getPrefix();
        if (prefix == null) {
            throw new AxisFault("The prefix cannot be null.");
        }
        String namespace = qname2.getNamespaceURI();
        if (namespace == null) {
            throw new AxisFault("The namespace canot be null.");
        }
        OMNamespace metadataNs = factory.createOMNamespace(namespace, prefix);
        OMElement element = factory.createOMElement(localName, metadataNs);
        element.setText(this.name);
        if (this.endpointName != null) {
            String attributeName = "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace) ? "PortName" : "EndpointName";
            element.addAttribute(attributeName, this.endpointName, null);
        }
        return element;
    }

    public void fromOM(OMElement omElement) throws AxisFault {
        QName qname2 = omElement.getQName();
        String attributeName = null;
        if (wsamQName.equals(qname2) || wsawQName.equals(qname2)) {
            attributeName = "EndpointName";
        } else if (subQName.equals(qname2)) {
            attributeName = "PortName";
        } else {
            throw new AxisFault("Unrecognized element.");
        }
        this.name = omElement.getTextAsQName();
        this.endpointName = omElement.getAttributeValue(new QName(attributeName));
    }

    public static boolean isServiceNameElement(OMElement omElement) {
        boolean result = false;
        QName qname2 = omElement.getQName();
        if (wsamQName.equals(qname2) || wsawQName.equals(qname2) || subQName.equals(qname2)) {
            result = true;
        }
        return result;
    }
}

