/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectStreamConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugObjectInput
implements ObjectInput,
ObjectStreamConstants {
    private static final Log log = LogFactory.getLog(DebugObjectInput.class);
    private static final boolean isDebug = log.isDebugEnabled();
    ObjectInput oi;

    public DebugObjectInput(ObjectInput oi) {
        this.oi = oi;
    }

    public int available() throws IOException {
        this.trace("start available()");
        int value = this.oi.available();
        this.trace("end available() =" + value);
        return value;
    }

    public void close() throws IOException {
        this.trace("start close()");
        this.oi.close();
        this.trace("end close()");
    }

    public int read() throws IOException {
        this.trace("start read()");
        int value = this.oi.read();
        this.trace("end read()=" + value);
        return value;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.trace("start read(b, off, len) off=" + off + " len=" + len);
        int value = this.oi.read(b, off, len);
        this.trace("end read(b,off,len)=" + value);
        return value;
    }

    public int read(byte[] b) throws IOException {
        this.trace("start read(b) b.length=" + b.length);
        int value = this.oi.read(b);
        this.trace("end read(b)=" + value);
        return value;
    }

    public boolean readBoolean() throws IOException {
        this.trace("start readBoolean()");
        boolean value = this.oi.readBoolean();
        this.trace("end readBoolean()=" + value);
        return value;
    }

    public byte readByte() throws IOException {
        this.trace("start readByte");
        byte value = this.oi.readByte();
        this.trace("end readByte()=" + value);
        return value;
    }

    public char readChar() throws IOException {
        this.trace("start readChar");
        char value = this.oi.readChar();
        this.trace("end readChar()=" + value);
        return value;
    }

    public double readDouble() throws IOException {
        this.trace("start readDouble");
        double value = this.oi.readDouble();
        this.trace("end readDouble()=" + value);
        return value;
    }

    public float readFloat() throws IOException {
        this.trace("start readFloat");
        float value = this.oi.readFloat();
        this.trace("end readFloat()=" + value);
        return value;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.trace("start readFully(b,off,len) off=" + off + " len=" + len);
        this.oi.readFully(b, off, len);
        this.trace("end readFully(b,off,len)");
    }

    public void readFully(byte[] b) throws IOException {
        this.trace("start readFully(b) b.length=" + b.length);
        this.oi.readFully(b);
        this.trace("end readFully(b)");
    }

    public int readInt() throws IOException {
        this.trace("start readInt()");
        int value = this.oi.readInt();
        this.trace("end readInt()=" + value);
        return value;
    }

    public String readLine() throws IOException {
        this.trace("start readLine()");
        String value = this.oi.readLine();
        this.trace("end readLine()=" + value);
        return value;
    }

    public long readLong() throws IOException {
        this.trace("start readLong()");
        long value = this.oi.readLong();
        this.trace("end readLong()=" + value);
        return value;
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        this.trace("start readObject()");
        Object value = this.oi.readObject();
        this.trace("end readObject()=" + this.valueName(value));
        return value;
    }

    public short readShort() throws IOException {
        this.trace("start readShort()");
        short value = this.oi.readShort();
        this.trace("end readShort()=" + value);
        return value;
    }

    public int readUnsignedByte() throws IOException {
        this.trace("start readLong()");
        int value = this.oi.readUnsignedByte();
        this.trace("end readUnsignedByte()=" + value);
        return value;
    }

    public int readUnsignedShort() throws IOException {
        this.trace("start readShort()");
        int value = this.oi.readUnsignedShort();
        this.trace("end readShort()=" + value);
        return value;
    }

    public String readUTF() throws IOException {
        this.trace("start readUTF()");
        String value = this.oi.readUTF();
        this.trace("end readUTF()=" + value);
        return value;
    }

    public long skip(long n) throws IOException {
        this.trace("start skip(n) n=" + n);
        long value = this.oi.skip(n);
        this.trace("end skip(n)=" + value);
        return value;
    }

    public int skipBytes(int n) throws IOException {
        this.trace("start skipBytes(n) n=" + n);
        int value = this.oi.skipBytes(n);
        this.trace("end skipBytes(n)=" + value);
        return value;
    }

    public void trace(String str) {
        if (isDebug) {
            log.debug(str);
        }
    }

    private String valueName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "Object of class = " + obj.getClass().getName();
    }
}

