/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import java.security.PrivilegedAction;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePartDataSource;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.datasource.jaxb.AttachmentContext;
import org.apache.axis2.java.security.AccessController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JAXBAttachmentMarshaller
extends AttachmentMarshaller {
    private static final Log log = LogFactory.getLog(JAXBAttachmentMarshaller.class);
    private final AttachmentContext context;
    private final XMLStreamWriter writer;
    private static final String APPLICATION_OCTET = "application/octet-stream";

    public JAXBAttachmentMarshaller(AttachmentContext context, XMLStreamWriter writer) {
        this.context = context;
        this.writer = writer;
    }

    public boolean isXOPPackage() {
        boolean value = false;
        value = this.context.isMTOMEnabled();
        if (!(this.writer instanceof MTOMXMLStreamWriter)) {
            if (log.isDebugEnabled()) {
                log.debug("The writer is not enabled for MTOM.  MTOM values will not be optimized");
            }
            value = false;
        }
        if (log.isDebugEnabled()) {
            log.debug("isXOPPackage returns " + value);
        }
        return value;
    }

    public final String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String namespace, String localPart) {
        if (offset != 0 || length != data.length) {
            int len = length - offset;
            byte[] newData = new byte[len];
            System.arraycopy(data, offset, newData, 0, len);
            data = newData;
        }
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = APPLICATION_OCTET;
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding MTOM/XOP byte array attachment for element: {" + namespace + "}" + localPart);
        }
        String cid = null;
        try {
            int optimizedThreshold;
            final InternetHeaders ih = new InternetHeaders();
            final byte[] dataArray = data;
            ih.setHeader("Content-Type", mimeType);
            final MimeBodyPart mbp = AccessController.doPrivileged(new PrivilegedAction<MimeBodyPart>(){

                @Override
                public MimeBodyPart run() {
                    try {
                        return new MimeBodyPart(ih, dataArray);
                    }
                    catch (MessagingException e) {
                        throw new OMException(e);
                    }
                }
            });
            MimePartDataSource mpds = AccessController.doPrivileged(new PrivilegedAction<MimePartDataSource>(){

                @Override
                public MimePartDataSource run() {
                    return new MimePartDataSource(mbp);
                }
            });
            long dataLength = data.length;
            Integer value = null;
            MessageContext msgContext = this.context.getMessageContext();
            if (msgContext != null) {
                value = (Integer)msgContext.getProperty("mtomThreshold");
            } else if (log.isDebugEnabled()) {
                log.debug("The msgContext is null so the MTOM threshold value can not be determined; it will default to 0.");
            }
            int n = optimizedThreshold = value != null ? value : 0;
            if (optimizedThreshold == 0 || dataLength > (long)optimizedThreshold) {
                DataHandler dataHandler = new DataHandler(mpds);
                cid = this.addDataHandler(dataHandler, false);
            }
            mbp.setHeader("Content-Id", cid);
        }
        catch (MessagingException e) {
            throw new OMException(e);
        }
        return cid == null ? null : "cid:" + cid;
    }

    public final String addMtomAttachment(DataHandler data, String namespace, String localPart) {
        String cid;
        if (log.isDebugEnabled()) {
            log.debug("Adding MTOM/XOP datahandler attachment for element: {" + namespace + "}" + localPart);
        }
        return (cid = this.addDataHandler(data, false)) == null ? null : "cid:" + cid;
    }

    public final String addSwaRefAttachment(DataHandler data) {
        if (log.isDebugEnabled()) {
            log.debug("Adding SWAREF attachment");
        }
        String cid = this.addDataHandler(data, true);
        this.context.setDoingSWA();
        return "cid:" + cid;
    }

    private String addDataHandler(DataHandler dh, boolean isSWA) {
        String cid = null;
        if (isSWA) {
            if (log.isDebugEnabled()) {
                log.debug("adding DataHandler for SWA");
            }
            cid = UIDGenerator.generateContentId();
            this.context.addDataHandler(dh, cid);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("adding DataHandler for MTOM");
            }
            if (this.writer instanceof MTOMXMLStreamWriter) {
                cid = ((MTOMXMLStreamWriter)this.writer).prepareDataHandler(dh);
                if (cid != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("The MTOM attachment is written as an attachment part.");
                    }
                    this.context.addDataHandler(dh, cid);
                } else if (log.isDebugEnabled()) {
                    log.debug("The MTOM attachment is inlined.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("writer is not MTOM capable.  The attachment will be inlined.");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("   content id=" + cid);
            log.debug("   dataHandler  =" + dh);
        }
        return cid;
    }
}

