/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisBinding
extends AxisDescription {
    private QName name;
    private String type;
    private Map<String, Object> options = new HashMap<String, Object>();
    private Map<String, AxisBindingMessage> faults = new HashMap<String, AxisBindingMessage>();

    public AxisBindingMessage getFault(String name) {
        return this.faults.get(name);
    }

    public void addFault(AxisBindingMessage fault) {
        this.faults.put(fault.getName(), fault);
    }

    public void setProperty(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getProperty(String name) {
        Object obj = this.options.get(name);
        if (obj != null) {
            return obj;
        }
        if ("wsoap:version".equals(name) && "http://www.w3.org/ns/wsdl/http".equals(this.type)) {
            return null;
        }
        obj = WSDL20DefaultValueHolder.getDefaultValue(name);
        return obj;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Object getKey() {
        return null;
    }

    @Override
    public void engageModule(AxisModule axisModule) throws AxisFault {
        throw new UnsupportedOperationException("Sorry we do not support this");
    }

    @Override
    public boolean isEngaged(String moduleName) {
        throw new UnsupportedOperationException("axisMessage.isEngaged() is not supported");
    }

    public OMElement toWSDL20(OMNamespace wsdl, OMNamespace tns, OMNamespace wsoap, OMNamespace whttp, String interfaceName, Map nameSpaceMap, String addressingFlag, String serviceName, OMNamespace wsaw) {
        String property;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement bindingElement = omFactory.createOMElement("binding", wsdl);
        bindingElement.addAttribute(omFactory.createOMAttribute("name", null, this.name.getLocalPart()));
        bindingElement.addAttribute(omFactory.createOMAttribute("interface", null, tns.getPrefix() + ":" + interfaceName));
        if ("http://www.w3.org/ns/wsdl/soap".equals(this.type) || "http://schemas.xmlsoap.org/soap/http".equals(this.type) || "http://www.w3.org/2003/05/http".equals(this.type)) {
            ArrayList soapModules;
            bindingElement.addAttribute(omFactory.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/soap"));
            property = (String)this.options.get("wsoap:version");
            if (property != null) {
                if ("http://schemas.xmlsoap.org/soap/envelope/".equals(property)) {
                    bindingElement.addAttribute(omFactory.createOMAttribute("version", wsoap, "1.1"));
                } else {
                    bindingElement.addAttribute(omFactory.createOMAttribute("version", wsoap, "1.2"));
                }
            }
            if ((property = (String)this.options.get("wsoap:protocol")) != null) {
                bindingElement.addAttribute(omFactory.createOMAttribute("protocol", wsoap, property));
            }
            if ((property = (String)this.options.get("wsoap:mep")) != null) {
                bindingElement.addAttribute(omFactory.createOMAttribute("mepDefault", wsoap, property));
            }
            if ((soapModules = (ArrayList)this.options.get("wsoap:module")) != null && soapModules.size() > 0) {
                WSDLSerializationUtil.addSOAPModuleElements(omFactory, soapModules, wsoap, bindingElement);
            }
            WSDLSerializationUtil.addWSAddressingToBinding(addressingFlag, omFactory, bindingElement, wsaw);
        } else if ("http://www.w3.org/ns/wsdl/http".equals(this.type)) {
            property = (String)this.options.get("whttp:method");
            if (property != null) {
                bindingElement.addAttribute(omFactory.createOMAttribute("methodDefault", whttp, property));
            }
            bindingElement.addAttribute(omFactory.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/http"));
        }
        property = (String)this.options.get("whttp:contentEncoding");
        if (property != null) {
            bindingElement.addAttribute(omFactory.createOMAttribute("contentEncodingDefault", whttp, property));
        }
        if ((property = (String)this.options.get("whttp:queryParameterSeparator")) != null) {
            bindingElement.addAttribute(omFactory.createOMAttribute("queryParameterSeparatorDefault", whttp, property));
        }
        if (this.faults != null) {
            for (AxisBindingMessage axisBindingFault : this.faults.values()) {
                OMElement omElement = axisBindingFault.toWSDL20(wsdl, tns, wsoap, whttp, nameSpaceMap);
                omElement.setLocalName("fault");
                bindingElement.addChild(omElement);
            }
        }
        Iterator<AxisDescription> iterator = this.getChildren();
        while (iterator.hasNext()) {
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)iterator.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation != null && axisOperation.isControlOperation()) continue;
            bindingElement.addChild(axisBindingOperation.toWSDL20(wsdl, tns, wsoap, whttp, this.type, nameSpaceMap, serviceName));
        }
        WSDLSerializationUtil.addWSDLDocumentationElement(this, bindingElement, omFactory, wsdl);
        WSDLSerializationUtil.addPoliciesAsExtensibleElement(this, bindingElement);
        return bindingElement;
    }

    public Policy getEffectivePolicy() {
        PolicySubject servicePolicySubject;
        ArrayList<PolicyComponent> policyList = new ArrayList<PolicyComponent>();
        policyList.addAll(this.getPolicySubject().getAttachedPolicyComponents());
        AxisEndpoint axisEndpoint = this.getAxisEndpoint();
        if (axisEndpoint != null) {
            policyList.addAll(axisEndpoint.getPolicySubject().getAttachedPolicyComponents());
        }
        AxisService service = null;
        if (axisEndpoint != null) {
            service = axisEndpoint.getAxisService();
        }
        if (service != null && (servicePolicySubject = service.getPolicySubject()) != null) {
            policyList.addAll(servicePolicySubject.getAttachedPolicyComponents());
        }
        return PolicyUtil.getMergedPolicy(policyList, this);
    }

    public AxisEndpoint getAxisEndpoint() {
        return (AxisEndpoint)this.parent;
    }

    public Iterator<AxisBindingOperation> getChildren() {
        return super.getChildren();
    }

    @Override
    public void applyPolicy() throws AxisFault {
        this.getAxisEndpoint().getAxisService().applyPolicy();
    }
}

