/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.async;

import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncUtils {
    private static final Log log = LogFactory.getLog(AsyncUtils.class);
    private static final boolean debug = log.isDebugEnabled();

    public static MessageContext createJAXWSMessageContext(org.apache.axis2.context.MessageContext mc) throws WebServiceException {
        MessageContext response = null;
        if (debug) {
            log.debug("Creating response MessageContext");
        }
        response = new MessageContext(mc);
        try {
            ThreadContextMigratorUtil.performMigrationToThread("JAXWS-ThreadContextMigrator-List", mc);
        }
        catch (Throwable t) {
            if (debug) {
                log.debug(mc.getLogIDString() + " An error occurred in the ThreadContextMigratorUtil " + t);
                log.debug("...caused by " + t.getCause());
            }
            throw ExceptionFactory.makeWebServiceException(t);
        }
        return response;
    }
}

