/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class URIResolverImpl
implements URIResolver {
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_PROTOCOL = "jar";
    private static final String BUNDLE_RESOURCE_PROTOCOL = "bundleresource";
    protected ClassLoader classLoader;
    private static final Log log = LogFactory.getLog(URIResolverImpl.class);

    public URIResolverImpl() {
    }

    public URIResolverImpl(ClassLoader cl) {
        this.classLoader = cl;
    }

    public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
        String pathURIStr;
        InputStream is;
        block29: {
            if (log.isDebugEnabled()) {
                log.debug("resolveEntity: [" + namespace + "][" + schemaLocation + "][ " + baseUri + "]");
            }
            is = null;
            URI pathURI = null;
            pathURIStr = null;
            if (log.isDebugEnabled()) {
                log.debug("Import location: " + schemaLocation + " parent document: " + baseUri);
            }
            if (baseUri != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Base URI not null");
                    }
                    if (this.isAbsolute(schemaLocation)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Retrieving input stream for absolute schema location: " + schemaLocation);
                        }
                        is = this.getInputStreamForURI(schemaLocation);
                        break block29;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("schemaLocation not in absolute path");
                    }
                    try {
                        pathURI = new URI(baseUri);
                    }
                    catch (URISyntaxException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Got URISyntaxException. Exception Message = " + e.getMessage());
                            log.debug("Implementing alternate way to create URI");
                        }
                        pathURI = new URI(null, null, baseUri, null);
                    }
                    pathURIStr = schemaLocation;
                    if (pathURI.isAbsolute()) {
                        URL url;
                        if (log.isDebugEnabled()) {
                            log.debug("Parent document is at absolute location: " + pathURI.toString());
                        }
                        if ((url = new URL(baseUri)) != null) {
                            URI tempURI;
                            try {
                                tempURI = new URI(url.getPath());
                            }
                            catch (URISyntaxException e) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Got URISyntaxException. Exception Message = " + e.getMessage());
                                    log.debug("Implementing alternate way to create URI");
                                }
                                tempURI = new URI(null, null, url.getPath(), null);
                            }
                            URI resolvedURI = tempURI.resolve(schemaLocation);
                            pathURIStr = this.constructPath(url, resolvedURI);
                            if (log.isDebugEnabled()) {
                                log.debug("Resolved this path to imported document: " + pathURIStr);
                            }
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Parent document is at relative location: " + pathURI.toString());
                        }
                        pathURI = pathURI.resolve(schemaLocation);
                        pathURIStr = pathURI.toString();
                        if (log.isDebugEnabled()) {
                            log.debug("Resolved this path to imported document: " + pathURIStr);
                        }
                    }
                    if (this.isAbsolute(pathURIStr)) {
                        is = this.getInputStreamForURI(pathURIStr);
                    }
                    if (is == null) {
                        is = this.classLoader.getResourceAsStream(pathURI.toString());
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block29;
                    log.debug("Exception occured in resolveEntity, ignoring exception continuing processing " + e.getMessage());
                    log.debug(e);
                }
            }
        }
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debug("XSD input stream is null after resolving import for: " + schemaLocation + " from parent document: " + baseUri);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("XSD input stream is not null after resolving import for: " + schemaLocation + " from parent document: " + baseUri);
        }
        InputSource returnInputSource = new InputSource(is);
        returnInputSource.setSystemId(pathURIStr != null ? pathURIStr : schemaLocation);
        if (log.isDebugEnabled()) {
            log.debug("returnInputSource :" + returnInputSource.getSystemId());
        }
        return returnInputSource;
    }

    protected boolean isAbsolute(String location) {
        boolean absolute = false;
        if (location.indexOf(":/") != -1) {
            absolute = true;
        } else if (location.indexOf(":\\") != -1) {
            absolute = true;
        } else if (location.indexOf("file:") != -1) {
            absolute = true;
        }
        return absolute;
    }

    protected InputStream getInputStreamForURI(String uri) {
        InputStream is;
        block10: {
            URL streamURL;
            block9: {
                URI pathURI;
                block8: {
                    streamURL = null;
                    is = null;
                    pathURI = null;
                    try {
                        streamURL = new URL(uri);
                        is = this.openStream_doPriv(streamURL);
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug("Exception occured in getInputStreamForURI, ignoring exception continuing processing: " + t.getMessage());
                    }
                }
                if (is == null) {
                    try {
                        pathURI = new URI(uri);
                        streamURL = pathURI.toURL();
                        is = this.openStream_doPriv(streamURL);
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) break block9;
                        log.debug("Exception occured in getInputStreamForURI, ignoring exception continuing processing: " + t.getMessage());
                    }
                }
            }
            if (is == null) {
                try {
                    final File file = new File(uri);
                    streamURL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws MalformedURLException {
                            return file.toURI().toURL();
                        }
                    });
                    is = this.openStream_doPriv(streamURL);
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block10;
                    log.debug("Exception occured in getInputStreamForURI, ignoring exception continuing processing: " + t.getMessage());
                }
            }
        }
        return is;
    }

    private InputStream openStream_doPriv(final URL streamURL) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return streamURL.openStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private String constructPath(URL baseURL, URI resolvedURI) {
        URL url = null;
        try {
            if (baseURL.getProtocol() != null && (baseURL.getProtocol().equals(HTTP_PROTOCOL) || baseURL.getProtocol().equals(HTTPS_PROTOCOL) || baseURL.getProtocol().equals(BUNDLE_RESOURCE_PROTOCOL))) {
                if (log.isDebugEnabled()) {
                    log.debug("Constructing path with http/https protocol");
                }
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), resolvedURI.toString());
                if (log.isDebugEnabled()) {
                    log.debug("URL = " + url);
                }
            } else if (baseURL.getProtocol() != null && baseURL.getProtocol().equals(FILE_PROTOCOL)) {
                if (log.isDebugEnabled()) {
                    log.debug("Constructing path with file protocol");
                }
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), resolvedURI.toString());
            } else if (baseURL.getProtocol() != null && baseURL.getProtocol().equals(JAR_PROTOCOL)) {
                if (log.isDebugEnabled()) {
                    log.debug("Constructing path with jar protocol");
                }
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), resolvedURI.toString());
            } else if (baseURL != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Constructing path with unknown protocol: " + baseURL.getProtocol());
                }
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), resolvedURI.toString());
            } else if (log.isDebugEnabled()) {
                log.debug("baseURL is NULL");
            }
        }
        catch (MalformedURLException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("schemaImportError", resolvedURI.toString(), baseURL.toString()), e);
        }
        if (url == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("schemaImportError", resolvedURI.toString(), baseURL.toString()));
        }
        String importLocation = url.toString();
        return importLocation;
    }
}

