/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.feature;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.feature.ServerConfigurator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerFramework {
    private static final Log log = LogFactory.getLog(ServerFramework.class);
    private static final Annotation[] ZERO_LENGTH_ARRAY = new Annotation[0];
    private Map<String, ServerConfigurator> configuratorMap = new HashMap<String, ServerConfigurator>();
    private Map<String, Annotation> annotationMap = new HashMap<String, Annotation>();

    public void addConfigurator(String id, ServerConfigurator configurator) {
        this.configuratorMap.put(id, configurator);
    }

    public boolean isValid(Annotation annotation2) {
        if (annotation2 == null) {
            return false;
        }
        WebServiceFeatureAnnotation wsfAnnotation = this.getWebServiceFeatureAnnotation(annotation2);
        String id = null;
        if (wsfAnnotation != null) {
            id = wsfAnnotation.id();
        }
        return this.configuratorMap.containsKey(id);
    }

    public void addAnnotation(Annotation annotation2) {
        if (!this.isValid(annotation2)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invalidWSAnnotation", annotation2.toString()));
        }
        WebServiceFeatureAnnotation wsfAnnotation = this.getWebServiceFeatureAnnotation(annotation2);
        this.annotationMap.put(wsfAnnotation.id(), annotation2);
    }

    public Annotation getAnnotation(String id) {
        return this.annotationMap.get(id);
    }

    public Annotation[] getAllAnnotations() {
        return this.annotationMap.values().toArray(ZERO_LENGTH_ARRAY);
    }

    public void configure(EndpointDescription endpointDescription) {
        if (log.isDebugEnabled()) {
            log.debug("Start ServerFramework.conigure(EndpointDescription)");
        }
        for (Annotation annotation2 : this.getAllAnnotations()) {
            WebServiceFeatureAnnotation wsfAnnotation = this.getWebServiceFeatureAnnotation(annotation2);
            ServerConfigurator configurator = this.configuratorMap.get(wsfAnnotation.id());
            if (log.isDebugEnabled()) {
                log.debug("Found ServerConfigurator: " + configurator.getClass().getName());
            }
            if (log.isDebugEnabled()) {
                log.debug("Starting " + configurator.getClass().getName() + ".configure()");
            }
            configurator.configure(endpointDescription);
            if (!log.isDebugEnabled()) continue;
            log.debug("Completed " + configurator.getClass().getName() + ".configure()");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit ServerFramework.conigure(EndpointDescription)");
        }
    }

    private WebServiceFeatureAnnotation getWebServiceFeatureAnnotation(Annotation annotation2) {
        if (log.isDebugEnabled()) {
            log.debug("Looking up WebServiceFeature annotation for " + annotation2.annotationType());
        }
        return annotation2.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
    }
}

