/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.ecl;

import java.io.Serializable;
import java.util.ArrayList;
import org.hpccsystems.commons.ecl.FieldFilterRange;

public class FieldFilter
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String name;
    private ArrayList<FieldFilterRange> ranges = new ArrayList();

    public FieldFilter(String fieldName, FieldFilterRange filterRange) {
        this(fieldName, new FieldFilterRange[]{filterRange});
    }

    public FieldFilter(String fieldName, FieldFilterRange[] filterRanges) {
        this.name = fieldName;
        for (int i = 0; i < filterRanges.length; ++i) {
            this.ranges.add(filterRanges[i]);
        }
    }

    public FieldFilter(String fieldName) {
        this.name = fieldName;
    }

    public FieldFilter appendFilterRange(FieldFilterRange range) {
        if (range != null) {
            this.ranges.add(range);
        }
        return this;
    }

    public String getFieldName() {
        return this.name;
    }

    public int getRangeCount() {
        return this.ranges.size();
    }

    public String toString(boolean outputfieldexpression) {
        StringBuilder sb = new StringBuilder(20 + this.name.length() + 50 * this.ranges.size());
        if (outputfieldexpression) {
            sb.append(this.name);
        }
        if (this.ranges.size() == 0) {
            sb.append("*");
        }
        if (this.ranges.size() > 0) {
            if (outputfieldexpression) {
                sb.append("=");
            }
            sb.append(this.ranges.get(0).filterExpression());
            for (int i = 1; i < this.ranges.size(); ++i) {
                sb.append(",");
                sb.append(this.ranges.get(i).filterExpression());
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

