/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.ecl;

import java.io.Serializable;

public class FieldFilterRange
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String[] values;
    private boolean leftOpen;
    private boolean rightOpen;
    private boolean number;
    private boolean set;
    private Bound bound;
    private short prefix;

    public FieldFilterRange(String v, Bound rangeBound, boolean leftRangeOpen, boolean rightRangeOpen, boolean numeric_target, short prefixMatchLength) {
        this.values = new String[1];
        this.values[0] = v;
        this.bound = rangeBound;
        this.leftOpen = leftRangeOpen;
        this.rightOpen = rightRangeOpen;
        this.number = numeric_target;
        this.set = false;
        this.prefix = prefixMatchLength;
    }

    public FieldFilterRange(String v, Bound rangeBound, boolean leftRangeOpen, boolean rightRangeOpen, boolean numeric_target) {
        this(v, rangeBound, leftRangeOpen, rightRangeOpen, numeric_target, 0);
    }

    public FieldFilterRange(String low, String high, boolean leftRangeOpen, boolean rightRangeOpen, boolean numeric_target) {
        this.bound = Bound.BOTH;
        this.values = new String[2];
        this.values[0] = low;
        this.values[1] = high;
        this.leftOpen = leftRangeOpen;
        this.rightOpen = rightRangeOpen;
        this.set = false;
        this.number = numeric_target;
        this.prefix = 0;
    }

    public FieldFilterRange(Object[] valueList, boolean numeric_target) {
        this.leftOpen = false;
        this.rightOpen = false;
        this.number = numeric_target;
        this.values = new String[valueList.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = valueList[i].toString();
        }
        this.bound = Bound.BOTH;
        this.set = true;
        this.number = numeric_target;
        this.prefix = 0;
    }

    public static FieldFilterRange makeEq(Object v) {
        return new FieldFilterRange(v.toString(), Bound.BOTH, false, false, v instanceof Number);
    }

    public static FieldFilterRange makeNE(Object v) {
        return new FieldFilterRange(v.toString(), Bound.NONE, true, true, v instanceof Number);
    }

    public static FieldFilterRange makeLT(Object v) {
        return new FieldFilterRange(v.toString(), Bound.UPPER, true, true, v instanceof Number);
    }

    public static FieldFilterRange makeLE(Object v) {
        return new FieldFilterRange(v.toString(), Bound.UPPER, true, false, v instanceof Number);
    }

    public static FieldFilterRange makeGT(Object v) {
        return new FieldFilterRange(v.toString(), Bound.LOWER, true, true, v instanceof Number);
    }

    public static FieldFilterRange makeGE(Object v) {
        return new FieldFilterRange(v.toString(), Bound.LOWER, false, true, v instanceof Number);
    }

    public static FieldFilterRange makeIn(Object[] vs) {
        boolean numeric = true;
        for (Object obj : vs) {
            if (obj instanceof Number) continue;
            numeric = false;
            break;
        }
        return new FieldFilterRange(vs, numeric);
    }

    public static FieldFilterRange makeIn(Object[] vs, boolean stringecapsulate) {
        return new FieldFilterRange(vs, !stringecapsulate);
    }

    public static FieldFilterRange makeStartsWith(Object v, short len) throws Exception {
        if (len <= 0) {
            throw new Exception("StartsWith Filter must contain positive len value");
        }
        return new FieldFilterRange(v.toString(), Bound.BOTH, false, false, v instanceof Number, len);
    }

    public String filterExpression() {
        StringBuilder sb = new StringBuilder(this.values.length * 20);
        if (this.set) {
            sb.append(this.number ? "[" : "['");
            sb.append(this.values[0]);
            sb.append(this.number ? "]" : "']");
            for (int i = 1; i < this.values.length; ++i) {
                sb.append(this.number ? ",[" : ",['");
                sb.append(this.values[i]);
                sb.append(this.number ? "]" : "']");
            }
        } else {
            sb.append(this.leftOpen ? "(" : "[");
            switch (this.bound) {
                case BOTH: {
                    sb.append(this.number ? "" : "'");
                    sb.append(this.values[0]);
                    if (this.prefix > 0) {
                        sb.append(":");
                        sb.append(Short.toString(this.prefix));
                    }
                    sb.append(this.number ? "" : "'");
                    break;
                }
                case LOWER: {
                    sb.append(this.number ? "" : "'");
                    sb.append(this.values[0]);
                    if (this.prefix > 0) {
                        sb.append(":");
                        sb.append(Short.toString(this.prefix));
                    }
                    sb.append(this.number ? "," : "',");
                    break;
                }
                case UPPER: {
                    sb.append(this.number ? "," : ",'");
                    sb.append(this.values[0]);
                    if (this.prefix > 0) {
                        sb.append(":");
                        sb.append(Short.toString(this.prefix));
                    }
                    sb.append(this.number ? "" : "'");
                    break;
                }
                default: {
                    sb.append(this.number ? "," : ",'");
                    sb.append(this.values[0]);
                    sb.append(this.number ? "),(" : "'),('");
                    sb.append(this.values[0]);
                    sb.append(this.number ? "," : "',");
                }
            }
            sb.append(this.rightOpen ? ")" : "]");
        }
        return sb.toString();
    }

    public String toString() {
        return this.filterExpression();
    }

    public static enum Bound implements Serializable
    {
        LOWER,
        UPPER,
        BOTH,
        NONE;

    }
}

