/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.ecl;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldFilter;
import org.hpccsystems.commons.ecl.FieldFilterRange;
import org.hpccsystems.commons.filter.SQLExpression;
import org.hpccsystems.commons.filter.SQLFilter;
import org.hpccsystems.commons.filter.SQLFragment;
import org.hpccsystems.commons.filter.SQLOperator;
import org.json.JSONArray;

public class FileFilter
implements Serializable {
    private static final Logger log = LogManager.getLogger(FileFilter.class);
    public static final long serialVersionUID = 2L;
    private List<FieldFilter> fieldfilters = new ArrayList<FieldFilter>();
    private List<FileFilter> andFileFilters = new ArrayList<FileFilter>();

    public FileFilter() {
    }

    public FileFilter(String sqlfilter) throws Exception {
        if (sqlfilter == null || sqlfilter.isEmpty()) {
            throw new Exception("Could not create FileFilter, empty sqlfilter encountered");
        }
        this.ConvertToHPCCFileFilter(sqlfilter);
    }

    public FileFilter(SQLFilter sqlfilter) throws Exception {
        if (sqlfilter == null) {
            throw new Exception("Could not create FileFilter, empty sqlfilter encountered");
        }
        this.ConvertToHPCCFileFilter(sqlfilter);
    }

    public FileFilter(FieldFilter filter) {
        this.fieldfilters.add(filter);
    }

    public FileFilter(FileFilter filter) {
        try {
            this.orFilter(filter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static FileFilter nullFilter() {
        return new FileFilter();
    }

    public boolean isEmpty() {
        return this.fieldfilters.isEmpty();
    }

    public FileFilter andFilter(FileFilter filefilter) throws Exception {
        if (filefilter != null) {
            if (this.fieldfilters.isEmpty()) {
                for (int fieldfilterindex = 0; fieldfilterindex < filefilter.getFieldFiltersCount(); ++fieldfilterindex) {
                    this.orFilter(filefilter.getFieldFilter(fieldfilterindex));
                }
            } else {
                this.andFileFilters.add(filefilter);
            }
        }
        return this;
    }

    public FileFilter andFilter(FieldFilter fieldfilter) throws Exception {
        if (fieldfilter != null) {
            if (this.fieldfilters.isEmpty()) {
                this.fieldfilters.add(fieldfilter);
            } else {
                this.andFileFilters.add(new FileFilter(fieldfilter));
            }
        }
        return this;
    }

    public FileFilter orFilter(FileFilter filefilter) throws Exception {
        if (filefilter != null) {
            for (int fieldfilterindex = 0; fieldfilterindex < filefilter.getFieldFiltersCount(); ++fieldfilterindex) {
                this.orFilter(filefilter.getFieldFilter(fieldfilterindex));
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileFilter orFilter(FieldFilter fieldfilter) throws Exception {
        if (fieldfilter == null) return this;
        if (this.andFileFilters.isEmpty()) {
            if (!this.fieldfilters.isEmpty() && !fieldfilter.getFieldName().equals(this.fieldfilters.get(0).getFieldName())) throw new Exception("FileFilter expressions must target the same field! Cannot append filter '" + fieldfilter.toString() + "' to FileFilter targeting field: '" + this.fieldfilters.get(0).getFieldName() + "'");
            this.fieldfilters.add(fieldfilter);
            return this;
        } else {
            this.andFileFilters.get(this.andFileFilters.size() - 1).orFilter(fieldfilter);
        }
        return this;
    }

    private String outputOrFilter() {
        StringBuilder sb = new StringBuilder(this.fieldfilters.size() * 40 + 30);
        for (int index = 0; index < this.fieldfilters.size(); ++index) {
            if (index != 0) {
                sb.append(',');
            } else {
                sb.append(this.fieldfilters.get(0).getFieldName()).append("=");
            }
            sb.append(this.fieldfilters.get(index).toString(false));
        }
        return sb.toString();
    }

    public int getFieldFiltersCount() {
        return this.fieldfilters.size();
    }

    public FieldFilter getFieldFilter(int i) {
        if (i < 0 || i >= this.fieldfilters.size()) {
            throw new IndexOutOfBoundsException("getFieldFilter(" + i + ") index out of bounds - fielfilters size: " + this.fieldfilters.size());
        }
        return this.fieldfilters.get(i);
    }

    public String toJson() {
        JSONArray keyfilters = new JSONArray();
        keyfilters.put(this.outputOrFilter());
        for (int index = 0; index < this.andFileFilters.size(); ++index) {
            FileFilter currentfilter = this.andFileFilters.get(index);
            String filef = currentfilter.outputOrFilter();
            keyfilters.put(filef);
        }
        return "\"keyFilter\": " + keyfilters.toString();
    }

    private void ConvertToHPCCFileFilter(String sqlfilterstr) throws Exception {
        if (sqlfilterstr == null || sqlfilterstr.isEmpty()) {
            throw new Exception("Cannot convert empty SQL Filter");
        }
        try {
            SQLFilter sqlfilter = new SQLFilter();
            sqlfilter.parseWhereClause(sqlfilterstr);
            this.ConvertToHPCCFileFilter(sqlfilter);
        }
        catch (SQLException e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    private void ConvertToHPCCFileFilter(SQLFilter sqlfilter) throws Exception {
        if (sqlfilter == null) {
            throw new Exception("Cannot convert empty SQL Filter");
        }
        Iterator<SQLExpression> expressions = sqlfilter.getExpressions();
        while (expressions.hasNext()) {
            SQLExpression sqlExpression = expressions.next();
            SQLOperator prevunifier = sqlExpression.getPreviousExpUnifier();
            if (prevunifier == null || prevunifier.getValue().equals(SQLOperator.or)) {
                this.orFilter(FileFilter.ConvertToHPCCFileFilter(sqlExpression));
                continue;
            }
            if (prevunifier.getValue().equals(SQLOperator.and)) {
                this.andFilter(FileFilter.ConvertToHPCCFileFilter(sqlExpression));
                continue;
            }
            throw new Exception("Invalid filter expression unifier operator detected: '" + prevunifier.getValue() + "' in filter: '" + sqlExpression.toString() + "'");
        }
    }

    private static boolean isValidFilter(SQLExpression sqlfilter) throws Exception {
        SQLOperator op = sqlfilter.getOperator();
        if (op.getType() == SQLOperator.OperatorType.PRE_UNARY) {
            throw new Exception("Pre Unary operator not supported: " + op.getValue());
        }
        if (op.getType() == SQLOperator.OperatorType.POST_UNARY) {
            if (op.equals(SQLOperator.isNull)) {
                throw new Exception("Cannot convert filter based on 'isNull' operator!");
            }
            if (op.equals(SQLOperator.isNotNull)) {
                return true;
            }
            throw new Exception("Post Unary operator not supported: " + op.getValue());
        }
        if (op.getType() == SQLOperator.OperatorType.BINARY) {
            SQLFragment.FragmentType prefixtype = sqlfilter.getPrefixType();
            SQLFragment.FragmentType postfixtype = sqlfilter.getPostfixType();
            if (prefixtype == SQLFragment.FragmentType.FIELD && postfixtype == SQLFragment.FragmentType.FIELD) {
                throw new Exception("Cannot convert filter comparing 2 fields -- '" + sqlfilter.toString() + "'");
            }
            if (prefixtype != SQLFragment.FragmentType.FIELD && postfixtype != SQLFragment.FragmentType.FIELD) {
                throw new Exception("Cannot convert filter comparing 0 fields -- '" + sqlfilter.toString() + "'");
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileFilter ConvertToHPCCFileFilter(SQLExpression sqlfilter) throws Exception {
        FileFilter hpccfilter = null;
        if (!FileFilter.isValidFilter(sqlfilter)) throw new Exception("Invalid filter clause: " + sqlfilter.toString());
        boolean prefixcontainsfield = sqlfilter.getPrefixType() == SQLFragment.FragmentType.FIELD;
        SQLOperator op = sqlfilter.getOperator();
        if (op.getValue().equals(SQLOperator.eq)) {
            hpccfilter = prefixcontainsfield ? new FileFilter(new FieldFilter(sqlfilter.getPrefixValue(), FieldFilterRange.makeEq(sqlfilter.getPostfixValue()))) : new FileFilter(new FieldFilter(sqlfilter.getPostfixValue(), FieldFilterRange.makeEq(sqlfilter.getPrefixValue())));
        } else if (op.getValue().equals(SQLOperator.gt)) {
            hpccfilter = prefixcontainsfield ? new FileFilter(new FieldFilter(sqlfilter.getPrefixValue(), FieldFilterRange.makeGT(sqlfilter.getPostfixValue()))) : new FileFilter(new FieldFilter(sqlfilter.getPostfixValue(), FieldFilterRange.makeGT(sqlfilter.getPrefixValue())));
        } else if (op.getValue().equals(SQLOperator.gte)) {
            hpccfilter = prefixcontainsfield ? new FileFilter(new FieldFilter(sqlfilter.getPrefixValue(), FieldFilterRange.makeGE(sqlfilter.getPostfixValue()))) : new FileFilter(new FieldFilter(sqlfilter.getPostfixValue(), FieldFilterRange.makeGE(sqlfilter.getPrefixValue())));
        } else if (op.getValue().equals(SQLOperator.in)) {
            String list = sqlfilter.getPostfixValue().replaceAll("^\\[|\\]$", "");
            hpccfilter = new FileFilter(new FieldFilter(sqlfilter.getPrefixValue(), FieldFilterRange.makeIn(list.split("\\s*,\\s*"), false)));
        } else if (op.getValue().equals(SQLOperator.isNotNull)) {
            log.info("Filter 'IsNotNull' ignored -- No concept of NULL in HPCC/ECL");
        } else if (op.getValue().equals(SQLOperator.lt)) {
            hpccfilter = prefixcontainsfield ? new FileFilter(new FieldFilter(sqlfilter.getPrefixValue(), FieldFilterRange.makeLT(sqlfilter.getPostfixValue()))) : new FileFilter(new FieldFilter(sqlfilter.getPostfixValue(), FieldFilterRange.makeLT(sqlfilter.getPrefixValue())));
        } else if (op.getValue().equals(SQLOperator.lte)) {
            hpccfilter = prefixcontainsfield ? new FileFilter(new FieldFilter(sqlfilter.getPrefixValue(), FieldFilterRange.makeLE(sqlfilter.getPostfixValue()))) : new FileFilter(new FieldFilter(sqlfilter.getPostfixValue(), FieldFilterRange.makeLE(sqlfilter.getPrefixValue())));
        } else {
            if (!op.getValue().equals(SQLOperator.neq) && !op.getValue().equals(SQLOperator.neq2)) throw new Exception("Invalid filter operator detected: '" + op.getValue() + "' In filter: '" + sqlfilter.toString() + "'");
            hpccfilter = prefixcontainsfield ? new FileFilter(new FieldFilter(sqlfilter.getPrefixValue(), FieldFilterRange.makeNE(sqlfilter.getPostfixValue()))) : new FileFilter(new FieldFilter(sqlfilter.getPostfixValue(), FieldFilterRange.makeNE(sqlfilter.getPrefixValue())));
        }
        log.debug("Converted SQL filter: '" + sqlfilter.toString() + "' to HPCC filter: '" + hpccfilter);
        return hpccfilter;
    }

    public static void main(String[] args) {
        try {
            FileFilter filter = new FileFilter("(table.field2 <= 'a' AND table.field2 != 4) OR table.field2 != 5 AND field3 In ('Germany', 'France', 'UK')");
            System.out.println(filter.toJson());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

