/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.ecl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.commons.ecl.HpccSrcType;
import org.hpccsystems.commons.errors.UnparsableContentException;
import org.json.JSONArray;
import org.json.JSONObject;

public class RecordDefinitionTranslator {
    private static final String FIELDS_KEY = "fields";
    private static final String FIELD_TYPE_KEY = "fieldType";
    private static final String LENGTH_KEY = "length";
    private static final String NAME_KEY = "name";
    private static final String TYPE_KEY = "type";
    private static final String CHILD_KEY = "child";
    private static final String FLAGS_KEY = "flags";
    private static final int FLAG_UNSIGNED = 256;
    private static final int FLAG_UNKNOWN_SIZE = 1024;
    private static final int TYPE_ID_MASK = 255;
    private static final int type_boolean = 0;
    private static final int type_int = 1;
    private static final int type_real = 2;
    private static final int type_decimal = 3;
    private static final int type_string = 4;
    private static final int type_biasedswapint = 8;
    private static final int type_keyedint = 10;
    private static final int type_record = 13;
    private static final int type_varstring = 14;
    private static final int type_data = 16;
    private static final int type_table = 20;
    private static final int type_set = 21;
    private static final int type_swapint = 26;
    private static final int type_filepos = 29;
    private static final int type_unicode = 31;
    private static final int type_varunicode = 33;
    private static final int type_utf8 = 41;
    private static final int type_char = 11;
    private static final int type_qstring = 30;
    private static final int FLAG_IS_PAYLOAD_FIELD = 65536;

    private static FieldType getFieldType(int typeID) {
        int type = typeID & 0xFF;
        switch (type) {
            case 0: {
                return FieldType.BOOLEAN;
            }
            case 1: 
            case 8: 
            case 10: 
            case 26: 
            case 29: {
                return FieldType.INTEGER;
            }
            case 2: {
                return FieldType.REAL;
            }
            case 3: {
                return FieldType.DECIMAL;
            }
            case 16: {
                return FieldType.BINARY;
            }
            case 11: {
                return FieldType.CHAR;
            }
            case 4: 
            case 30: 
            case 31: 
            case 41: {
                return FieldType.STRING;
            }
            case 14: 
            case 33: {
                return FieldType.VAR_STRING;
            }
            case 21: {
                return FieldType.SET;
            }
            case 13: {
                return FieldType.RECORD;
            }
            case 20: {
                return FieldType.DATASET;
            }
        }
        return FieldType.UNKNOWN;
    }

    private static HpccSrcType getSourceType(int typeID) {
        int type = typeID & 0xFF;
        switch (type) {
            case 1: 
            case 2: {
                return HpccSrcType.LITTLE_ENDIAN;
            }
            case 8: 
            case 10: 
            case 26: 
            case 29: {
                return HpccSrcType.BIG_ENDIAN;
            }
            case 41: {
                return HpccSrcType.UTF8;
            }
            case 4: 
            case 11: 
            case 14: {
                return HpccSrcType.SINGLE_BYTE_CHAR;
            }
            case 30: {
                return HpccSrcType.QSTRING;
            }
            case 31: 
            case 33: {
                return HpccSrcType.UTF16LE;
            }
        }
        return HpccSrcType.UNKNOWN;
    }

    private static boolean isFixedLength(int typeID) {
        return (typeID & 0x400) == 0;
    }

    private static boolean isUnsigned(int typeID) {
        return (typeID & 0x100) != 0;
    }

    private static int getAdditionalFlags(int flags) {
        int additionalFlagsMask = Short.MIN_VALUE;
        return flags & Short.MIN_VALUE;
    }

    public static String toECLRecord(FieldDef field) throws Exception {
        if (field.getFieldType() != FieldType.RECORD) {
            throw new Exception("Invalid record structure. Root object must of type Record");
        }
        LinkedHashMap<String, String> recordDefinitionMap = new LinkedHashMap<String, String>();
        String rootRecordName = RecordDefinitionTranslator.getEClTypeDefinition(field, recordDefinitionMap);
        String rootDefinition = (String)((HashMap)recordDefinitionMap).get(rootRecordName);
        recordDefinitionMap.remove(rootRecordName);
        rootDefinition = rootDefinition.replace(rootRecordName, "RD");
        StringBuilder sb = new StringBuilder(8192);
        for (Map.Entry entry : ((HashMap)recordDefinitionMap).entrySet()) {
            sb.append("\n\n");
            sb.append((String)entry.getKey());
            sb.append(" := ");
            sb.append((String)entry.getValue());
        }
        sb.append("\n\n");
        sb.append(rootDefinition);
        String definition = sb.toString();
        int numRecordDefinitions = 1;
        for (Map.Entry entry : ((HashMap)recordDefinitionMap).entrySet()) {
            definition = definition.replace((CharSequence)entry.getKey(), "RD" + numRecordDefinitions);
            ++numRecordDefinitions;
        }
        return definition;
    }

    private static String getEClTypeDefinition(FieldDef field, HashMap<String, String> recordDefinitionMap) throws Exception {
        switch (field.getFieldType()) {
            case SET: {
                return "SET OF " + RecordDefinitionTranslator.getEClTypeDefinition(field.getDef(0), recordDefinitionMap);
            }
            case DATASET: {
                return "DATASET(" + RecordDefinitionTranslator.getEClTypeDefinition(field.getDef(0), recordDefinitionMap) + ")";
            }
            case BINARY: {
                return "DATA";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case INTEGER: {
                String root = "INTEGER";
                if (field.isUnsigned()) {
                    root = "UNSIGNED";
                }
                if (field.getDataLen() < 1L || field.getDataLen() > 8L) {
                    throw new Exception("Error: Unsupported integer size: " + field.getDataLen() + " must 1-8.");
                }
                return root + field.getDataLen();
            }
            case DECIMAL: {
                String root = "DECIMAL";
                if (field.isUnsigned()) {
                    root = "U" + root;
                }
                return root + field.getPrecision() + "_" + field.getScale();
            }
            case REAL: {
                if (field.getDataLen() == 4L) {
                    return "REAL4";
                }
                if (field.getDataLen() == 8L) {
                    return "REAL8";
                }
                throw new Exception("Error: Unsupported real size: " + field.getDataLen() + " must 4 or 8.");
            }
            case CHAR: {
                return "STRING1";
            }
            case STRING: {
                String type = "";
                HpccSrcType srcType = field.getSourceType();
                if (srcType == HpccSrcType.SINGLE_BYTE_CHAR) {
                    type = "STRING";
                } else if (srcType == HpccSrcType.UTF16LE || srcType == HpccSrcType.UTF16BE) {
                    type = "UNICODE";
                } else if (srcType == HpccSrcType.UTF8) {
                    type = "UTF8";
                } else if (srcType == HpccSrcType.QSTRING) {
                    type = "QSTRING";
                } else {
                    throw new Exception("Unable to convert type to ECL string. Encountered unexpected string source type: " + (Object)((Object)srcType));
                }
                if (field.isFixed()) {
                    type = type + field.getDataLen();
                }
                return type;
            }
            case VAR_STRING: {
                String type = "";
                HpccSrcType srcType = field.getSourceType();
                if (srcType == HpccSrcType.SINGLE_BYTE_CHAR) {
                    type = "VARSTRING";
                } else if (srcType == HpccSrcType.UTF16LE || srcType == HpccSrcType.UTF16BE) {
                    type = "VARUNICODE";
                } else {
                    throw new Exception("Unable to convert type to varstring. Encountered unexpected string source type: " + (Object)((Object)srcType));
                }
                if (field.isFixed()) {
                    type = type + field.getDataLen();
                }
                return type;
            }
            case RECORD: {
                String definition = "RECORD\n";
                for (int i = 0; i < field.getNumDefs(); ++i) {
                    FieldDef childField = field.getDef(i);
                    definition = definition + "\t" + RecordDefinitionTranslator.getEClTypeDefinition(childField, recordDefinitionMap) + " " + childField.getFieldName() + ";\n";
                }
                definition = definition + "END;\n";
                int hash = definition.hashCode();
                String recordDefnName = "##" + hash + "##";
                recordDefinitionMap.put(recordDefnName, definition);
                return recordDefnName;
            }
        }
        throw new Exception("Unable to generate ECL unknown field type: " + field.getFieldType().description());
    }

    public static JSONObject toJsonRecord(FieldDef field) throws Exception {
        if (field.getFieldType() != FieldType.RECORD) {
            throw new Exception("Invalid record structure. Root object must of type Record");
        }
        HashMap<Integer, Integer> typeDefinitionMap = new HashMap<Integer, Integer>();
        ArrayList<JSONObject> typeDefinitions = new ArrayList<JSONObject>();
        Integer rootRecordHash = RecordDefinitionTranslator.getJsonTypeDefinition(field, typeDefinitionMap, typeDefinitions);
        Integer rootDefinitionIndex = typeDefinitionMap.get(rootRecordHash);
        JSONObject rootDefinition = typeDefinitions.get(rootDefinitionIndex);
        typeDefinitions.set(rootDefinitionIndex, null);
        for (int i = 0; i < typeDefinitions.size(); ++i) {
            JSONObject typeDefinition = typeDefinitions.get(i);
            if (typeDefinition == null) continue;
            rootDefinition.put("ty" + (i + 1), typeDefinition);
        }
        return rootDefinition;
    }

    private static int getTypeID(FieldDef field) throws Exception {
        int typeID = 0;
        switch (field.getFieldType()) {
            case SET: {
                typeID = 21;
                if (field.isFixed()) break;
                typeID |= 0x400;
                break;
            }
            case DATASET: {
                typeID = 20;
                if (field.isFixed()) break;
                typeID |= 0x400;
                break;
            }
            case BINARY: {
                typeID = 16;
                if (field.isFixed()) break;
                typeID |= 0x400;
                break;
            }
            case BOOLEAN: {
                typeID = 0;
                break;
            }
            case INTEGER: {
                typeID = 1;
                if (!field.isUnsigned()) break;
                typeID |= 0x100;
                break;
            }
            case DECIMAL: {
                typeID = 3;
                if (!field.isUnsigned()) break;
                typeID |= 0x100;
                break;
            }
            case REAL: {
                typeID = 2;
                break;
            }
            case CHAR: {
                typeID = 11;
                if (!field.isUnsigned()) break;
                typeID |= 0x100;
                break;
            }
            case STRING: {
                typeID = -1;
                HpccSrcType srcType = field.getSourceType();
                if (srcType == HpccSrcType.SINGLE_BYTE_CHAR) {
                    typeID = 4;
                } else if (srcType == HpccSrcType.UTF16LE || srcType == HpccSrcType.UTF16BE) {
                    typeID = 31;
                } else if (srcType == HpccSrcType.UTF8) {
                    typeID = 41;
                } else if (srcType == HpccSrcType.QSTRING) {
                    typeID = 30;
                } else {
                    throw new Exception("Unable to convert type to json. Encountered unexpected string source type: " + (Object)((Object)srcType));
                }
                if (field.isFixed()) break;
                typeID |= 0x400;
                break;
            }
            case VAR_STRING: {
                typeID = -1;
                HpccSrcType srcType = field.getSourceType();
                if (srcType == HpccSrcType.SINGLE_BYTE_CHAR) {
                    typeID = 14;
                } else if (srcType == HpccSrcType.UTF16LE || srcType == HpccSrcType.UTF16BE) {
                    typeID = 33;
                } else {
                    throw new Exception("Unable to convert type to json. Encountered unexpected varstring source type: " + (Object)((Object)srcType));
                }
                if (field.isFixed()) break;
                typeID |= 0x400;
                break;
            }
            case RECORD: {
                typeID = 13;
                if (field.isFixed()) break;
                typeID |= 0x400;
                break;
            }
            default: {
                throw new Exception("Unable to generate JSON for field : " + field.getFieldName() + " with unknown type: " + field.getFieldType().description());
            }
        }
        return typeID;
    }

    private static int getTypeHash(FieldDef field) throws Exception {
        int numHashComponents = 2 + field.getNumDefs();
        if (field.getFieldType() == FieldType.DECIMAL) {
            numHashComponents += 2;
        }
        long[] hashComponents = new long[numHashComponents];
        hashComponents[0] = RecordDefinitionTranslator.getTypeID(field);
        hashComponents[1] = field.getDataLen();
        int hashCompIndex = 2;
        int i = 0;
        while (i < field.getNumDefs()) {
            hashComponents[hashCompIndex] = RecordDefinitionTranslator.getTypeHash(field.getDef(i));
            ++i;
            ++hashCompIndex;
        }
        if (field.getFieldType() == FieldType.DECIMAL) {
            hashComponents[hashCompIndex] = field.getPrecision();
            hashComponents[hashCompIndex + 1] = field.getScale();
        }
        return Arrays.hashCode(hashComponents);
    }

    private static int getJsonTypeDefinition(FieldDef field, HashMap<Integer, Integer> typeDefinitionMap, ArrayList<JSONObject> typeDefinitions) throws Exception {
        int typeHash = RecordDefinitionTranslator.getTypeHash(field);
        Integer typeIndex = typeDefinitionMap.get(typeHash);
        if (typeIndex != null) {
            return typeHash;
        }
        JSONObject typeDef = new JSONObject();
        int typeID = RecordDefinitionTranslator.getTypeID(field);
        switch (field.getFieldType()) {
            case SET: 
            case DATASET: {
                typeDef.put(FIELD_TYPE_KEY, typeID);
                typeDef.put(LENGTH_KEY, field.getDataLen());
                int childTypeHash = RecordDefinitionTranslator.getJsonTypeDefinition(field.getDef(0), typeDefinitionMap, typeDefinitions);
                int childTypeIndex = typeDefinitionMap.get(childTypeHash);
                String childTypeName = "ty" + (childTypeIndex + 1);
                typeDef.put(CHILD_KEY, childTypeName);
                break;
            }
            case BINARY: 
            case BOOLEAN: 
            case INTEGER: 
            case REAL: 
            case CHAR: 
            case STRING: 
            case VAR_STRING: {
                typeDef.put(FIELD_TYPE_KEY, typeID);
                typeDef.put(LENGTH_KEY, field.getDataLen());
                break;
            }
            case DECIMAL: {
                typeDef.put(FIELD_TYPE_KEY, typeID);
                int len = field.getScale() << 16 | field.getPrecision();
                typeDef.put(LENGTH_KEY, len);
                break;
            }
            case RECORD: {
                typeDef.put(FIELD_TYPE_KEY, typeID);
                typeDef.put(LENGTH_KEY, field.getDataLen());
                JSONArray fields = new JSONArray();
                for (int i = 0; i < field.getNumDefs(); ++i) {
                    FieldDef childField = field.getDef(i);
                    int childTypeHash = RecordDefinitionTranslator.getJsonTypeDefinition(childField, typeDefinitionMap, typeDefinitions);
                    int childTypeIndex = typeDefinitionMap.get(childTypeHash);
                    String childTypeName = "ty" + (childTypeIndex + 1);
                    int childTypeID = RecordDefinitionTranslator.getTypeID(childField);
                    JSONObject childJson = new JSONObject();
                    childJson.put(NAME_KEY, childField.getFieldName());
                    childJson.put(TYPE_KEY, childTypeName);
                    if (childTypeID > 0) {
                        int flags = childTypeID | childField.getAdditionalFlags();
                        childJson.put(FLAGS_KEY, flags);
                    }
                    if (childField.getFieldType() == FieldType.DATASET) {
                        char delim = '\u0001';
                        childJson.put("xpath", childField.getFieldName() + delim + "Row");
                    }
                    fields.put(childJson);
                }
                typeDef.put(FIELDS_KEY, fields);
                break;
            }
            default: {
                throw new Exception("Unable to generate JSON for field : " + field.getFieldName() + " with unknown type: " + field.getFieldType().description());
            }
        }
        int newTypeIndex = typeDefinitions.size();
        typeDefinitions.add(typeDef);
        typeDefinitionMap.put(typeHash, newTypeIndex);
        return typeHash;
    }

    public static FieldDef parseJsonRecordDefinition(JSONObject recordDefinition) throws UnparsableContentException {
        HashMap<String, FieldDef> typeDefinitions = new HashMap<String, FieldDef>();
        return RecordDefinitionTranslator.parseJsonRecordDefinition(recordDefinition, typeDefinitions, recordDefinition);
    }

    private static FieldDef parseJsonRecordDefinition(JSONObject jsonTypeDefinitions, HashMap<String, FieldDef> protoTypeDefs, JSONObject recordDefinition) throws UnparsableContentException {
        int typeID = recordDefinition.getInt(FIELD_TYPE_KEY);
        long length = recordDefinition.getLong(LENGTH_KEY);
        FieldType fieldType = RecordDefinitionTranslator.getFieldType(typeID);
        if (fieldType != FieldType.RECORD) {
            throw new UnparsableContentException("Expected top-level field to be of type Record. Found: " + fieldType.description());
        }
        JSONArray fields = recordDefinition.getJSONArray(FIELDS_KEY);
        ArrayList<FieldDef> childDefs = new ArrayList<FieldDef>();
        for (int i = 0; i < fields.length(); ++i) {
            JSONObject value = fields.getJSONObject(i);
            if (value == null) continue;
            JSONObject jsonFieldDefinition = value;
            FieldDef childFieldDef = RecordDefinitionTranslator.parseFieldDefinition(jsonTypeDefinitions, protoTypeDefs, jsonFieldDefinition);
            childDefs.add(childFieldDef);
        }
        boolean isFixedLength = RecordDefinitionTranslator.isFixedLength(typeID);
        boolean isUnsigned = RecordDefinitionTranslator.isUnsigned(typeID);
        HpccSrcType srcType = RecordDefinitionTranslator.getSourceType(typeID);
        return new FieldDef("RootRecord", fieldType, fieldType.description(), length, isFixedLength, isUnsigned, srcType, childDefs.toArray(new FieldDef[0]));
    }

    private static FieldDef parseFieldDefinition(JSONObject jsonTypeDefinitions, HashMap<String, FieldDef> protoTypeDefs, JSONObject jsonFieldDefinition) throws UnparsableContentException {
        String name = jsonFieldDefinition.getString(NAME_KEY);
        String type = jsonFieldDefinition.getString(TYPE_KEY);
        int flags = 0;
        try {
            flags = jsonFieldDefinition.getInt(FLAGS_KEY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FieldDef protoTypeDef = RecordDefinitionTranslator.getOrParseJsonTypeDefintion(type, jsonTypeDefinitions, protoTypeDefs);
        FieldDef ret = new FieldDef(protoTypeDef);
        ret.setAdditionalFlags(RecordDefinitionTranslator.getAdditionalFlags(flags));
        ret.setFieldName(name);
        return ret;
    }

    private static FieldDef getOrParseJsonTypeDefintion(String type, JSONObject jsonTypeDefinitions, HashMap<String, FieldDef> protoTypeDefs) throws UnparsableContentException {
        FieldDef protoTypeDef = protoTypeDefs.get(type);
        if (protoTypeDef == null) {
            JSONObject typeDefnJson = jsonTypeDefinitions.getJSONObject(type);
            if (typeDefnJson == null) {
                throw new UnparsableContentException("Unable to find type defintion for type: " + type);
            }
            protoTypeDef = RecordDefinitionTranslator.parseJsonTypeDefinition(jsonTypeDefinitions, protoTypeDefs, typeDefnJson);
            protoTypeDef.setFieldName(type);
            protoTypeDefs.put(type, protoTypeDef);
        }
        return protoTypeDef;
    }

    private static FieldDef parseJsonTypeDefinition(JSONObject jsonTypeDefinitions, HashMap<String, FieldDef> protoTypeDefs, JSONObject typeDef) throws UnparsableContentException {
        int typeID = typeDef.getInt(FIELD_TYPE_KEY);
        long length = typeDef.getLong(LENGTH_KEY);
        FieldType fieldType = RecordDefinitionTranslator.getFieldType(typeID);
        switch (fieldType) {
            case RECORD: {
                return RecordDefinitionTranslator.parseJsonRecordDefinition(jsonTypeDefinitions, protoTypeDefs, typeDef);
            }
            case SET: 
            case DATASET: {
                String childType = typeDef.getString(CHILD_KEY);
                FieldDef childProtoTypeDef = RecordDefinitionTranslator.getOrParseJsonTypeDefintion(childType, jsonTypeDefinitions, protoTypeDefs);
                FieldDef[] childDefs = new FieldDef[]{childProtoTypeDef};
                return new FieldDef("", fieldType, fieldType.description(), length, RecordDefinitionTranslator.isFixedLength(typeID), RecordDefinitionTranslator.isUnsigned(typeID), RecordDefinitionTranslator.getSourceType(typeID), childDefs);
            }
        }
        return new FieldDef("", fieldType, fieldType.description(), length, RecordDefinitionTranslator.isFixedLength(typeID), RecordDefinitionTranslator.isUnsigned(typeID), RecordDefinitionTranslator.getSourceType(typeID), new FieldDef[0]);
    }
}

