/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.filter;

import java.util.HashMap;
import java.util.regex.Pattern;

public class SQLOperator {
    private static HashMap<String, OperatorType> validOps;
    public static final String eq;
    public static final String neq;
    public static final String neq2;
    public static final String isNull;
    public static final String isNotNull;
    public static final String gt;
    public static final String lt;
    public static final String gte;
    public static final String lte;
    public static final String and;
    public static final String or;
    public static final String in;
    public static final String notIn;
    public static final String ISNULLSPLITPATTERN = "\\s+(?i)IS\\s+(?i)NULL\\s*";
    public static final String ISNOTNULLSPLITPATTERN = "\\s+(?i)IS\\s+(?i)NOT\\s+(?i)NULL\\s*";
    public static final String ANDSPLITPATTERN = "\\s+(?i)AND\\s+";
    public static final String ORSPLITPATTERN = "\\s+(?i)OR\\s+";
    public static final String NOTSPLITPATTERN = "\\s+(?i)NOT\\s+";
    public static final String INSPLITPATTERN = "\\s+(?i)IN\\s+";
    public static final String NOTINSPLITPATTERN = "\\s+(?i)NOT\\s+(?i)IN\\s*";
    private static final Pattern ISNULLPATTERN;
    private static final Pattern ISNOTNULLPATTERN;
    private static final Pattern ANDPATTERN;
    private static final Pattern ORPATTERN;
    private static final Pattern INPATTERN;
    private static final Pattern NOTINPATTERN;
    private final String value;
    private OperatorType type;
    private String splitPattern = null;

    public SQLOperator(String fragment) {
        String upperFragment = fragment.toUpperCase();
        if (validOps.containsKey(upperFragment)) {
            this.value = upperFragment;
            this.type = validOps.get(this.value);
        } else if (upperFragment.indexOf(gte) != -1) {
            this.value = gte;
        } else if (upperFragment.indexOf(lte) != -1) {
            this.value = lte;
        } else if (upperFragment.indexOf(neq) != -1) {
            this.value = neq;
        } else if (upperFragment.indexOf(neq2) != -1) {
            this.value = neq2;
        } else if (upperFragment.indexOf(eq) != -1) {
            this.value = eq;
        } else if (upperFragment.indexOf(gt) != -1) {
            this.value = gt;
        } else if (upperFragment.indexOf(lt) != -1) {
            this.value = lt;
        } else if (ANDPATTERN.matcher(upperFragment).matches()) {
            this.splitPattern = ANDSPLITPATTERN;
            this.value = and;
        } else if (ORPATTERN.matcher(upperFragment).matches()) {
            this.splitPattern = ORSPLITPATTERN;
            this.value = or;
        } else if (ISNOTNULLPATTERN.matcher(upperFragment).matches()) {
            this.splitPattern = ISNOTNULLSPLITPATTERN;
            this.value = isNotNull;
        } else if (ISNULLPATTERN.matcher(upperFragment).matches()) {
            this.splitPattern = ISNULLSPLITPATTERN;
            this.value = isNull;
        } else if (NOTINPATTERN.matcher(upperFragment).matches()) {
            this.splitPattern = NOTINSPLITPATTERN;
            this.value = notIn;
        } else if (INPATTERN.matcher(upperFragment).matches()) {
            this.splitPattern = INSPLITPATTERN;
            this.value = in;
        } else {
            this.value = null;
        }
        if (this.value != null) {
            this.type = validOps.get(this.value);
        }
    }

    public String getValue() {
        return this.value;
    }

    public boolean isBinary() {
        return this.type == OperatorType.BINARY;
    }

    public OperatorType getType() {
        return this.type;
    }

    public boolean isValid() {
        return validOps.containsKey(this.value);
    }

    public String[] splitExpressionFragment(String fragment) {
        return fragment.split(this.splitPattern == null ? this.value : this.splitPattern);
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    static {
        eq = new String("=");
        neq = new String("<>");
        neq2 = new String("!=");
        isNull = new String(" IS NULL");
        isNotNull = new String(" IS NOT NULL");
        gt = new String(">");
        lt = new String("<");
        gte = new String(">=");
        lte = new String("<=");
        and = new String(" AND ");
        or = new String(" OR ");
        in = new String(" IN ");
        notIn = new String(" NOT IN ");
        ISNULLPATTERN = Pattern.compile("(.?)+\\s+(?i)IS\\s+(?i)NULL\\s*", 32);
        ISNOTNULLPATTERN = Pattern.compile("(.?)+\\s+(?i)IS\\s+(?i)NOT\\s+(?i)NULL\\s*", 32);
        ANDPATTERN = Pattern.compile("(.?){1}\\s+(?i)AND\\s+(.?){1}", 32);
        ORPATTERN = Pattern.compile("(.?){1}\\s+(?i)OR\\s+(.?){1}", 32);
        INPATTERN = Pattern.compile("(.?)+\\s+(?i)IN\\s+(.?)+", 32);
        NOTINPATTERN = Pattern.compile("(.?){1}\\s+(?i)NOT\\s+(?i)IN\\s*(.?){1}", 32);
        validOps = new HashMap();
        validOps.put(eq, OperatorType.BINARY);
        validOps.put(neq, OperatorType.BINARY);
        validOps.put(neq2, OperatorType.BINARY);
        validOps.put(isNull, OperatorType.NOOPFALSE);
        validOps.put(isNotNull, OperatorType.NOOPTRUE);
        validOps.put(gt, OperatorType.BINARY);
        validOps.put(lt, OperatorType.BINARY);
        validOps.put(gte, OperatorType.BINARY);
        validOps.put(lte, OperatorType.BINARY);
        validOps.put(and, OperatorType.BINARY);
        validOps.put(or, OperatorType.BINARY);
        validOps.put(in, OperatorType.BINARY);
        validOps.put(notIn, OperatorType.BINARY);
    }

    public static enum OperatorType {
        UNKNOWN,
        PRE_UNARY,
        POST_UNARY,
        NOOPTRUE,
        NOOPFALSE,
        BINARY;

    }
}

