/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.utils.DigestAlgorithmType;

public class CryptoHelper {
    private static final Logger log = LogManager.getLogger(CryptoHelper.class);
    public static final DigestAlgorithmType DEFAULT_DIGEST_ALGORITHM = DigestAlgorithmType.SHA512;
    public static final String DEFAULT_SECRETKEY_ALGORITHM = "AES";
    public static final int DEFAULT_AES_SECRETKEY_LEN = 16;
    public static final String DEFAULT_CIPHER_MODE = "AES/ECB/PKCS5PADDING";

    public static SecretKeySpec createSHA512AESSecretKey(String digestInput) {
        return CryptoHelper.createSecretKey(digestInput, DEFAULT_DIGEST_ALGORITHM, DEFAULT_SECRETKEY_ALGORITHM);
    }

    public static SecretKeySpec createSecretKey(String utf8DigestInput, DigestAlgorithmType digestAlgorithm, String secretKeyAlgorithm) {
        SecretKeySpec secretkey = null;
        try {
            byte[] key = utf8DigestInput.getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance(digestAlgorithm.getName());
            key = sha.digest(key);
            int aesKeySize = 16;
            if (secretKeyAlgorithm.equalsIgnoreCase(DEFAULT_SECRETKEY_ALGORITHM)) {
                switch (digestAlgorithm) {
                    case SHA512: {
                        aesKeySize = 32;
                        log.info("AES SHA-512 Digest key cut to 32 bytes");
                        break;
                    }
                    case SHA384: {
                        aesKeySize = 32;
                        log.info("AES SHA-384 Digest key cut to 32 bytes");
                        break;
                    }
                    case SHA1: {
                        aesKeySize = 16;
                        log.info("AES SHA-1 Digest key cut to 32 bytes");
                        break;
                    }
                }
                key = Arrays.copyOf(sha.digest(key), aesKeySize);
            }
            secretkey = new SecretKeySpec(key, secretKeyAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return secretkey;
    }

    public static String encrypt(String utf8StrToEncrypt, Cipher cipher) {
        try {
            if (cipher != null) {
                return Base64.getEncoder().encodeToString(cipher.doFinal(utf8StrToEncrypt.getBytes("UTF-8")));
            }
            throw new Exception("Must provide cipher");
        }
        catch (Exception e) {
            System.out.println("Error while encrypting: " + e.toString());
            return null;
        }
    }

    public static Cipher createDefaultCipher(String secretKey, boolean encryptMode) throws Exception {
        return CryptoHelper.createDefaultCipher(CryptoHelper.createSHA512AESSecretKey(secretKey), encryptMode);
    }

    public static Cipher createCipher(SecretKeySpec secretKey, String cipherAlgorithm, boolean encryptMode) throws Exception {
        if (secretKey == null) {
            throw new Exception("Must provide SecretKeySpec");
        }
        if (cipherAlgorithm == null || cipherAlgorithm.isEmpty()) {
            throw new Exception("Must provide cipher algorithm (AES, AES/CBC/PKCS5Padding, etc.");
        }
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(encryptMode ? 1 : 2, secretKey);
        return cipher;
    }

    public static Cipher createDefaultCipher(SecretKeySpec secretKey, boolean encryptMode) throws Exception {
        return CryptoHelper.createCipher(secretKey, DEFAULT_CIPHER_MODE, encryptMode);
    }

    public static String encryptSHA512AESPKCS5Pad(String utf8StrToEncrypt, String digestInput) {
        return CryptoHelper.encryptSHA512AESPKCS5Pad(utf8StrToEncrypt, CryptoHelper.createSHA512AESSecretKey(digestInput));
    }

    public static String encryptSHA512AESPKCS5Pad(String utf8StrToEncrypt, SecretKeySpec secretKey) {
        try {
            Cipher AESCipher = Cipher.getInstance(DEFAULT_CIPHER_MODE);
            if (AESCipher != null) {
                if (secretKey != null) {
                    AESCipher.init(1, secretKey);
                    return CryptoHelper.encrypt(utf8StrToEncrypt, AESCipher);
                }
                throw new Exception("Must provide Secret Key");
            }
            throw new Exception("Cipher not available");
        }
        catch (Exception e) {
            System.out.println("Error while encrypting: " + e.toString());
            return null;
        }
    }

    public static String decrypt(String strToDecrypt, Cipher cipher) {
        try {
            if (cipher != null) {
                return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)));
            }
            throw new Exception("Must provide valid Cipher");
        }
        catch (Exception e) {
            System.out.println("Error while decrypting: " + e.toString());
            return null;
        }
    }

    public static String decrypt(String utf8StrToDecrypt, SecretKeySpec secretspec) {
        try {
            Cipher aesCipher = Cipher.getInstance(DEFAULT_CIPHER_MODE);
            if (aesCipher != null) {
                if (secretspec != null) {
                    aesCipher.init(2, secretspec);
                    return CryptoHelper.decrypt(utf8StrToDecrypt, aesCipher);
                }
                throw new Exception("Secret not available");
            }
            throw new Exception("Cipher not available");
        }
        catch (Exception e) {
            System.out.println("Error while decrypting: " + e.toString());
            return null;
        }
    }

    public static String decrypt(String value, String secretKey) {
        return CryptoHelper.decrypt(value, CryptoHelper.createSHA512AESSecretKey(secretKey));
    }
}

