/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.utils;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final String DOTSEPERATORREGEX = "\\.";
    public static String newLine = System.getProperty("line.separator");
    public static String fileSep = System.getProperty("file.separator");
    public static final String workingDir = System.getProperty("user.dir") + fileSep;
    public static NumberFormat USNumberFormat = NumberFormat.getInstance(Locale.US);
    static final char BASE64_enc_pad = '=';
    static final char[] BASE64_enc = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '\"'};
    static final char[] BASE64_dec = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '>', '\u0000', '\u0000', '\u0000', '?', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final Pattern PARENSTRPATTERN = Pattern.compile("\\s*(\\()(.*?)(\\))\\s*", 32);
    public static final Pattern AGGFUNCPATTERN = Pattern.compile("\\s*(.*?)(\\()(.*?)(\\))\\s*", 32);
    private static final Pattern QUOTEDFULLFIELDPATTERN = Pattern.compile("\\s*(\"|')(.*?){1}(\\.)(.*?){1}(\"|')\\s*", 32);
    private static final Pattern QUOTEDSTRPATTERN = Pattern.compile("\\s*(\"|')(.*?)(\"|')\\s*", 32);
    public static final String EscapedSingleQuote = "''";
    private static final HashMap<EclTypes, Integer> mapECLtypeCodeToSQLtype = new HashMap();
    private static final HashMap<Integer, String> mapSQLtypeCodeToJavaClass;
    private static final String JAVA_OBJECT_TYPE_NAME = "java.lang.Object";
    public static final Pattern BOOLEANPATTERN;

    public static String Base64Encode(byte[] input, boolean addLineBreaks) {
        int length = input.length;
        StringBuilder out = new StringBuilder("");
        int i = 0;
        while (i < length && length - i >= 3) {
            char one = (char)input[i++];
            char two = (char)input[i++];
            char three = (char)input[i++];
            out.append(BASE64_enc[one >> 2]);
            out.append(BASE64_enc[one << 4 & 0x30 | two >> 4]);
            out.append(BASE64_enc[two << 2 & 0x3C | three >> 6]);
            out.append(BASE64_enc[three & 0x3F]);
            if (addLineBreaks && i % 54 == 0) {
                out.append("\n");
            }
            switch (length - i) {
                case 2: {
                    one = (char)input[i++];
                    two = (char)input[i++];
                    out.append(BASE64_enc[one >> 2]);
                    out.append(BASE64_enc[one << 4 & 0x30 | two >> 4]);
                    out.append(BASE64_enc[two << 2 & 0x3C]);
                    out.append('=');
                    break;
                }
                case 1: {
                    one = (char)input[i++];
                    out.append(BASE64_enc[one >> 2]);
                    out.append(BASE64_enc[one << 4 & 0x30]);
                    out.append('=');
                    out.append('=');
                }
            }
        }
        return out.toString();
    }

    public static String removeAllNewLines(String str) {
        return str.trim().replaceAll("\\r\\n|\\r|\\n", " ");
    }

    public static boolean isLiteralString(String str) {
        boolean match = QUOTEDSTRPATTERN.matcher(str).matches();
        if (match) {
            return !QUOTEDFULLFIELDPATTERN.matcher(str).matches();
        }
        return match;
    }

    public static boolean isNumeric(String str) {
        try {
            USNumberFormat.parse(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isInParenthesis(String parenstring) {
        if (parenstring == null) {
            return false;
        }
        Matcher matcher = PARENSTRPATTERN.matcher(parenstring);
        return matcher.matches();
    }

    public static boolean isAggFunction(String aggfunstr) {
        if (aggfunstr == null) {
            return false;
        }
        Matcher matcher = AGGFUNCPATTERN.matcher(aggfunstr);
        return matcher.matches();
    }

    public static String getParenContents(String parenstring) {
        if (parenstring == null) {
            return "";
        }
        Matcher matcher = PARENSTRPATTERN.matcher(parenstring);
        if (matcher.matches()) {
            return matcher.group(2).trim();
        }
        return parenstring;
    }

    public static long stringToLong(String str, long uponError) {
        try {
            Number num = USNumberFormat.parse(str);
            return num.longValue();
        }
        catch (Exception e) {
            return uponError;
        }
    }

    public static int stringToInt(String str, int uponError) {
        try {
            Number num = USNumberFormat.parse(str);
            return num.intValue();
        }
        catch (Exception e) {
            return uponError;
        }
    }

    public static String replaceAll(String input, String forReplace, String replaceWith) {
        if (input == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        boolean hasMore = true;
        while (hasMore) {
            int start = input.indexOf(forReplace);
            int end = start + forReplace.length();
            if (start != -1) {
                result.append(input.substring(0, start) + replaceWith);
                input = input.substring(end);
                continue;
            }
            hasMore = false;
            result.append(input);
        }
        if (result.toString().equals("")) {
            return input;
        }
        return result.toString();
    }

    public static String handleQuotedString(String quotedString) {
        if (quotedString == null) {
            return "";
        }
        Matcher matcher = QUOTEDSTRPATTERN.matcher(quotedString);
        if (matcher.matches()) {
            return matcher.group(2).trim();
        }
        return quotedString;
    }

    public static boolean isParameterizedStr(String value) {
        return value.contains("${") || value.equals("?");
    }

    public static boolean hasPossibleEscapedQuoteLiteral(String quotedString) throws Exception {
        if (quotedString == null) {
            return false;
        }
        return Utils.handleQuotedString(quotedString).contains(EscapedSingleQuote);
    }

    public static String replaceSQLwithECLEscapeChar(String quotedString) throws Exception {
        if (quotedString == null) {
            return "";
        }
        String eclescaped = "\\\\'";
        String replaced = '\'' + Utils.handleQuotedString(quotedString).replaceAll(EscapedSingleQuote, eclescaped) + '\'';
        return replaced;
    }

    public static int convertECLtypeCode2SQLtype(EclTypes ecltype) {
        if (mapECLtypeCodeToSQLtype.containsKey((Object)ecltype)) {
            return mapECLtypeCodeToSQLtype.get((Object)ecltype);
        }
        return 1111;
    }

    public static String convertSQLtype2JavaClassName(int type) {
        if (mapSQLtypeCodeToJavaClass.containsKey(type)) {
            return mapSQLtypeCodeToJavaClass.get(type);
        }
        return JAVA_OBJECT_TYPE_NAME;
    }

    public static <T extends Enum<T>> T findEnumValFromString(Class<T> enumclass, String strvalue) {
        for (Enum enumValue : (Enum[])enumclass.getEnumConstants()) {
            if (!enumValue.name().equalsIgnoreCase(strvalue)) continue;
            return (T)enumValue;
        }
        throw new IllegalArgumentException(enumclass.getName() + ".'" + strvalue + "' is not valid.");
    }

    public static boolean isBooleanKeyWord(String str) {
        return BOOLEANPATTERN.matcher(str).matches();
    }

    static {
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypeboolean, 16);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypearray, 2003);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypeblob, 2004);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypechar, 1);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypedate, 91);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypedecimal, 3);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypeint, 4);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypenull, 0);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypenumeric, 2);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypepackedint, 4);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypepointer, 2006);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypeqstring, 12);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypereal, 7);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypestring, 12);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypeunsigned, 2);
        mapECLtypeCodeToSQLtype.put(EclTypes.ECLTypevarstring, 12);
        mapSQLtypeCodeToJavaClass = new HashMap();
        mapSQLtypeCodeToJavaClass.put(1, "java.lang.Character");
        mapSQLtypeCodeToJavaClass.put(12, "java.lang.String");
        mapSQLtypeCodeToJavaClass.put(-1, "java.lang.String");
        mapSQLtypeCodeToJavaClass.put(2, "java.math.BigDecimal");
        mapSQLtypeCodeToJavaClass.put(3, "java.math.BigDecimal");
        mapSQLtypeCodeToJavaClass.put(-7, "java.lang.Boolean");
        mapSQLtypeCodeToJavaClass.put(-6, "java.lang.Byte");
        mapSQLtypeCodeToJavaClass.put(5, "java.lang.Short");
        mapSQLtypeCodeToJavaClass.put(4, "java.lang.Integer");
        mapSQLtypeCodeToJavaClass.put(-5, "java.lang.Long");
        mapSQLtypeCodeToJavaClass.put(7, "java.lang.Real");
        mapSQLtypeCodeToJavaClass.put(6, "java.lang.Double");
        mapSQLtypeCodeToJavaClass.put(8, "java.lang.Double");
        mapSQLtypeCodeToJavaClass.put(-2, "java.lang.Byte[]");
        mapSQLtypeCodeToJavaClass.put(-3, "java.lang.Byte[]");
        mapSQLtypeCodeToJavaClass.put(-4, "java.lang.Byte[]");
        mapSQLtypeCodeToJavaClass.put(91, "java.sql.Date");
        mapSQLtypeCodeToJavaClass.put(92, "java.sql.Time");
        mapSQLtypeCodeToJavaClass.put(93, "java.sql.Timestamp");
        BOOLEANPATTERN = Pattern.compile("((?i)true|(?i)false)", 32);
    }

    public static enum EclTypes {
        ECLTypeboolean(0),
        ECLTypeint(1),
        ECLTypereal(2),
        ECLTypedecimal(3),
        ECLTypestring(4),
        ECLTypeunused1(5),
        ECLTypedate(6),
        ECLTypeunused2(7),
        ECLTypeunused3(8),
        ECLTypebitfield(9),
        ECLTypeunused4(10),
        ECLTypechar(11),
        ECLTypeenumerated(12),
        ECLTyperecord(13),
        ECLTypevarstring(14),
        ECLTypeblob(15),
        ECLTypedata(16),
        ECLTypepointer(17),
        ECLTypeclass(18),
        ECLTypearray(19),
        ECLTypetable(20),
        ECLTypeset(21),
        ECLTyperow(22),
        ECLTypegroupedtable(23),
        ECLTypevoid(24),
        ECLTypealien(25),
        ECLTypeswapint(26),
        ECLTypepackedint(28),
        ECLTypeunused5(29),
        ECLTypeqstring(30),
        ECLTypeunicode(31),
        ECLTypeany(32),
        ECLTypevarunicode(33),
        ECLTypepattern(34),
        ECLTyperule(35),
        ECLTypetoken(36),
        ECLTypefeature(37),
        ECLTypeevent(38),
        ECLTypenull(39),
        ECLTypescope(40),
        ECLTypeutf8(41),
        ECLTypetransform(42),
        ECLTypeifblock(43),
        ECLTypefunction(44),
        ECLTypesortlist(45),
        ECLTypemodifier(255),
        ECLTypeunsigned(256),
        ECLTypeebcdic(512),
        ECLTypestringorunicode(252),
        ECLTypenumeric(253),
        ECLTypescalar(254);


        private EclTypes(int eclcode) {
        }
    }
}

