/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.dfs.client.BinaryRecordWriter;
import org.hpccsystems.dfs.client.CompressionAlgorithm;
import org.hpccsystems.dfs.client.DataPartition;
import org.hpccsystems.dfs.client.IRecordAccessor;
import org.hpccsystems.dfs.client.RowServiceOutputStream;

public class HPCCRemoteFileWriter<T> {
    private static final Logger log = LogManager.getLogger(HPCCRemoteFileWriter.class);
    private FieldDef recordDef = null;
    private DataPartition dataPartition = null;
    private RowServiceOutputStream outputStream = null;
    private BinaryRecordWriter binaryRecordWriter = null;
    private IRecordAccessor recordAccessor = null;
    private long recordsWritten = 0L;

    public HPCCRemoteFileWriter(DataPartition dp, FieldDef recordDef, IRecordAccessor recordAccessor, CompressionAlgorithm fileCompression) throws Exception {
        this.recordDef = recordDef;
        this.dataPartition = dp;
        this.recordAccessor = recordAccessor;
        this.outputStream = new RowServiceOutputStream(this.dataPartition.getCopyIP(0), this.dataPartition.getPort(), this.dataPartition.getUseSsl(), this.dataPartition.getFileAccessBlob(), this.recordDef, this.dataPartition.getThisPart(), this.dataPartition.getCopyPath(0), fileCompression);
        this.binaryRecordWriter = new BinaryRecordWriter(this.outputStream);
        this.binaryRecordWriter.initialize(this.recordAccessor);
    }

    public void writeRecord(T record) throws Exception {
        this.binaryRecordWriter.writeRecord(record);
        ++this.recordsWritten;
    }

    public void writeRecords(Iterator<T> it) throws Exception {
        while (it.hasNext()) {
            this.binaryRecordWriter.writeRecord(it.next());
            ++this.recordsWritten;
        }
    }

    public void close() throws Exception {
        this.binaryRecordWriter.finalize();
    }

    public long getBytesWritten() {
        return this.binaryRecordWriter.getTotalBytesWritten();
    }

    public long getRecordsWritten() {
        return this.recordsWritten;
    }

    public void flush() throws Exception {
        this.binaryRecordWriter.flush();
    }

    public int getBufferCapacity() {
        return this.binaryRecordWriter.getBufferCapacity();
    }

    public int getRemainingBufferCapacity() {
        return this.binaryRecordWriter.getRemainingBufferCapacity();
    }
}

