/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.dfs.client.BinaryRecordReader;
import org.hpccsystems.dfs.client.DataPartition;
import org.hpccsystems.dfs.client.IRecordBuilder;
import org.hpccsystems.dfs.client.RowServiceInputStream;

public class HpccRemoteFileReader<T>
implements Iterator<T> {
    private static final Logger log = LogManager.getLogger(HpccRemoteFileReader.class);
    private FieldDef originalRecordDef = null;
    private DataPartition dataPartition = null;
    private RowServiceInputStream inputStream = null;
    private BinaryRecordReader binaryRecordReader;
    private IRecordBuilder recordBuilder = null;
    private boolean handlePrefetch = true;
    public static final int NO_RECORD_LIMIT = -1;
    public static final int DEFAULT_READ_SIZE_OPTION = -1;
    public static final int DEFAULT_CONNECT_TIMEOUT_OPTION = -1;

    public HpccRemoteFileReader(DataPartition dp, FieldDef originalRD, IRecordBuilder recBuilder) throws Exception {
        this(dp, originalRD, recBuilder, -1);
    }

    public HpccRemoteFileReader(DataPartition dp, FieldDef originalRD, IRecordBuilder recBuilder, int connectTimeout) throws Exception {
        this(dp, originalRD, recBuilder, connectTimeout, -1);
    }

    public HpccRemoteFileReader(DataPartition dp, FieldDef originalRD, IRecordBuilder recBuilder, int connectTimeout, int limit) throws Exception {
        this(dp, originalRD, recBuilder, connectTimeout, limit, true, -1);
    }

    public HpccRemoteFileReader(DataPartition dp, FieldDef originalRD, IRecordBuilder recBuilder, int connectTimeout, int limit, boolean createPrefetchThread, int readSizeKB) throws Exception {
        this.handlePrefetch = createPrefetchThread;
        this.originalRecordDef = originalRD;
        if (this.originalRecordDef == null) {
            throw new Exception("HpccRemoteFileReader: Original record definition is null.");
        }
        if (connectTimeout < 1) {
            connectTimeout = 5000;
        }
        this.dataPartition = dp;
        this.recordBuilder = recBuilder;
        FieldDef projectedRecordDefinition = recBuilder.getRecordDefinition();
        if (projectedRecordDefinition == null) {
            throw new Exception("IRecordBuilder does not have a valid record definition.");
        }
        this.inputStream = new RowServiceInputStream(this.dataPartition, this.originalRecordDef, projectedRecordDefinition, connectTimeout, limit, createPrefetchThread, readSizeKB);
        this.binaryRecordReader = new BinaryRecordReader(this.inputStream);
        this.binaryRecordReader.initialize(this.recordBuilder);
    }

    public void prefetch() {
        if (this.handlePrefetch) {
            log.warn("Prefetch called on an HpccRemoteFileReader that has an internal prefetch thread.");
            return;
        }
        this.inputStream.prefetchData();
    }

    @Override
    public boolean hasNext() {
        boolean rslt = false;
        try {
            rslt = this.binaryRecordReader.hasNext();
        }
        catch (HpccFileException e) {
            rslt = false;
            log.error("Read failure for " + this.dataPartition.toString());
        }
        return rslt;
    }

    @Override
    public T next() {
        Object rslt = null;
        try {
            rslt = this.binaryRecordReader.getNext();
        }
        catch (HpccFileException e) {
            log.error("Read failure for " + this.dataPartition.toString() + " " + e.getMessage());
            throw new NoSuchElementException("Fatal read error: " + e.getMessage());
        }
        return (T)rslt;
    }

    public void close() throws Exception {
        this.inputStream.close();
    }

    public int getAvailable() throws IOException {
        return this.binaryRecordReader.getAvailable();
    }
}

