/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.dfs.client.IRecordBuilder;
import org.hpccsystems.dfs.client.IRecordReader;

public class TestRecordReader
implements IRecordReader {
    private int totalTopLevelRecords = 0;
    private int generatedRecordCount = 0;
    IRecordBuilder recordBuilder = null;
    FieldDef projectedRecordDefinition = null;

    TestRecordReader(int numTopLevelRecords) {
        this.totalTopLevelRecords = numTopLevelRecords;
    }

    @Override
    public void initialize(IRecordBuilder recordBuilder) throws Exception {
        this.recordBuilder = recordBuilder;
        this.projectedRecordDefinition = recordBuilder.getRecordDefinition();
        if (this.projectedRecordDefinition.getFieldType() != FieldType.RECORD) {
            throw new Exception("Aborting record builder test. Invalid record defintion provided");
        }
    }

    @Override
    public boolean hasNext() throws HpccFileException {
        return this.generatedRecordCount < this.totalTopLevelRecords;
    }

    @Override
    public Object getNext() throws HpccFileException {
        ++this.generatedRecordCount;
        return this.createMockRecord(this.recordBuilder, this.projectedRecordDefinition);
    }

    private Object createMockValue(FieldDef fieldDef) throws HpccFileException {
        switch (fieldDef.getFieldType()) {
            case INTEGER: {
                return new Long(0L);
            }
            case REAL: {
                return new Double(1.1);
            }
            case DECIMAL: {
                return new BigDecimal(1.1);
            }
            case BINARY: {
                return new byte[0];
            }
            case BOOLEAN: {
                return new Boolean(false);
            }
            case STRING: 
            case CHAR: 
            case VAR_STRING: {
                return new String("Test");
            }
        }
        throw new HpccFileException("Encountered unexpected type while creating mock value: " + fieldDef.getFieldType());
    }

    private Object createMockRecord(IRecordBuilder recordBuilder, FieldDef recordDefinition) throws HpccFileException {
        try {
            recordBuilder.startRecord();
        }
        catch (Exception e) {
            throw new HpccFileException("Failed to start record with error: " + e.getMessage());
        }
        for (int i = 0; i < recordDefinition.getNumDefs(); ++i) {
            FieldDef fd = recordDefinition.getDef(i);
            ArrayList<Object> fieldValue = null;
            switch (fd.getFieldType()) {
                case RECORD: {
                    IRecordBuilder childRecordBuilder = recordBuilder.getChildRecordBuilder(i);
                    if (childRecordBuilder == null) {
                        throw new HpccFileException("Recieved null childRecordBuilder for record: " + fd.getFieldName());
                    }
                    fieldValue = this.createMockRecord(childRecordBuilder, fd);
                    break;
                }
                case DATASET: {
                    IRecordBuilder childRecordBuilder = recordBuilder.getChildRecordBuilder(i);
                    if (childRecordBuilder == null) {
                        throw new HpccFileException("Recieved null childRecordBuilder for dataset: " + fd.getFieldName());
                    }
                    Object childRecord = this.createMockRecord(childRecordBuilder, fd.getDef(0));
                    ArrayList<Object> dataset = new ArrayList<Object>();
                    dataset.add(childRecord);
                    fieldValue = dataset;
                    break;
                }
                case SET: {
                    Object childValue = this.createMockValue(fd.getDef(0));
                    ArrayList<Object> set = new ArrayList<Object>();
                    set.add(childValue);
                    fieldValue = set;
                    break;
                }
                case INTEGER: 
                case REAL: 
                case DECIMAL: 
                case BINARY: 
                case BOOLEAN: 
                case STRING: 
                case CHAR: 
                case VAR_STRING: {
                    fieldValue = this.createMockValue(fd);
                    break;
                }
                default: {
                    throw new HpccFileException("Encountered unexpected type while creating mock record: " + fd.getFieldType());
                }
            }
            try {
                recordBuilder.setFieldValue(i, fieldValue);
                continue;
            }
            catch (Exception e) {
                throw new HpccFileException("Failed to set value for field: " + fd.getFieldName() + " of type: " + fd.getFieldType() + " with error: " + e.getMessage());
            }
        }
        Object record = null;
        try {
            record = recordBuilder.finalizeRecord();
        }
        catch (Exception e) {
            throw new HpccFileException("Failed to finalize record with error: " + e.getMessage());
        }
        if (record == null) {
            throw new HpccFileException("Finalize record returned a null reference");
        }
        return record;
    }

    @Override
    public int getAvailable() throws IOException {
        return 1024;
    }
}

