/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.Stub;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.Copy;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.CopyResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.DFUWorkunitsActionResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.DeleteDropZoneFilesRequest;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.DropZone;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.DropZoneFileSearchRequest;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.DropZoneFileSearchResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.DropZoneFilesRequest;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.DropZoneFilesResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.EspSoapFault;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.EspStringArray;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.FileListRequest;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.FileListResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.FileSprayPingRequest;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.FileSprayStub;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.GetDFUWorkunit;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.GetDFUWorkunitResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.GetDFUWorkunits;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.GetDFUWorkunitsResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.PhysicalFileStruct;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.ProgressRequest;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.ProgressResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.SprayFixed;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.SprayFixedResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.SprayResponse;
import org.hpccsystems.ws.client.gen.axis2.filespray.v1_17.SprayVariable;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.utils.DelimitedDataOptions;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.utils.Sftp;
import org.hpccsystems.ws.client.utils.Utils;
import org.hpccsystems.ws.client.wrappers.EspSoapFaultWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.DFUWorkunitsActionResponseWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.DropZoneFilesRequestWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.DropZoneFilesResponseWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.DropZoneWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.EspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.GetDFUWorkunitResponseWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.GetDFUWorkunitsResponseWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.PhysicalFileStructWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.ProgressResponseWrapper;

public class HPCCFileSprayClient
extends BaseHPCCWsClient {
    private static final String FILESPRAYWSDLURI = "/FileSpray";
    private static final String UPLOADURI = "/FileSpray/UploadFile?upload_";
    private static final String DOWNLOAD_URI = "/FileSpray/DownloadFile?";
    private static final long MAX_FILE_WSUPLOAD_SIZE = 2000000000L;
    private int BUFFER_LENGTH = 1024;
    List<DropZoneWrapper> localDropZones = null;
    private static Logger log = LogManager.getLogger(HPCCFileSprayClient.class);
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;
    private static final PhysicalFileStruct[] NO_FILES = new PhysicalFileStruct[0];

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCFileSprayClient.getServiceWSDLURL(new FileSprayStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    public static String getServiceURI() {
        return FILESPRAYWSDLURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCFileSprayClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCFileSprayClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new FileSprayStub();
    }

    public static HPCCFileSprayClient get(Connection connection) {
        return new HPCCFileSprayClient(connection);
    }

    public static HPCCFileSprayClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCFileSprayClient(conn);
    }

    public static HPCCFileSprayClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCFileSprayClient(conn);
    }

    protected HPCCFileSprayClient(Connection baseConnection) {
        this.initWsFileSprayStub(baseConnection);
    }

    private void initWsFileSprayStub(Connection connection) {
        block3: {
            try {
                this.fsconn = connection;
                this.stub = HPCCFileSprayClient.setStubOptions(new FileSprayStub(connection.getBaseUrl() + FILESPRAYWSDLURI), connection);
            }
            catch (AxisFault e) {
                log.error("Could not initialize FileSprayStub- Review all HPCC connection values");
                e.printStackTrace();
            }
            catch (Exception e) {
                log.error("Could not initialize FileSprayStub- Review all HPCC connection values");
                if (e.getLocalizedMessage().isEmpty()) break block3;
                this.initErrMessage = e.getLocalizedMessage();
                log.error(e.getLocalizedMessage());
            }
        }
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        FileSprayPingRequest request = new FileSprayPingRequest();
        try {
            ((FileSprayStub)this.stub).ping(request);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public int getFileUploadReadBufferLength() {
        return this.BUFFER_LENGTH;
    }

    public void setFileUploadReadBufferLength(int length) {
        this.BUFFER_LENGTH = length;
    }

    public boolean handleSprayResponse(ProgressResponseWrapper progressResponseWrapper, int maxRetries, int milliesBetweenRetry) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        boolean success = false;
        ProgressResponseWrapper progressResponse = null;
        ArrayOfEspExceptionWrapper exceptions = progressResponseWrapper.getExceptions();
        if (exceptions != null) {
            for (EspExceptionWrapper espexception : exceptions.getException()) {
                log.error("Error spraying file: " + espexception.getSource() + espexception.getMessage());
            }
        } else {
            this.verifyStub();
            log.debug("Spray file DWUID: " + progressResponseWrapper.getWuid());
            progressResponse = this.getDfuProgress(progressResponseWrapper.getWuid());
            if (progressResponse.getExceptions() != null) {
                log.error("Spray progress status fetch failed.");
            } else {
                String state = progressResponse.getState();
                log.debug(progressResponse.getState());
                if (!state.equalsIgnoreCase("FAILED")) {
                    for (int i = 0; i < maxRetries && progressResponse.getPercentDone() < 100 && !progressResponse.getState().equalsIgnoreCase("FAILED"); ++i) {
                        log.debug(progressResponse.getProgressMessage());
                        progressResponse = this.getDfuProgress(progressResponseWrapper.getWuid());
                        try {
                            if (milliesBetweenRetry <= 0) {
                                milliesBetweenRetry = 100;
                            }
                            Thread.sleep(milliesBetweenRetry);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException("Unexpected interrupt", e);
                        }
                    }
                    log.debug(progressResponse.getProgressMessage());
                    success = true;
                } else {
                    log.error("Spray failed.");
                }
                log.debug("Final summary from server: " + progressResponse.getSummaryMessage());
                log.info("Spray attempt completed, verify DWUID: " + progressResponseWrapper.getWuid());
            }
        }
        return success;
    }

    public static DelimitedDataOptions createDelimitedDataOptionsObject(String recordTerminator, String fieldDelimiter, String escapeSequence, String quote) {
        return new DelimitedDataOptions(recordTerminator, fieldDelimiter, escapeSequence, quote);
    }

    public List<DropZoneWrapper> fetchLocalDropZones() throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        return this.fetchDropZones("localhost");
    }

    public List<DropZoneWrapper> fetchDropZones(String dropzoneNetAddress) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DropZoneFilesRequest request = new DropZoneFilesRequest();
        request.setNetAddress(dropzoneNetAddress);
        request.setDirectoryOnly(false);
        DropZoneFilesResponse resp = null;
        try {
            resp = ((FileSprayStub)this.stub).dropZoneFiles(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.fetchDropzones(" + dropzoneNetAddress + ") encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not FetchDropzones");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not FetchDropzones");
        }
        ArrayList<DropZoneWrapper> dropZonesWrapper = null;
        if (resp.getDropZones() != null) {
            dropZonesWrapper = new ArrayList<DropZoneWrapper>();
            DropZone[] dropZone = resp.getDropZones().getDropZone();
            for (int i = 0; i < dropZone.length; ++i) {
                dropZonesWrapper.add(new DropZoneWrapper(dropZone[i]));
            }
        }
        return dropZonesWrapper;
    }

    public String copyFile(String from, String to, boolean overwrite) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        Copy cp = new Copy();
        cp.setSourceLogicalName(from);
        cp.setDestLogicalName(to);
        cp.setOverwrite(overwrite);
        CopyResponse resp = null;
        try {
            resp = ((FileSprayStub)this.stub).copy(cp);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.copy(from,to,overwrite) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not copy file");
        }
        if (resp != null && resp.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not Copy File");
        }
        return resp.getResult();
    }

    public DropZoneFilesResponseWrapper fetchDropZones(String dzname, String netaddress, String os, String path, String subfolder, boolean dironly, boolean watchvisibleonely) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DropZoneFilesRequest request = new DropZoneFilesRequest();
        request.setDirectoryOnly(dironly);
        request.setDropZoneName(dzname);
        request.setECLWatchVisibleOnly(watchvisibleonely);
        request.setNetAddress(netaddress);
        request.setOS(os);
        request.setPath(path);
        request.setSubfolder(subfolder);
        return this.fetchDropZones(new DropZoneFilesRequestWrapper(request));
    }

    public DropZoneFilesResponseWrapper fetchDropZones(DropZoneFilesRequestWrapper szrequest) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        if (szrequest == null) {
            throw new Exception("DropZoneFilesRequestWrapper null detected");
        }
        this.verifyStub();
        DropZoneFilesResponse resp = null;
        try {
            resp = ((FileSprayStub)this.stub).dropZoneFiles(szrequest.getRaw());
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.fetchDropzones(DropZoneFilesRequestWrapper) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not FetchDropzones");
        }
        if (resp != null && resp.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not FetchDropzones");
        }
        return new DropZoneFilesResponseWrapper(resp);
    }

    public PhysicalFileStruct[] dzFileSearch(String dzname, String netaddr, String namefilter) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DropZoneFileSearchRequest request = new DropZoneFileSearchRequest();
        request.setDropZoneName(dzname);
        request.setNameFilter(namefilter);
        request.setServer(netaddr);
        DropZoneFileSearchResponse resp = null;
        try {
            resp = ((FileSprayStub)this.stub).dropZoneFileSearch(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.dzFileSearch(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform DZFileSearch");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not perform DZFileSearch");
        }
        if (resp.getFiles() == null) {
            return NO_FILES;
        }
        return resp.getFiles().getPhysicalFileStruct();
    }

    public List<PhysicalFileStructWrapper> listFiles(String netAddress, String path, String OS) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        PhysicalFileStruct[] physicalFileStruct;
        this.verifyStub();
        FileListRequest request = new FileListRequest();
        request.setNetaddr(netAddress);
        request.setPath(path);
        if (OS != null) {
            request.setOS(OS);
        }
        FileListResponse resp = null;
        try {
            resp = ((FileSprayStub)this.stub).fileList(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.listFiles(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not ListFiles");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not ListFiles");
        }
        ArrayList<PhysicalFileStructWrapper> physicalFileStructWrappers = new ArrayList<PhysicalFileStructWrapper>();
        if (resp.getFiles() != null && (physicalFileStruct = resp.getFiles().getPhysicalFileStruct()) != null && physicalFileStruct.length > 0) {
            for (int i = 0; i < physicalFileStruct.length; ++i) {
                physicalFileStructWrappers.add(new PhysicalFileStructWrapper(physicalFileStruct[i]));
            }
        }
        return physicalFileStructWrappers;
    }

    public ProgressResponseWrapper sprayVariable(String dropzoneNetAddress, String sourceFileName, String targetFileName, String prefix, String destGroup, boolean overwrite) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        DelimitedDataOptions defaultcsv = new DelimitedDataOptions();
        return this.sprayVariable(dropzoneNetAddress, defaultcsv, sourceFileName, targetFileName, prefix, destGroup, overwrite);
    }

    public ProgressResponseWrapper sprayVariable(String dropzoneNetAddress, DelimitedDataOptions options, String sourceFileName, String targetFileName, String prefix, String destGroup, boolean overwrite) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        List<DropZoneWrapper> targetDropZones = this.fetchDropZones(dropzoneNetAddress);
        if (targetDropZones == null) {
            throw new Exception("Could not fetch target Dropzone");
        }
        return this.sprayVariable(options, targetDropZones.get(0), sourceFileName, targetFileName, prefix, destGroup, overwrite);
    }

    public ProgressResponseWrapper sprayVariableLocalDropZone(DelimitedDataOptions options, String sourceFileName, String targetFileName, String prefix, String destGroup, boolean overwrite, SprayVariableFormat format) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        if (this.localDropZones == null) {
            this.localDropZones = this.fetchLocalDropZones();
        }
        return this.sprayVariable(options, this.localDropZones.get(0), sourceFileName, targetFileName, prefix, destGroup, overwrite, format, null, null, null, null, null, null, null);
    }

    public ProgressResponseWrapper sprayVariable(DelimitedDataOptions options, DropZoneWrapper targetDropZone, String sourceFileName, String targetFileName, String prefix, String destGroup, boolean overwrite) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        return this.sprayVariable(options, targetDropZone, sourceFileName, targetFileName, prefix, destGroup, overwrite, SprayVariableFormat.DFUff_csv, null, null, null, null, null, null, null);
    }

    public ProgressResponseWrapper sprayVariable(DelimitedDataOptions options, DropZoneWrapper targetDropZone, String sourceFileName, String targetFileName, String prefix, String destGroup, boolean overwrite, SprayVariableFormat format, Integer sourceMaxRecordSize, Integer maxConnections, Boolean compress, Boolean replicate, Boolean failIfNoSourceFile, Boolean recordStructurePresent, Integer expireDays) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        if (targetDropZone == null) {
            throw new Exception("TargetDropZone object not available!");
        }
        SprayVariable request = new SprayVariable();
        request.setSourceIP(targetDropZone.getNetAddress());
        request.setSourcePath(targetDropZone.getPath() + "/" + sourceFileName);
        request.setDestGroup(destGroup);
        request.setDestLogicalName(targetFileName);
        request.setOverwrite(overwrite);
        request.setSourceCsvEscape(options.getEscapeSequence());
        request.setSourceCsvSeparate(options.getFieldDelimiter());
        if (options.getFieldDelimiter().equals(",")) {
            request.setSourceCsvSeparate("\\,");
        } else {
            request.setSourceCsvSeparate(options.getFieldDelimiter());
        }
        request.setSourceCsvQuote(options.getQuote());
        request.setSourceCsvTerminate(options.getRecordTerminator());
        request.setSourceFormat(format.getValue());
        if (sourceMaxRecordSize != null) {
            request.setSourceMaxRecordSize(sourceMaxRecordSize);
        }
        if (maxConnections != null) {
            request.setMaxConnections(maxConnections);
        }
        if (replicate != null) {
            request.setReplicate(replicate);
        }
        if (compress != null) {
            request.setCompress(compress);
        }
        if (failIfNoSourceFile != null) {
            request.setFailIfNoSourceFile(failIfNoSourceFile);
        }
        if (recordStructurePresent != null) {
            request.setRecordStructurePresent(recordStructurePresent);
        }
        if (expireDays != null) {
            request.setExpireDays(expireDays);
        }
        SprayResponse resp = null;
        try {
            resp = ((FileSprayStub)this.stub).sprayVariable(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.sprayVariable(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not SprayVariable");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not SprayVariable");
        }
        return this.getDfuProgress(resp.getWuid());
    }

    public ProgressResponseWrapper sprayLocalXML(String sourceFileName, String targetFileName, String prefix, String destGroup, boolean overwrite) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        if (this.localDropZones == null) {
            this.localDropZones = this.fetchLocalDropZones();
        }
        return this.sprayXML(this.localDropZones.get(0), sourceFileName, targetFileName, prefix, destGroup, "tag", overwrite, SprayVariableFormat.DFUff_ascii, null, null, null, null, null, null);
    }

    public ProgressResponseWrapper sprayLocalXML(String sourceFileName, String targetFileName, String prefix, String destGroup, boolean overwrite, SprayVariableFormat format, String rowtag, Integer maxrecsize) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        if (this.localDropZones == null) {
            this.localDropZones = this.fetchLocalDropZones();
        }
        return this.sprayXML(this.localDropZones.get(0), sourceFileName, targetFileName, prefix, destGroup, rowtag, overwrite, format, maxrecsize, null, null, null, null, null);
    }

    public ProgressResponseWrapper sprayXML(DropZoneWrapper targetDropZone, String sourceFileName, String targetFileName, String prefix, String destGroup, String rowtag, boolean overwrite, SprayVariableFormat format, Integer maxrecsize, Integer maxConnections, Boolean replicate, Boolean compress, Boolean failIfNoSourceFile, Integer expireDays) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        if (targetDropZone == null) {
            throw new Exception("TargetDropZone object not available!");
        }
        SprayVariable request = new SprayVariable();
        request.setDestGroup(destGroup);
        request.setSourceIP(targetDropZone.getNetAddress());
        request.setSourcePath(targetDropZone.getPath() + "/" + sourceFileName);
        request.setDestLogicalName(targetFileName);
        request.setOverwrite(overwrite);
        request.setSourceFormat(format.getValue());
        request.setSourceMaxRecordSize(maxrecsize);
        request.setSourceRowTag(rowtag);
        if (maxConnections != null) {
            request.setMaxConnections(maxConnections);
        }
        if (replicate != null) {
            request.setReplicate(replicate);
        }
        if (compress != null) {
            request.setCompress(compress);
        }
        if (failIfNoSourceFile != null) {
            request.setFailIfNoSourceFile(failIfNoSourceFile);
        }
        if (expireDays != null) {
            request.setExpireDays(expireDays);
        }
        SprayResponse resp = null;
        try {
            resp = ((FileSprayStub)this.stub).sprayVariable(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.sprayXML(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not SprayXML");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not SprayXML");
        }
        return this.getDfuProgress(resp.getWuid());
    }

    public ProgressResponseWrapper sprayFixed(String dropzoneNetAddress, String sourceFileName, int recordSize, String targetFileLabel, String prefix, String destGroup, boolean overwrite) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        List<DropZoneWrapper> targetDropZones = this.fetchDropZones(dropzoneNetAddress);
        if (targetDropZones == null) {
            throw new Exception("Could not fetch target Dropzone");
        }
        return this.sprayFixed(targetDropZones.get(0), sourceFileName, recordSize, targetFileLabel, prefix, destGroup, overwrite, null, false, false, false, -1, null, null, null, null, null, null);
    }

    public ProgressResponseWrapper sprayFixedLocalDropZone(String sourceFileName, int recordSize, String targetFileLabel, String prefix, String destGroup, boolean overwrite) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        if (this.localDropZones == null) {
            this.localDropZones = this.fetchLocalDropZones();
        }
        return this.sprayFixed(this.localDropZones.get(0), sourceFileName, recordSize, targetFileLabel, prefix, destGroup, overwrite, null, false, false, false, -1, null, null, null, null, null, null);
    }

    public ProgressResponseWrapper sprayFixed(DropZoneWrapper targetDropZone, String sourceFileName, int recordSize, String targetFileLabel, String prefix, String destGroup, boolean overwrite, Integer maxConnections, Boolean compress, Boolean replicate, Boolean failIfNoSourceFile, Integer expireDays, String decryptKey, String encryptKey, Boolean nosplit, Boolean recordStructurePresent, Integer transferBufferSize, Boolean wrap) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        if (targetDropZone == null) {
            throw new Exception("TargetDropZone object not available!");
        }
        SprayFixed request = new SprayFixed();
        request.setDestGroup(destGroup);
        request.setSourceRecordSize(recordSize);
        request.setSourceIP(targetDropZone.getNetAddress());
        request.setSourcePath(targetDropZone.getPath() + "/" + sourceFileName);
        request.setDestLogicalName(targetFileLabel);
        request.setOverwrite(overwrite);
        request.setPrefix(prefix);
        if (maxConnections != null) {
            request.setMaxConnections(maxConnections);
        }
        if (compress != null) {
            request.setCompress(compress);
        }
        if (replicate != null) {
            request.setReplicate(replicate);
        }
        if (failIfNoSourceFile != null) {
            request.setFailIfNoSourceFile(failIfNoSourceFile);
        }
        if (expireDays != null) {
            request.setExpireDays(expireDays);
        }
        if (decryptKey != null && !decryptKey.isEmpty()) {
            request.setDecrypt(decryptKey);
        }
        if (encryptKey != null && !encryptKey.isEmpty()) {
            request.setEncrypt(encryptKey);
        }
        if (nosplit != null) {
            request.setNosplit(nosplit);
        }
        if (recordStructurePresent != null) {
            request.setRecordStructurePresent(recordStructurePresent);
        }
        if (transferBufferSize != null) {
            request.setTransferBufferSize(transferBufferSize);
        }
        if (wrap != null) {
            request.setWrap(wrap);
        }
        SprayFixedResponse resp = null;
        try {
            resp = ((FileSprayStub)this.stub).sprayFixed(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.sprayFixed(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not SprayFixed");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not SprayFixed");
        }
        return this.getDfuProgress(resp.getWuid());
    }

    public ProgressResponseWrapper getDfuProgress(String dfuwuid) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        ProgressRequest request = new ProgressRequest();
        request.setWuid(dfuwuid);
        ProgressResponse resp = null;
        try {
            resp = ((FileSprayStub)this.stub).getDFUProgress(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.getDfuProgress(" + dfuwuid + ") encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform GetDfuProgress");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not perform GetDfuProgress");
        }
        return new ProgressResponseWrapper(resp);
    }

    public boolean uploadFile(File file, String targetDropzoneAddress) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        List<DropZoneWrapper> dropZones = this.fetchDropZones(targetDropzoneAddress);
        if (dropZones == null || dropZones.size() <= 0) {
            throw new Exception("Could not fetch target dropzone information");
        }
        return this.uploadFile(file, dropZones.get(0));
    }

    public boolean uploadFileLocalDropZone(File file) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        List<DropZoneWrapper> fetchLocalDropZones = this.fetchLocalDropZones();
        if (fetchLocalDropZones == null || fetchLocalDropZones.size() <= 0) {
            throw new Exception("Could not fetch local dropzone information");
        }
        return this.uploadFile(file, fetchLocalDropZones.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadLargeFile(File uploadFile, DropZoneWrapper dropZone) {
        if (uploadFile == null || dropZone == null) {
            return false;
        }
        Boolean returnValue = true;
        URLConnection fileUploadConnection = null;
        URL fileUploadURL = null;
        String uploadurlbuilder = UPLOADURI;
        uploadurlbuilder = uploadurlbuilder + "&NetAddress=" + dropZone.getNetAddress();
        uploadurlbuilder = uploadurlbuilder + "&Path=" + dropZone.getPath();
        uploadurlbuilder = uploadurlbuilder + "&OS=" + (Utils.currentOSisLinux() ? "1" : "0");
        Channel outchannel = null;
        AbstractInterruptibleChannel inChannel = null;
        OutputStream output = null;
        InputStream input = null;
        RandomAccessFile aFile = null;
        try {
            String boundary = Utils.createBoundary();
            fileUploadURL = new URL(this.fsconn.getUrl() + uploadurlbuilder);
            fileUploadConnection = Connection.createConnection(fileUploadURL);
            fileUploadConnection = fileUploadURL.openConnection();
            fileUploadConnection.setDoOutput(true);
            fileUploadConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            fileUploadConnection.setRequestProperty("Authorization", this.fsconn.getBasicAuthString());
            output = fileUploadConnection.getOutputStream();
            Utils.startMulti(output, uploadFile.getName(), boundary, "");
            input = new FileInputStream(uploadFile.getAbsolutePath());
            ByteBuffer buffer = ByteBuffer.allocate(this.BUFFER_LENGTH * 16);
            aFile = new RandomAccessFile(uploadFile.getAbsolutePath(), "rw");
            inChannel = aFile.getChannel();
            outchannel = Channels.newChannel(output);
            try {
                while (((FileChannel)inChannel).read(buffer) > 0) {
                    buffer.flip();
                    while (buffer.hasRemaining()) {
                        outchannel.write(buffer);
                    }
                    buffer.clear();
                }
            }
            catch (IOException e) {
                log.error("Encountered error while reading file: " + e.getLocalizedMessage());
                returnValue = false;
            }
            finally {
                Utils.closeMulti(output, boundary);
            }
            StringBuffer response = new StringBuffer();
            BufferedReader rreader = new BufferedReader(new InputStreamReader(fileUploadConnection.getInputStream()));
            String line = null;
            while ((line = rreader.readLine()) != null) {
                response.append(line);
            }
        }
        catch (MalformedURLException e) {
            log.error("There was a malformed URL: " + e.getLocalizedMessage());
            returnValue = false;
        }
        catch (IOException e) {
            log.error("There was an error opening the file: " + e.getLocalizedMessage());
            e.printStackTrace();
            returnValue = false;
        }
        finally {
            try {
                outchannel.close();
                inChannel.close();
                output.close();
                input.close();
                aFile.close();
            }
            catch (IOException e) {
                log.error("Encountered error while closing: " + e.getLocalizedMessage());
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFile(File file, DropZoneWrapper dropZone) throws Exception {
        if (file == null) {
            return false;
        }
        String filename = file.getName();
        long length = file.length();
        if (length > 2000000000L) {
            throw new Exception("Uploading files of this magnitude is not supported, use SFTP based functions");
        }
        InputStream fileInput = null;
        OutputStream uploadOutStream = null;
        URLConnection fileUploadConnection = null;
        URL fileUploadURL = null;
        String boundary = Utils.createBoundary();
        try {
            int bytesReadCount;
            if (dropZone == null) {
                throw new Exception("Dropzone information not available");
            }
            String uploadurlbuilder = UPLOADURI;
            uploadurlbuilder = uploadurlbuilder + "&NetAddress=" + dropZone.getNetAddress();
            uploadurlbuilder = uploadurlbuilder + "&Path=" + dropZone.getPath();
            uploadurlbuilder = uploadurlbuilder + "&OS=" + (Utils.currentOSisLinux() ? "1" : "0");
            fileUploadURL = new URL(this.fsconn.getUrl() + uploadurlbuilder);
            fileUploadConnection = Connection.createConnection(fileUploadURL);
            if (this.fsconn.hasCredentials()) {
                fileUploadConnection.setRequestProperty("Authorization", this.fsconn.getBasicAuthString());
            }
            fileUploadConnection.setRequestProperty("Content-Length", Long.toString(length));
            fileUploadConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            uploadOutStream = fileUploadConnection.getOutputStream();
            Utils.startMulti(uploadOutStream, filename, boundary, "");
            fileInput = new FileInputStream(file);
            byte[] bytesReadFromFile = new byte[this.BUFFER_LENGTH];
            while ((bytesReadCount = fileInput.read(bytesReadFromFile, 0, this.BUFFER_LENGTH)) != -1) {
                uploadOutStream.write(bytesReadFromFile, 0, bytesReadCount);
                uploadOutStream.flush();
            }
            Utils.closeMulti(uploadOutStream, boundary);
            StringBuffer response = new StringBuffer();
            BufferedReader rreader = new BufferedReader(new InputStreamReader(fileUploadConnection.getInputStream()));
            String line = null;
            while ((line = rreader.readLine()) != null) {
                response.append(line);
            }
            log.debug("File upload has finished, please fetch file list to verify upload");
        }
        catch (Exception e) {
            if (!fileUploadURL.equals(fileUploadConnection.getURL())) {
                log.error("HTTP Error reported on File upload related to a server redirect (" + fileUploadURL + " vs " + fileUploadConnection.getURL() + "), please verify on server.", (Throwable)e);
            } else {
                log.error("Failed to upload file.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileInput != null) {
                    fileInput.close();
                }
            }
            catch (IOException iOException) {}
            if (uploadOutStream != null) {
                try {
                    uploadOutStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public long downloadFile(File outFile, DropZoneWrapper dropZone, String fileName) {
        if (outFile == null) {
            log.error("File download failed. Valid output File object is required.");
            return -1L;
        }
        if (fileName == null) {
            log.error("File download failed. No filename provided.");
            return -1L;
        }
        long bytesTransferred = -1L;
        try {
            FileOutputStream outputStream = new FileOutputStream(outFile);
            bytesTransferred = this.downloadFile(outputStream.getChannel(), dropZone, fileName);
            outputStream.close();
        }
        catch (Exception e) {
            log.error("File download failed with error message: " + e.getMessage());
        }
        return bytesTransferred;
    }

    public long downloadFile(FileChannel outputChannel, DropZoneWrapper dropZone, String fileName) {
        if (outputChannel == null) {
            log.error("File download failed. Output channel is required.");
            return -1L;
        }
        if (dropZone == null) {
            log.error("File download failed. Dropzone is required.");
            return -1L;
        }
        if (fileName == null) {
            log.error("File download failed. No filename provided.");
            return -1L;
        }
        long fileSize = 0L;
        try {
            List<PhysicalFileStructWrapper> filesInDropzone = this.listFiles(dropZone.getNetAddress(), dropZone.getPath(), null);
            boolean fileWasFound = false;
            for (int i = 0; i < filesInDropzone.size(); ++i) {
                if (!filesInDropzone.get(i).getName().equals(fileName)) continue;
                if (filesInDropzone.get(i).getIsDir()) {
                    throw new Exception("Specified file name: " + fileName + ", is a directory. Downloading directories is unsupported.");
                }
                fileWasFound = true;
                fileSize = filesInDropzone.get(i).getFilesize();
            }
            if (!fileWasFound) {
                throw new Exception("Specified file was not found: " + fileName);
            }
        }
        catch (Exception e) {
            log.error("File download failed. Drop zone file enumeration failed with error: " + e.getMessage());
            return -1L;
        }
        URL downloadURL = null;
        try {
            downloadURL = new URL(this.fsconn.getUrl() + DOWNLOAD_URI + "Name=" + fileName + "&NetAddress=" + dropZone.getNetAddress() + "&Path=" + dropZone.getPath() + "&OS=" + (Utils.currentOSisLinux() ? "1" : "0"));
        }
        catch (MalformedURLException e) {
            log.error("File download failed, due to malformed URL. Check dropzone path. Error message: " + e.getMessage());
            return -1L;
        }
        long bytesTransferred = -1L;
        try {
            ReadableByteChannel sourceChannel = Channels.newChannel(downloadURL.openStream());
            bytesTransferred = outputChannel.transferFrom(sourceChannel, 0L, Long.MAX_VALUE);
            sourceChannel.close();
            outputChannel.close();
        }
        catch (IOException e) {
            log.error("Failed to download file with error: " + e.getMessage());
        }
        if (bytesTransferred < fileSize) {
            log.warn("File download fewer bytes transferred than expected. Transferred: " + bytesTransferred + " Expected: " + fileSize);
        }
        return bytesTransferred;
    }

    public void sftpPutFileOnTargetLandingZone(String localFileName, String targetFilename, String machineLoginUserName, String password) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.sftpPutFileOnTargetLandingZone(localFileName, this.fsconn.getHost(), targetFilename, machineLoginUserName, password, null);
    }

    public void sftpPutFileOnTargetLandingZone(String localFileName, String targetFilename, String machineLoginUserName, String password, Properties connconfig) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.sftpPutFileOnTargetLandingZone(localFileName, this.fsconn.getHost(), targetFilename, machineLoginUserName, password, connconfig);
    }

    public void sftpPutFileOnTargetLandingZone(String localFileName, String targetDropzoneAddress, String targetFilename, String machineLoginUserName, String password, Properties connconfig) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        List<DropZoneWrapper> dropZones = this.fetchDropZones(targetDropzoneAddress);
        if (dropZones == null || dropZones.size() <= 0) {
            throw new Exception("Could not fetch target dropzone information");
        }
        Sftp.lzPut(localFileName, targetDropzoneAddress, dropZones.get(0).getPath(), targetFilename, machineLoginUserName, password, dropZones.get(0).getLinux().equals("true"), connconfig);
    }

    public GetDFUWorkunitResponseWrapper getDFUWorkunit(String workunitid) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        GetDFUWorkunit request = new GetDFUWorkunit();
        request.setWuid(workunitid);
        GetDFUWorkunitResponse response = null;
        try {
            response = ((FileSprayStub)this.stub).getDFUWorkunit(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.getDFUWorkunit(" + workunitid + ") encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform GetDFUWorkunit");
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not perform GetDFUWorkunit");
        }
        return new GetDFUWorkunitResponseWrapper(response);
    }

    public GetDFUWorkunitsResponseWrapper getDFUWorkunits(String cluster, Long pagesize) throws Exception, org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper {
        this.verifyStub();
        GetDFUWorkunits request = new GetDFUWorkunits();
        request.setPageSize(pagesize);
        request.setCluster(cluster);
        GetDFUWorkunitsResponse response = null;
        try {
            response = ((FileSprayStub)this.stub).getDFUWorkunits(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCFileSprayClient.getDFUWorkunits(" + cluster + "," + pagesize + ") encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform GetDFUWorkunits");
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not perform GetDFUWorkunits");
        }
        return new GetDFUWorkunitsResponseWrapper(response);
    }

    public DFUWorkunitsActionResponseWrapper deleteDropZoneFiles(String dropzoneName, List<String> fileNames, String netAddress, String path, String os) throws Exception {
        this.verifyStub();
        EspStringArray espStringArray = new EspStringArray();
        fileNames.forEach(fileName -> espStringArray.addItem((String)fileName));
        DeleteDropZoneFilesRequest request = new DeleteDropZoneFilesRequest();
        request.setDropZoneName(dropzoneName);
        request.setNames(espStringArray);
        request.setNetAddress(netAddress);
        request.setPath(path);
        request.setOS(os);
        DFUWorkunitsActionResponse response = ((FileSprayStub)this.stub).deleteDropZoneFiles(request);
        return new DFUWorkunitsActionResponseWrapper(response);
    }

    @Override
    public boolean equals(Object aThat) {
        boolean eq = super.equals(aThat);
        if (eq) {
            Options thatopt;
            HPCCFileSprayClient that = (HPCCFileSprayClient)aThat;
            try {
                Stub thatStub = that.verifyStub();
                thatopt = thatStub._getServiceClient().getOptions();
            }
            catch (Exception e) {
                thatopt = null;
            }
            if (thatopt == null) {
                return false;
            }
            EqualsUtil.areEqual(this.getFileUploadReadBufferLength(), that.getFileUploadReadBufferLength());
        }
        return eq;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return HashCodeUtil.hash(result, this.getFileUploadReadBufferLength());
    }

    public static enum SprayVariableFormat {
        DFUff_fixed(0),
        DFUff_csv(1),
        DFUff_ascii(1),
        DFUff_utf8(2),
        DFUff_utf8n(3),
        DFUff_utf16(4),
        DFUff_utf16le(5),
        DFUff_utf16be(6),
        DFUff_utf32(7),
        DFUff_utf32le(8),
        DFUff_utf32be(9),
        DFUff_variable(10),
        DFUff_recfmvb(11),
        DFUff_recfmv(12),
        DFUff_variablebigendian(13);

        private final int id;
        private static final HashMap<String, SprayVariableFormat> mapVariableSprayFormatNameCode;

        private SprayVariableFormat(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }

        public static SprayVariableFormat convertVarSprayFormatName2Code(String varSprayFormatName) {
            String lower = varSprayFormatName.toLowerCase();
            if (mapVariableSprayFormatNameCode.containsKey(lower)) {
                return mapVariableSprayFormatNameCode.get(lower);
            }
            return DFUff_fixed;
        }

        static {
            mapVariableSprayFormatNameCode = new HashMap();
            mapVariableSprayFormatNameCode.put("csv", DFUff_csv);
            mapVariableSprayFormatNameCode.put("ascii", DFUff_ascii);
            mapVariableSprayFormatNameCode.put("utf8", DFUff_utf8);
            mapVariableSprayFormatNameCode.put("utf16", DFUff_utf16);
            mapVariableSprayFormatNameCode.put("utf16le", DFUff_utf16le);
            mapVariableSprayFormatNameCode.put("utf16be", DFUff_utf16be);
            mapVariableSprayFormatNameCode.put("utf32", DFUff_utf32);
            mapVariableSprayFormatNameCode.put("utf32le", DFUff_utf32le);
            mapVariableSprayFormatNameCode.put("utf32be", DFUff_utf32be);
            mapVariableSprayFormatNameCode.put("variable", DFUff_variable);
            mapVariableSprayFormatNameCode.put("recfmvb", DFUff_recfmvb);
            mapVariableSprayFormatNameCode.put("recfmv", DFUff_recfmv);
            mapVariableSprayFormatNameCode.put("variablebigendian", DFUff_variablebigendian);
            mapVariableSprayFormatNameCode.put("fixed", DFUff_fixed);
        }
    }
}

