/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.types.NonNegativeInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.HPCCWsSMCClient;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.EspStringArray;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.WUAction;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.WUQuery;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.WUQueryResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ApplicationValue;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ArrayOfApplicationValue;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ArrayOfECLWorkunit;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ArrayOfEspException;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ArrayOfNamedValue;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ECLWUActions;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ECLWorkunit;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.EspSoapFault;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.FileUsedByQuery;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.NamedValue;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.Ping;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.Queries_type0;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.QuerySet;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.QuerySetQuery;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.QuerySetQueryActionItem;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.QuerySetQueryActionResult;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.QuerySetQueryActionTypes;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUAbort;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUActionResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUDelete;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUDeleteResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUFile;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUListQueries;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUListQueriesResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WULogFileResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUPublishWorkunit;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUPublishWorkunitResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQueryFiles;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQueryFilesResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuerySetDetailsResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuerySetQueryActionResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuerysetDetails;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuerysetQueryAction;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuerysets;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuerysetsResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUResubmit;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUResult;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUResultResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WURun;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WURunResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUSubmit;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUSubmitResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUSyntaxCheckECL;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUSyntaxCheckResponse;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WsWorkunits;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WsWorkunitsStub;
import org.hpccsystems.ws.client.platform.QuerySetFilterType;
import org.hpccsystems.ws.client.platform.Version;
import org.hpccsystems.ws.client.platform.WUActionCode;
import org.hpccsystems.ws.client.platform.Workunit;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ApplicationValueWrapper;
import org.hpccsystems.ws.client.wrappers.ArrayOfECLExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.ECLExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.EspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.EspSoapFaultWrapper;
import org.hpccsystems.ws.client.wrappers.WUFileType;
import org.hpccsystems.ws.client.wrappers.WUState;
import org.hpccsystems.ws.client.wrappers.wsworkunits.ECLResultWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.QueryFileWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.QueryResultWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.QuerySetFilterTypeWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUCreateAndUpdateWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUCreateRequestWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUCreateResponseWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUInfoRequestWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUInfoResponseWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WULogFileWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUQueryWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUUpdateRequestWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUUpdateResponseWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WorkunitWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WsWorkunitsClientStubWrapper;

public class HPCCWsWorkUnitsClient
extends BaseHPCCWsClient {
    private static final Logger log = LogManager.getLogger(HPCCWsWorkUnitsClient.class);
    public static final String WSWORKUNITSWSDLURI = "/WsWorkunits";
    public static final int defaultWaitTime = 10000;
    public static final int defaultResultLimit = 100;
    public static final int defaultMaxWaitTime = 300000;
    private WsWorkunitsClientStubWrapper stubWrapper = null;
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsWorkUnitsClient.getServiceWSDLURL(new WsWorkunitsStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    public static String getServiceURI() {
        return WSWORKUNITSWSDLURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsWorkUnitsClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsWorkUnitsClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    public static HPCCWsWorkUnitsClient get(Connection connection) {
        return new HPCCWsWorkUnitsClient(connection);
    }

    public static HPCCWsWorkUnitsClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsWorkUnitsClient(conn);
    }

    public static HPCCWsWorkUnitsClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsWorkUnitsClient(conn);
    }

    protected HPCCWsWorkUnitsClient(Connection baseConnection) {
        this.initWsWorkUnitsClientStub(baseConnection);
    }

    public void initWsWorkUnitsClientStub(Connection conn) {
        block3: {
            this.initErrMessage = "";
            try {
                HPCCWsSMCClient wssmc = HPCCWsSMCClient.get(conn);
                this.targetVersion = new Version(wssmc.getHPCCBuild());
                if (this.targetVersion == null) {
                    throw new Exception("Cannot initialize HPCCWsDFUStub without valid HPCC version object");
                }
                this.stubWrapper = new WsWorkunitsClientStubWrapper(conn, this.targetVersion);
                this.stub = this.stubWrapper.getLatestStub();
                this.stub = HPCCWsWorkUnitsClient.setStubOptions(new WsWorkunitsStub(conn.getBaseUrl() + WSWORKUNITSWSDLURI), conn);
            }
            catch (Exception e) {
                log.error("HPCCWsWorkUnitsClient: Could not stablish target HPCC bulid version, review all HPCC connection values");
                if (e.getLocalizedMessage().isEmpty()) break block3;
                this.initErrMessage = e.getLocalizedMessage();
                log.error("HPCCWsWorkUnitsClient: " + e.getLocalizedMessage());
            }
        }
    }

    public void fastWURefresh(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuery request = new org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuery();
        WUState previousState = HPCCWsWorkUnitsClient.getStateID(wu);
        request.setWuid(wu.getWuid());
        request.setCount(1);
        org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQueryResponse response = null;
        try {
            response = ((WsWorkunits)((Object)this.stub)).wUQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("WsWorkunits.fastWURefresh(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform fastWURefresh");
        }
        if (response != null) {
            ECLWorkunit[] eclWorkunit;
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not perform fastWURefresh");
            }
            if (response.getWorkunits() != null && (eclWorkunit = response.getWorkunits().getECLWorkunit()) != null && eclWorkunit.length == 1) {
                wu.update(eclWorkunit[0]);
            }
            if (previousState != HPCCWsWorkUnitsClient.getStateID(wu)) {
                this.fullWURefresh(wu);
            }
        }
    }

    protected void fullWURefresh(WorkunitWrapper wu) throws Exception {
        this.fullWURefresh(wu, true, true, true, true);
    }

    public void fullWURefresh(WorkunitWrapper wu, boolean includeGraphs, boolean includeResults, boolean includeSourceFiles, boolean includeApplicationValues) throws Exception {
        this.verifyStub();
        WUInfoRequestWrapper request = new WUInfoRequestWrapper();
        request.setWuid(wu.getWuid());
        request.setIncludeGraphs(includeGraphs);
        request.setIncludeResults(includeResults);
        request.setIncludeResultsViewNames(includeResults);
        request.setSuppressResultSchemas(!includeResults);
        request.setIncludeSourceFiles(includeSourceFiles);
        request.setIncludeApplicationValues(includeApplicationValues);
        WUInfoResponseWrapper response = this.stubWrapper.WUInfo(request);
        if (response.getWorkunit() == null) {
            for (EspExceptionWrapper e : response.getExceptions().getEspExceptions()) {
                if (!e.getCode().equals("20082") && !e.getCode().equals("20080")) continue;
                wu.setStateID(999);
                break;
            }
        } else {
            wu.update(response.getWorkunit());
        }
    }

    public boolean isWorkunitCompiled(String wuid) throws Exception, ArrayOfEspExceptionWrapper {
        WorkunitWrapper thewui = this.getWUInfo(wuid);
        if (thewui != null) {
            return this.isWorkunitCompiled(thewui);
        }
        return false;
    }

    public boolean isWorkunitCompiled(WorkunitWrapper thewui) {
        return HPCCWsWorkUnitsClient.isWorkunitState(HPCCWsWorkUnitsClient.getStateID(thewui), WUState.COMPILED);
    }

    public boolean isWorkunitFailed(WorkunitWrapper thewui) {
        return HPCCWsWorkUnitsClient.isWorkunitState(HPCCWsWorkUnitsClient.getStateID(thewui), WUState.FAILED);
    }

    public boolean isWorkunitFailed(String state) {
        return state.equalsIgnoreCase(WUState.FAILED.toString());
    }

    private static boolean isWorkunitState(WUState state1, WUState state2) {
        return state1 == state2;
    }

    public boolean isWorkunitComplete(String wuid) throws Exception, ArrayOfEspExceptionWrapper {
        WorkunitWrapper thewui = this.getWUInfo(wuid);
        if (thewui != null) {
            return HPCCWsWorkUnitsClient.isWorkunitComplete(thewui);
        }
        return false;
    }

    public static boolean isWorkunitComplete(WorkunitWrapper thewui) {
        WUActionCode origAction = WUActionCode.fromName(thewui.getActionEx());
        if (origAction == WUActionCode.WUActionUnknown) {
            origAction = WUActionCode.fromInteger(thewui.getAction());
        }
        return HPCCWsWorkUnitsClient.isWorkunitComplete(HPCCWsWorkUnitsClient.getStateID(thewui), origAction);
    }

    public static boolean isWorkunitComplete(WUState state, WUActionCode origAction) {
        if (origAction == WUActionCode.WUActionRun && HPCCWsWorkUnitsClient.isWorkunitState(state, WUState.COMPILED)) {
            return false;
        }
        return HPCCWsWorkUnitsClient.isWorkunitComplete(state);
    }

    public static boolean isWorkunitComplete(WUState state) {
        switch (state) {
            case UNKNOWN_ONSERVER: 
            case COMPLETED: 
            case FAILED: 
            case ABORTED: 
            case ARCHIVED: 
            case COMPILED: {
                return true;
            }
        }
        return false;
    }

    public static WUState getStateID(WorkunitWrapper wu) {
        if (wu != null) {
            if (wu.getStateID() != null) {
                return HPCCWsWorkUnitsClient.getStateID(wu.getStateID());
            }
            if (wu.getState() != null) {
                return Workunit.translateWUState(wu.getState());
            }
        }
        return WUState.UNKNOWN;
    }

    public static WUState getStateID(Integer id) {
        switch (id) {
            case 1: {
                return WUState.COMPILED;
            }
            case 2: {
                return WUState.RUNNING;
            }
            case 3: {
                return WUState.COMPLETED;
            }
            case 4: {
                return WUState.FAILED;
            }
            case 5: {
                return WUState.ARCHIVED;
            }
            case 6: {
                return WUState.ABORTING;
            }
            case 7: {
                return WUState.ABORTED;
            }
            case 8: {
                return WUState.BLOCKED;
            }
            case 9: {
                return WUState.SUBMITTED;
            }
            case 10: {
                return WUState.SCHEDULED;
            }
            case 11: {
                return WUState.COMPILING;
            }
            case 12: {
                return WUState.WAIT;
            }
            case 13: {
                return WUState.WAIT;
            }
            case 14: {
                return WUState.WAIT;
            }
            case 15: {
                return WUState.RUNNING;
            }
            case 16: {
                return WUState.PAUSED;
            }
            case 999: {
                return WUState.UNKNOWN_ONSERVER;
            }
        }
        return WUState.UNKNOWN;
    }

    public WUPublishWorkunitResponse publishWUFromEcl(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper {
        WUPublishWorkunitResponse publishWUResp = null;
        this.verifyStub();
        if (wu.getECL() == null || wu.getECL().length() == 0) {
            throw new Exception("Empty ECL submited");
        }
        WorkunitWrapper eclwu = this.createWUFromECL(wu);
        try {
            Thread.sleep(wu.getSleepMillis().intValue());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.submitWU(eclwu);
        this.monitorWUToCompletion(eclwu);
        publishWUResp = this.publishWU(eclwu);
        return publishWUResp;
    }

    public WUPublishWorkunitResponse publishWU(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper {
        WUPublishWorkunitResponse publishWUResp = null;
        if (wu == null) {
            throw new Exception("Invalid wuid submited");
        }
        this.verifyStub();
        WUPublishWorkunit publishWU = new WUPublishWorkunit();
        publishWU.setJobName(wu.getJobname());
        publishWU.setWuid(wu.getWuid());
        publishWU.setCluster(wu.getCluster());
        publishWU.setActivate(1);
        publishWUResp = ((WsWorkunits)((Object)this.stub)).wUPublishWorkunit(publishWU);
        ArrayOfEspException exceptions = publishWUResp.getExceptions();
        if (exceptions != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(exceptions), "Could not publish WU");
        }
        return publishWUResp;
    }

    public void publishWU(String wuid) throws Exception {
        if (wuid == null || wuid.isEmpty()) {
            throw new Exception("Invalid wuid submited");
        }
        this.verifyStub();
        WUPublishWorkunit publishWU = new WUPublishWorkunit();
        publishWU.setWuid(wuid);
        ((WsWorkunits)((Object)this.stub)).wUPublishWorkunit(publishWU);
    }

    public WorkunitWrapper getWUInfo(WUInfoRequestWrapper wuinfodetailsparams) throws Exception, ArrayOfEspExceptionWrapper {
        WorkunitWrapper workunit = null;
        this.verifyStub();
        WUInfoResponseWrapper wuInfoResponse = this.stubWrapper.WUInfo(wuinfodetailsparams);
        ArrayOfEspException exceptions = wuInfoResponse.getRawArrayOfEspExceptions1_75();
        if (exceptions == null && wuInfoResponse.getWorkunit() != null) {
            workunit = wuInfoResponse.getWorkunit();
            workunit.setOriginalEclWatchUrl(this.getEclWatchUrl());
            workunit.setResultViews(wuInfoResponse.getResultViews());
            if (wuinfodetailsparams.attemptUnarchive() && workunit.getArchived().booleanValue()) {
                this.doWorkunitAction(wuinfodetailsparams.getWuid(), ECLWUActions.Restore);
                wuInfoResponse = this.stubWrapper.WUInfo(wuinfodetailsparams);
                if (exceptions == null && wuInfoResponse.getWorkunit() != null) {
                    workunit = wuInfoResponse.getWorkunit();
                    workunit.setOriginalEclWatchUrl(this.getEclWatchUrl());
                    workunit.setResultViews(wuInfoResponse.getResultViews());
                }
            }
        } else {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(exceptions), "Could not fetch WU Info");
        }
        return workunit;
    }

    public WorkunitWrapper getWUInfo(String wuid) throws Exception, ArrayOfEspExceptionWrapper {
        return this.getWUInfo(wuid, false);
    }

    public WorkunitWrapper getWUInfo(String wuid, boolean unarchive) throws Exception, ArrayOfEspExceptionWrapper {
        WUInfoRequestWrapper wuinfodetailsparams = new WUInfoRequestWrapper();
        wuinfodetailsparams.setIncludeApplicationValues(false);
        wuinfodetailsparams.setIncludeDebugValues(false);
        wuinfodetailsparams.setIncludeExceptions(true);
        wuinfodetailsparams.setIncludeGraphs(false);
        wuinfodetailsparams.setIncludeResults(true);
        wuinfodetailsparams.setWuid(wuid);
        wuinfodetailsparams.setAttemptUnarchive(unarchive);
        return this.getWUInfo(wuinfodetailsparams);
    }

    @Deprecated
    public WorkunitWrapper getWUInfo(String wuid, boolean includeResults, boolean includeGraphs, boolean includeSourceFiles, boolean includeApplicationValues, Boolean includeDebugValues, Boolean includeExceptions, Boolean includeVariables, Boolean includeXmlSchemas, Boolean includeTimers) throws Exception, ArrayOfEspExceptionWrapper {
        WUInfoRequestWrapper params = new WUInfoRequestWrapper();
        params.setWuid(wuid);
        params.setIncludeResults(includeResults);
        params.setIncludeGraphs(includeGraphs);
        params.setIncludeSourceFiles(includeSourceFiles);
        params.setIncludeApplicationValues(includeApplicationValues);
        if (includeDebugValues != null) {
            params.setIncludeDebugValues(includeDebugValues);
        }
        if (includeExceptions != null) {
            params.setIncludeExceptions(includeExceptions);
        }
        if (includeVariables != null) {
            params.setIncludeVariables(includeVariables);
        }
        if (includeXmlSchemas != null) {
            params.setIncludeXmlSchemas(includeXmlSchemas);
        }
        if (includeTimers != null) {
            params.setIncludeTimers(includeTimers);
        }
        params.setAttemptUnarchive(false);
        return this.getWUInfo(params);
    }

    @Deprecated
    public WorkunitWrapper getWUInfo(String wuid, boolean includeResults, boolean includeGraphs, boolean includeSourceFiles, boolean includeApplicationValues, Boolean includeDebugValues, Boolean includeExceptions, Boolean includeVariables, Boolean includeXmlSchemas, Boolean includeTimers, boolean unarchive) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        WUInfoRequestWrapper request = new WUInfoRequestWrapper();
        request.setWuid(wuid);
        request.setIncludeGraphs(includeGraphs);
        request.setIncludeResults(includeResults);
        request.setIncludeResultsViewNames(includeResults);
        request.setSuppressResultSchemas(!includeResults);
        request.setIncludeSourceFiles(includeSourceFiles);
        request.setIncludeApplicationValues(includeApplicationValues);
        if (includeDebugValues != null) {
            request.setIncludeDebugValues(includeDebugValues);
        }
        if (includeExceptions != null) {
            request.setIncludeExceptions(includeExceptions);
        }
        if (includeTimers != null) {
            request.setIncludeTimers(includeTimers);
        }
        if (includeVariables != null) {
            request.setIncludeVariables(includeVariables);
        }
        if (includeXmlSchemas != null) {
            request.setIncludeXmlSchemas(includeXmlSchemas);
        }
        request.setAttemptUnarchive(unarchive);
        return this.getWUInfo(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testWUQuery() throws Exception {
        Integer oldTimeout = -1;
        this.verifyStub();
        org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuery request = new org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuery();
        request.setWuid("XXX");
        try {
            oldTimeout = this.getStubConnectionTO();
            this.setStubConnectionTO(3000);
            ((WsWorkunits)((Object)this.stub)).wUQuery(request);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (oldTimeout != null && oldTimeout != -1) {
                this.setStubConnectionTO(oldTimeout);
            }
        }
        return false;
    }

    private boolean compatibilityCheck(Version input) {
        if (this.targetVersion == null || input == null) {
            return false;
        }
        if (this.targetVersion.major > input.major) {
            return true;
        }
        if (this.targetVersion.major < input.major) {
            return false;
        }
        if (this.targetVersion.minor > input.minor) {
            return true;
        }
        if (this.targetVersion.minor < input.minor) {
            return false;
        }
        if (this.targetVersion.point > input.point) {
            return true;
        }
        return this.targetVersion.point >= input.point;
    }

    public List<WorkunitWrapper> workUnitUQuery(String wuid, String jobname, String cluster, Boolean archived, WUQueryWrapper.SortBy sortby, WUState state, Date endDate, Date startDate, Long pageStartFrom, Long pageSize, String owner, List<ApplicationValueWrapper> applicationValues) throws Exception, ArrayOfEspExceptionWrapper {
        WUQueryWrapper info = new WUQueryWrapper();
        info.setWuid(wuid);
        info.setJobname(jobname);
        info.setCluster(cluster);
        if (archived.booleanValue()) {
            info.setArchived(archived);
        }
        info.setSortBy(sortby);
        info.setState(state);
        if (endDate != null) {
            info.setEndDate(endDate);
        }
        if (startDate != null) {
            info.setStartDate(startDate);
        }
        info.setOwner(owner);
        info.setApplicationValues(applicationValues);
        info.setPageSize(pageSize == null ? 10000L : pageSize);
        info.setPageStartFrom(pageStartFrom == null ? 0L : pageStartFrom);
        return this.workUnitUQuery(info);
    }

    public List<WorkunitWrapper> workUnitUQuery(WUQueryWrapper info) throws Exception, ArrayOfEspExceptionWrapper {
        ArrayList<WorkunitWrapper> result;
        block12: {
            ECLWorkunit[] eclWorkunits;
            org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQueryResponse wUQuery;
            block13: {
                block11: {
                    this.verifyStub();
                    info.validate();
                    result = new ArrayList<WorkunitWrapper>();
                    if (this.compatibilityCheck(new Version("6.0.0"))) break block11;
                    HashSet workunit_set = new HashSet();
                    WUQueryResponse fallbackresponse = null;
                    if (info.getApplicationValues().size() > 1) {
                        for (int i = 0; i < info.getApplicationValues().size(); ++i) {
                            WUQuery internal = info.getRaw156(i);
                            fallbackresponse = this.stubWrapper.get1_56FallbackStub().wUQuery(internal);
                            if (fallbackresponse != null) {
                                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(fallbackresponse.getExceptions()), "Error in WU query");
                            }
                            HashSet<org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.ECLWorkunit> internal_wu_set = new HashSet<org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.ECLWorkunit>();
                            if (fallbackresponse.getWorkunits() == null) continue;
                            for (org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.ECLWorkunit wu : fallbackresponse.getWorkunits().getECLWorkunit()) {
                                internal_wu_set.add(wu);
                            }
                            if (workunit_set.isEmpty()) {
                                workunit_set.addAll(internal_wu_set);
                                continue;
                            }
                            workunit_set.retainAll(internal_wu_set);
                        }
                    } else {
                        fallbackresponse = this.stubWrapper.get1_56FallbackStub().wUQuery(info.getRaw156(0));
                        if (fallbackresponse != null) {
                            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(fallbackresponse.getExceptions()), "Error in WU query");
                        }
                        if (fallbackresponse.getWorkunits() != null) {
                            for (org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.ECLWorkunit wu : fallbackresponse.getWorkunits().getECLWorkunit()) {
                                workunit_set.add(wu);
                            }
                        }
                    }
                    for (org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.ECLWorkunit eclWorkunit : workunit_set) {
                        result.add(new WorkunitWrapper(eclWorkunit));
                    }
                    break block12;
                }
                wUQuery = ((WsWorkunits)((Object)this.stub)).wUQuery(info.getRaw());
                if (wUQuery.getExceptions() == null || wUQuery.getExceptions().getException().length <= 0) break block13;
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(wUQuery.getExceptions()), "Error in WU query");
                break block12;
            }
            ArrayOfECLWorkunit workunits = wUQuery.getWorkunits();
            if (workunits == null) break block12;
            for (ECLWorkunit eclWorkunit : eclWorkunits = workunits.getECLWorkunit()) {
                result.add(new WorkunitWrapper(eclWorkunit));
            }
        }
        return result;
    }

    public boolean doesWUContainErrors(String wuid) throws Exception, ArrayOfEspExceptionWrapper {
        boolean errsfound = true;
        WorkunitWrapper workunit = this.getWUInfo(wuid);
        if (workunit != null) {
            errsfound = workunit.getErrorCount() <= 0;
        }
        return errsfound;
    }

    public WorkunitWrapper createWUFromECL(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper {
        WorkunitWrapper createdWU = null;
        WUCreateAndUpdateWrapper wucreateparameters = new WUCreateAndUpdateWrapper();
        wucreateparameters.setAction(WUActionCode.WUActionCompile.ordinal());
        wucreateparameters.setQueryText(wu.getECL());
        wucreateparameters.setApplicationValues(wu.getApplicationValues());
        wucreateparameters.setDebugValues(wu.getDebugValues());
        wucreateparameters.setJobname(wu.getJobname());
        wucreateparameters.setClusterOrig(wu.getCluster());
        wucreateparameters.setResultLimit(wu.getResultLimit());
        wucreateparameters.setWuid(wu.getWuid());
        WUUpdateResponseWrapper wuUpdateResponse = this.stubWrapper.WUCreateAndUpdate(wucreateparameters);
        if (wuUpdateResponse.getExceptions() == null || wuUpdateResponse.getExceptions().getEspExceptions() == null || wuUpdateResponse.getExceptions().getEspExceptions().size() == 0) {
            createdWU = wuUpdateResponse.getWorkunitWrapper();
            createdWU.setMaxMonitorMillis(wu.getMaxMonitorMillis());
            createdWU.setCluster(wu.getCluster());
            createdWU.setJobname(wu.getJobname());
            createdWU.setSleepMillis(wu.getSleepMillis());
            createdWU.setOriginalEclWatchUrl(this.getEclWatchUrl());
        } else {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(wuUpdateResponse.getRawArrayOfEspExceptions()), "Error compiling ECL query");
        }
        return createdWU;
    }

    public WorkunitWrapper createWUFromECL(String archiveOrEcl, int resultLimit, List<ApplicationValueWrapper> appVals, String jobName, boolean compileOnly) throws Exception, ArrayOfEspExceptionWrapper {
        WorkunitWrapper wi = new WorkunitWrapper().setECL(archiveOrEcl).setJobname(jobName).setApplicationValues(appVals).setResultLimit(resultLimit == 0 ? null : Integer.valueOf(resultLimit));
        return this.createWUFromECL(wi);
    }

    public List<WorkunitWrapper> getWorkunits(String jobName, String owner, String ecl, Boolean archived, String wuid, String cluster, WUState state) throws Exception, ArrayOfEspExceptionWrapper {
        WUQueryWrapper params = new WUQueryWrapper();
        params.setJobname(jobName);
        params.setOwner(owner);
        params.setECL(ecl);
        if (archived != null) {
            params.setArchived(archived);
        }
        params.setWuid(wuid);
        params.setCluster(cluster);
        params.setState(state);
        return this.workUnitUQuery(params);
    }

    public List<WorkunitWrapper> getWorkunits(WUQueryWrapper params) throws Exception, ArrayOfEspExceptionWrapper {
        return this.workUnitUQuery(params);
    }

    public WorkunitWrapper compileWUFromECL(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper, ArrayOfECLExceptionWrapper {
        WorkunitWrapper createdWU;
        Integer sleeptime = wu.getSleepMillis();
        if (sleeptime == null) {
            sleeptime = 10000;
        }
        if ((createdWU = this.createWUFromECL(wu)) != null && createdWU.getErrorCount() == 0 && (createdWU.getExceptions() == null || createdWU.getExceptions().getECLException().size() == 0)) {
            createdWU.setCluster(wu.getCluster());
            this.submitWU(createdWU);
            this.monitorWUToCompletion(createdWU);
            WorkunitWrapper res = this.getWUInfo(createdWU.getWuid(), false, false, false, false, false, true, false, false, false);
            if (res.getExceptions() != null) {
                for (ECLExceptionWrapper ex : res.getExceptions().getECLException()) {
                    if (!"error".equalsIgnoreCase(ex.getSeverity())) continue;
                    this.handleECLExceptions(new ArrayOfECLExceptionWrapper(res.getRawExceptions().getECLException()), "Workunit Compile Failed");
                }
            }
        }
        return createdWU;
    }

    public void submitWU(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper {
        this.submitWU(wu.getWuid(), wu.getCluster());
    }

    public void submitWU(String wuid, String cluster) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        WUSubmit request = new WUSubmit();
        request.setWuid(wuid);
        request.setCluster(cluster);
        WUSubmitResponse response = null;
        try {
            response = ((WsWorkunits)((Object)this.stub)).wUSubmit(request);
        }
        catch (RemoteException e) {
            throw new Exception("WsWorkunits.submitWU(" + wuid + "," + cluster + ") encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform submitWU");
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Error compiling ECL query");
        }
    }

    public WURunResponse createAndRunWUFromECL(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper, ArrayOfECLExceptionWrapper {
        WURunResponse wuRunResponse = null;
        this.verifyStub();
        WorkunitWrapper compiledWU = null;
        compiledWU = this.compileWUFromECL(wu);
        if (compiledWU != null) {
            WURun request = new WURun();
            request.setWuid(compiledWU.getWuid());
            request.setVariables(wu.getRawNamedValues());
            request.setCluster(wu.getCluster());
            try {
                wuRunResponse = ((WsWorkunits)((Object)this.stub)).wURun(request);
            }
            catch (RemoteException e) {
                throw new Exception("WsWorkunits.createAndRunWUFromECL(...) encountered RemoteException.", e);
            }
            catch (EspSoapFault e) {
                this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Error running WUID: " + compiledWU.getWuid());
            }
            if (wuRunResponse.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(wuRunResponse.getExceptions()), "Error running WUID: " + compiledWU.getWuid());
            }
            if (this.isWorkunitFailed(wuRunResponse.getState())) {
                String error = wuRunResponse.getResults();
                throw new Exception("Error running WUID: " + compiledWU.getWuid() + ":\n" + error);
            }
        }
        return wuRunResponse;
    }

    public String createAndRunWUFromECLAndGetResults(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper, ArrayOfECLExceptionWrapper {
        WURunResponse createAndRunWUFromECL = this.createAndRunWUFromECL(wu);
        return createAndRunWUFromECL.getResults();
    }

    public String createAndRunWUFromECLAndGetWUID(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper, ArrayOfECLExceptionWrapper {
        WURunResponse createAndRunWUFromECL = this.createAndRunWUFromECL(wu);
        return createAndRunWUFromECL.getWuid();
    }

    public String fetchResultsFromLogicalName(String logicalName, int sequence, String cluster, boolean suppressXMLShema, long resultOffset, int resultCount) throws Exception, ArrayOfEspExceptionWrapper {
        WUResultResponse wuResultResponse = this.fetchRawResults(logicalName, false, sequence, cluster, suppressXMLShema, resultOffset, resultCount);
        ArrayOfEspException exceptions = wuResultResponse.getExceptions();
        if (exceptions != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(exceptions), "Could not fetch results");
        }
        return wuResultResponse.getResult();
    }

    public String fetchResults(String wuid, int sequence, String cluster, boolean suppressXMLShema, long resultOffset, int resultCount) throws Exception, ArrayOfEspExceptionWrapper {
        WUResultResponse wuResultResponse = this.fetchRawResults(wuid, true, sequence, cluster, suppressXMLShema, resultOffset, resultCount);
        ArrayOfEspException exceptions = wuResultResponse.getExceptions();
        if (exceptions != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(exceptions), "Could not fetch results");
        }
        return wuResultResponse.getResult();
    }

    public WUResultResponse fetchRawResults(String wuidorlogicalname, boolean useWuid, int sequence, String cluster, boolean suppressXMLShema, long resultOffset, int resultCount) throws Exception {
        this.verifyStub();
        if (wuidorlogicalname == null || wuidorlogicalname.length() == 0) {
            throw new Exception("Please provide either WUID or LogicalName");
        }
        WUResult parameters = new WUResult();
        if (useWuid) {
            parameters.setWuid(wuidorlogicalname);
        } else {
            parameters.setLogicalName(wuidorlogicalname);
        }
        parameters.setSequence(sequence);
        parameters.setStart(resultOffset);
        parameters.setCount(resultCount);
        if (cluster != null) {
            parameters.setCluster(cluster);
        }
        parameters.setSuppressXmlSchema(suppressXMLShema);
        return this.fetchRawResults(parameters);
    }

    public static boolean looksLikeAWuid(String wuid) {
        if (wuid == null || wuid.length() == 0) {
            return false;
        }
        if (wuid.charAt(0) != 'W' && wuid.charAt(0) != 'w') {
            return false;
        }
        if (!(Character.isDigit(wuid.charAt(1)) && Character.isDigit(wuid.charAt(2)) && Character.isDigit(wuid.charAt(3)) && Character.isDigit(wuid.charAt(4)))) {
            return false;
        }
        if (!(Character.isDigit(wuid.charAt(5)) && Character.isDigit(wuid.charAt(6)) && Character.isDigit(wuid.charAt(7)) && Character.isDigit(wuid.charAt(8)))) {
            return false;
        }
        return wuid.charAt(9) == '-';
    }

    public WUResultResponse fetchRawResults(WUResult parameters) throws Exception {
        this.verifyStub();
        return ((WsWorkunits)((Object)this.stub)).wUResult(parameters);
    }

    private void refreshWU(boolean full, WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper {
        if (full || HPCCWsWorkUnitsClient.isWorkunitComplete(wu)) {
            this.fullWURefresh(wu);
        } else {
            this.fastWURefresh(wu);
        }
    }

    private void monitorWUToCompletion(WorkunitWrapper wu) throws Exception, ArrayOfEspExceptionWrapper {
        int timerTickCount = 0;
        String id = wu.getWuid();
        if (wu.getJobname() != null) {
            id = id + "(" + wu.getJobname() + ")";
        }
        log.trace("Monitoring WU " + id + " to completion.");
        while (!HPCCWsWorkUnitsClient.isWorkunitComplete(wu)) {
            try {
                log.trace("Monitoring WU " + id + " to completion ( " + timerTickCount + ") ...");
                Thread.sleep(wu.getSleepMillis().intValue());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (++timerTickCount * wu.getSleepMillis() > wu.getMaxMonitorMillis()) {
                throw new Exception("Timed out waiting for WUID " + wu.getWuid() + " to complete.");
            }
            try {
                if (timerTickCount == 1) {
                    this.refreshWU(true, wu);
                    continue;
                }
                if (timerTickCount < 5 && timerTickCount % 1 == 0) {
                    this.refreshWU(false, wu);
                    continue;
                }
                if (timerTickCount < 30 && timerTickCount % 5 == 0) {
                    this.refreshWU(false, wu);
                    continue;
                }
                if (timerTickCount < 60 && timerTickCount % 10 == 0) {
                    this.refreshWU(false, wu);
                    continue;
                }
                if (timerTickCount < 120 && timerTickCount % 30 == 0) {
                    this.refreshWU(true, wu);
                    continue;
                }
                if (timerTickCount % 60 != 0) continue;
                this.refreshWU(true, wu);
            }
            catch (Exception e) {
                throw new Exception("Error attempting to refresh WU " + wu.getWuid() + "\n" + e.getLocalizedMessage(), e);
            }
        }
    }

    public ArrayOfECLExceptionWrapper syntaxCheckECL(String ecl, String cluster, Integer timeout) throws Exception {
        this.verifyStub();
        WUSyntaxCheckECL checkParams = new WUSyntaxCheckECL();
        checkParams.setECL(ecl);
        checkParams.setCluster(cluster);
        if (timeout != null) {
            checkParams.setTimeToWait(timeout);
        }
        WUSyntaxCheckResponse resp = ((WsWorkunits)((Object)this.stub)).wUSyntaxCheckECL(checkParams);
        ArrayOfECLExceptionWrapper result = null;
        if (resp.getErrors() != null) {
            result = new ArrayOfECLExceptionWrapper(resp.getErrors().getECLException());
        }
        return result;
    }

    public WUQuerySetDetailsResponse getQueriesDetail(String querySetName, String clusterName, String filter) throws Exception {
        this.verifyStub();
        WUQuerysetDetails wuQuerysetDetails = new WUQuerysetDetails();
        wuQuerysetDetails.setQuerySetName(querySetName);
        wuQuerysetDetails.setClusterName(clusterName);
        wuQuerysetDetails.setFilter(filter);
        return ((WsWorkunits)((Object)this.stub)).wUQuerysetDetails(wuQuerysetDetails);
    }

    public void abortWU(String wuid) throws Exception {
        this.verifyStub();
        WUAbort request = new WUAbort();
        org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.EspStringArray arrayofwuids = new org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.EspStringArray();
        arrayofwuids.addItem(wuid);
        request.setWuids(arrayofwuids);
        request.setBlockTillFinishTimer(1);
        ((WsWorkunits)((Object)this.stub)).wUAbort(request);
    }

    public void deleteWU(String wuid) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        WUDelete request = new WUDelete();
        org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.EspStringArray wuids = new org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.EspStringArray();
        wuids.addItem(wuid);
        request.setWuids(wuids);
        request.setBlockTillFinishTimer(1);
        WUDeleteResponse resp = ((WsWorkunits)((Object)this.stub)).wUDelete(request);
        this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could not delete " + wuid + ":");
    }

    public void resubmitWU(String wuid, boolean restart, boolean clone) throws Exception {
        this.verifyStub();
        WUResubmit request = new WUResubmit();
        request.setResetWorkflow(restart);
        request.setCloneWorkunit(clone);
        org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.EspStringArray wuids = new org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.EspStringArray();
        wuids.addItem(wuid);
        request.setWuids(wuids);
        ((WsWorkunits)((Object)this.stub)).wUResubmit(request);
    }

    public QuerySet[] getQuerySets() throws Exception {
        this.verifyStub();
        QuerySet[] queryset = null;
        WUQuerysets request = new WUQuerysets();
        WUQuerysetsResponse response = ((WsWorkunits)((Object)this.stub)).wUQuerysets(request);
        if (response != null && response.getQuerysets() != null) {
            queryset = response.getQuerysets().getQuerySet();
        }
        return queryset;
    }

    public WUResultResponse getWorkunitResult(WUResult wur) throws Exception, ArrayOfEspExceptionWrapper {
        return this.getWorkunitResult(wur, false);
    }

    public String getWorkunitResult(String wuid, String resultname) throws Exception, ArrayOfEspExceptionWrapper {
        WUResult params = new WUResult();
        params.setWuid(wuid);
        params.setResultName(resultname);
        params.setSuppressXmlSchema(true);
        WUResultResponse resp = this.getWorkunitResult(params, true);
        if (resp != null) {
            if (resp.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Unable to retrieve result " + resultname + " from wuid " + wuid + ":");
            }
            return resp.getResult();
        }
        return null;
    }

    public WUResultResponse getWorkunitResult(WUResult wur, boolean unarchive) throws Exception, ArrayOfEspExceptionWrapper {
        if (unarchive) {
            this.getWUInfo(wur.getWuid(), unarchive);
        }
        WUResultResponse resp = ((WsWorkunitsStub)this.stub).wUResult(wur);
        return resp;
    }

    public boolean doWorkunitAction(String wuid, ECLWUActions action) throws RemoteException, Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUAction request = new org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUAction();
        request.setWUActionType(action);
        org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.EspStringArray wuids = new org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.EspStringArray();
        wuids.addItem(wuid);
        request.setWuids(wuids);
        WUActionResponse response = null;
        try {
            response = ((WsWorkunitsStub)this.stub).wUAction(request);
        }
        catch (RemoteException e) {
            throw new Exception("WsWorkunitsClient.doWorkunitAction(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform doWorkunitAction(" + wuid + ", " + action.toString() + ")");
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not perform doWorkunitAction(" + wuid + ", " + action.toString() + ")");
        }
        if (response == null || response.getActionResults() == null || response.getActionResults().getWUActionResult().length == 0 || response.getActionResults().getWUActionResult()[0].getResult() == null || !response.getActionResults().getWUActionResult()[0].getResult().equals("Success")) {
            WUAction fwa = new WUAction();
            fwa.setActionType(action.getValue());
            EspStringArray espstringarray = new EspStringArray();
            wuids.addItem(wuid);
            fwa.setWuids(espstringarray);
            org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.WUActionResponse fwar = this.stubWrapper.get1_56FallbackStub().wUAction(fwa);
            if (fwar == null || fwar.getActionResults() == null || fwar.getActionResults().getWUActionResult() == null || fwar.getActionResults().getWUActionResult().length == 0 || fwar.getActionResults().getWUActionResult()[0].getResult() == null || !fwar.getActionResults().getWUActionResult()[0].getResult().equals("Success")) {
                String failreason = "unknown action result";
                if (fwar != null && fwar.getActionResults() != null && fwar.getActionResults().getWUActionResult()[0].getResult() != null) {
                    failreason = fwar.getActionResults().getWUActionResult()[0].getResult();
                }
                throw new Exception("Unable to perform " + action.getValue() + " on " + wuid + " :: " + failreason);
            }
        }
        return true;
    }

    private String getEclWatchUrl() throws Exception {
        String url = "";
        if (this.stub != null) {
            url = this.stub._getServiceClient().getOptions().getTo().getAddress().toLowerCase().replace("wsworkunits", "");
        }
        return url;
    }

    public WorkunitWrapper createWorkunit() throws Exception {
        WUCreateRequestWrapper params = new WUCreateRequestWrapper();
        WUCreateResponseWrapper resp = this.stubWrapper.WUCreate(params);
        if (resp.getExceptions() != null && resp.getExceptions().getEspExceptions() != null && resp.getExceptions().getEspExceptions().size() > 0) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could not create workunit");
        }
        return resp.getWorkunitWrapper();
    }

    public WorkunitWrapper protectWorkunit(String wuid) throws Exception {
        WUUpdateRequestWrapper params = new WUUpdateRequestWrapper();
        params.set_protected(true);
        params.setWuid(wuid);
        WUUpdateResponseWrapper resp = this.stubWrapper.WUUpdate(params);
        if (resp.getRawArrayOfEspExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getRawArrayOfEspExceptions()), "Could not protect workunit " + wuid);
        }
        return resp.getWorkunitWrapper();
    }

    public WULogFileWrapper getWorkunitFile(String wuid, String filename, WUFileType filetype, String description, String ipaddr, boolean entirefile) throws Exception {
        WULogFileResponse logFileResponse;
        WUFile file = new WUFile();
        file.setWuid(wuid);
        file.setName(filename);
        file.setType(filetype.toString());
        file.setDescription(description);
        file.setIPAddress(ipaddr);
        if (entirefile) {
            file.setOption(1);
        }
        if ((logFileResponse = ((WsWorkunitsStub)this.stub).wUFile(file)).getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(logFileResponse.getExceptions()), "Could not retrieve file " + filename + " for wuid " + wuid);
        }
        return new WULogFileWrapper(logFileResponse);
    }

    public WorkunitWrapper runWorkunit(String wuid, HashMap<String, String> namedvalues, HashMap<String, String> appvalues, Integer timeout, Boolean cloneWorkunit, String appsource) throws Exception {
        WURunResponse resp;
        ADBBean val;
        WURun params = new WURun();
        params.setWuid(wuid);
        if (cloneWorkunit != null) {
            params.setCloneWorkunit(cloneWorkunit);
        }
        if (timeout != null) {
            params.setWait(timeout);
        }
        if (appvalues != null) {
            ArrayOfApplicationValue appvaluesarray = new ArrayOfApplicationValue();
            for (Map.Entry<String, String> item : appvalues.entrySet()) {
                val = new ApplicationValue();
                ((ApplicationValue)val).setName(item.getKey());
                ((ApplicationValue)val).setValue(item.getValue());
                ((ApplicationValue)val).setApplication(appsource);
                appvaluesarray.addApplicationValue((ApplicationValue)val);
            }
            params.setApplicationValues(appvaluesarray);
        }
        if (namedvalues != null) {
            ArrayOfNamedValue nvarray = new ArrayOfNamedValue();
            for (Map.Entry<String, String> item : namedvalues.entrySet()) {
                val = new NamedValue();
                ((NamedValue)val).setName(item.getKey());
                ((NamedValue)val).setValue(item.getValue());
                nvarray.addNamedValue((NamedValue)val);
            }
            params.setVariables(nvarray);
        }
        if ((resp = ((WsWorkunitsStub)this.stub).wURun(params)).getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could not run workunit " + wuid);
        }
        WorkunitWrapper wi = new WorkunitWrapper();
        wi.setState(resp.getState());
        wi.setWuid(resp.getWuid());
        if (resp.getResults() != null && !resp.getResults().isEmpty()) {
            ECLResultWrapper msg = new ECLResultWrapper();
            msg.setValue(resp.getResults());
            wi.setResults(Arrays.asList(msg));
        }
        return wi;
    }

    public List<QueryResultWrapper> searchQueries(QuerySetFilterType filtertype, String filtervalue, String querySetName, String clustername) throws Exception {
        WUQuerysetDetails params = new WUQuerysetDetails();
        params.setClusterName(clustername);
        params.setFilter(filtervalue);
        if (filtertype != null) {
            params.setFilterType(QuerySetFilterTypeWrapper.get1_75FilterType(filtertype));
        }
        params.setQuerySetName(querySetName);
        WUQuerySetDetailsResponse resp = ((WsWorkunitsStub)this.stub).wUQuerysetDetails(params);
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could not search queries:");
        }
        QuerySetQuery[] queries = resp.getQuerysetQueries().getQuerySetQuery();
        ArrayList<QueryResultWrapper> result = new ArrayList<QueryResultWrapper>();
        if (queries != null) {
            for (QuerySetQuery item : queries) {
                result.add(new QueryResultWrapper(item));
            }
        }
        return result;
    }

    public List<QueryResultWrapper> listQueries(String queryid, String queryname, String clustername, String querysetname, Integer pageSize, Integer pageStartFrom, Boolean activated, String filename, Boolean descending) throws Exception {
        WUListQueries params = new WUListQueries();
        if (pageSize != null) {
            params.setPageSize(new NonNegativeInteger(String.valueOf(pageSize)));
        }
        if (pageStartFrom != null) {
            params.setPageStartFrom(new NonNegativeInteger(String.valueOf(pageStartFrom)));
        }
        if (descending != null) {
            params.setDescending(descending);
        }
        params.setClusterName(clustername);
        params.setQuerySetName(querysetname);
        params.setQueryName(queryname);
        params.setQueryID(queryid);
        if (activated != null) {
            params.setActivated(activated);
        }
        params.setFileName(filename);
        WUListQueriesResponse response = ((WsWorkunitsStub)this.stub).wUListQueries(params);
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not fetch queries: ");
        }
        QuerySetQuery[] queries = response.getQuerysetQueries().getQuerySetQuery();
        ArrayList<QueryResultWrapper> result = new ArrayList<QueryResultWrapper>();
        if (queries != null) {
            for (QuerySetQuery item : queries) {
                result.add(new QueryResultWrapper(item));
            }
        }
        return result;
    }

    public List<QueryFileWrapper> getQueryFiles(String queryname, String cluster) throws Exception {
        FileUsedByQuery[] files;
        WUQueryFiles request = new WUQueryFiles();
        request.setTarget(cluster);
        request.setQueryId(queryname);
        WUQueryFilesResponse response = ((WsWorkunitsStub)this.stub).wUQueryFiles(request);
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not get files for query " + queryname + ":");
        }
        ArrayList<QueryFileWrapper> result = new ArrayList<QueryFileWrapper>();
        if (response.getFiles() != null && (files = response.getFiles().getFile()) != null) {
            for (int i = 0; i < files.length; ++i) {
                result.add(new QueryFileWrapper(files[i]));
            }
        }
        return result;
    }

    public QueryResultWrapper activateQuery(String queryId, String cluster) throws Exception {
        WUQuerysetQueryAction queryAction = new WUQuerysetQueryAction();
        queryAction.setAction(QuerySetQueryActionTypes.Activate);
        QuerySetQueryActionItem item = new QuerySetQueryActionItem();
        item.setQueryId(queryId);
        QuerySetQueryActionItem[] items = new QuerySetQueryActionItem[]{item};
        queryAction.setQuerySetName(cluster);
        Queries_type0 queries = new Queries_type0();
        queries.setQuery(items);
        queryAction.setQueries(queries);
        WUQuerySetQueryActionResponse resp = ((WsWorkunitsStub)this.stub).wUQuerysetQueryAction(queryAction);
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could not activate query " + queryId);
        }
        if (resp.getResults() != null && resp.getResults().getResult().length > 0) {
            QueryResultWrapper wrapped = new QueryResultWrapper(resp.getResults().getResult()[0]);
            if (QuerySetQueryActionTypes.Activate.equals(resp.getAction())) {
                wrapped.setActivated(true);
            } else {
                wrapped.setActivated(false);
            }
            return wrapped;
        }
        return null;
    }

    public List<QueryResultWrapper> deleteQueries(Set<String> querynames, String cluster) throws Exception {
        this.verifyStub();
        WUQuerysetQueryAction params = new WUQuerysetQueryAction();
        Queries_type0 queriesarray = new Queries_type0();
        for (String queryname : querynames) {
            QuerySetQueryActionItem item = new QuerySetQueryActionItem();
            item.setQueryId(queryname);
            queriesarray.addQuery(item);
        }
        params.setQueries(queriesarray);
        params.setQuerySetName(cluster);
        params.setAction(QuerySetQueryActionTypes.Delete);
        WUQuerySetQueryActionResponse response = ((WsWorkunitsStub)this.stub).wUQuerysetQueryAction(params);
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not delete queries: ");
        }
        ArrayList<QueryResultWrapper> results = new ArrayList<QueryResultWrapper>();
        if (response.getResults() != null && response.getResults() != null) {
            QuerySetQueryActionResult[] result = response.getResults().getResult();
            for (int j = 0; j < result.length; ++j) {
                QuerySetQueryActionResult res = result[j];
                results.add(new QueryResultWrapper(res));
            }
        }
        return results;
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        Ping request = new Ping();
        try {
            ((WsWorkunitsStub)this.stub).ping(request);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new WsWorkunitsStub();
    }
}

