/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.util.HashMap;
import java.util.Map;
import org.hpccsystems.ws.client.HPCCWsDFUClient;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFULogicalFile;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ECLSourceFile;
import org.hpccsystems.ws.client.platform.FileSprayWorkunit;
import org.hpccsystems.ws.client.platform.Platform;
import org.hpccsystems.ws.client.platform.Workunit;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileDetailWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUInfoWrapper;

public class LogicalFile
extends DataSingleton {
    private static Map<Integer, LogicalFile> LogicalFiles = new HashMap<Integer, LogicalFile>();
    private Platform platform;
    private DFULogicalFile dfulogicalfile;
    private DFUFileDetailWrapper dfufiledetail;
    private ECLSourceFile eclsourcefile;

    public static synchronized LogicalFile get(Platform platform, String name) {
        LogicalFile logicalFile = new LogicalFile(platform, name);
        if (LogicalFiles.containsKey(logicalFile.hashCode())) {
            return LogicalFiles.get(logicalFile.hashCode());
        }
        LogicalFiles.put(logicalFile.hashCode(), logicalFile);
        return logicalFile;
    }

    private LogicalFile(Platform platform, String name) {
        this.platform = platform;
        this.dfulogicalfile = new DFULogicalFile();
        this.dfulogicalfile.setName(name);
        this.dfufiledetail = new DFUFileDetailWrapper();
        this.dfufiledetail.setName(name);
        this.eclsourcefile = new ECLSourceFile();
        this.eclsourcefile.setName(name);
    }

    public String getName() {
        return this.dfulogicalfile.getName();
    }

    public Workunit getWorkunit() {
        if (this.dfufiledetail.getWuid() == null) {
            this.fullRefresh();
        }
        if (this.dfufiledetail.getWuid() == null || !this.dfufiledetail.getWuid().startsWith("W")) {
            return null;
        }
        return this.platform.getWorkunit(this.dfufiledetail.getWuid());
    }

    public FileSprayWorkunit getFileSprayWorkunit() {
        if (this.dfufiledetail.getWuid() == null) {
            this.fullRefresh();
        }
        if (this.dfufiledetail.getWuid() == null || !this.dfufiledetail.getWuid().startsWith("D")) {
            return null;
        }
        return this.platform.getFileSprayWorkunit(this.dfufiledetail.getWuid());
    }

    public String getDir() {
        if (this.dfufiledetail.getDir() == null) {
            this.fullRefresh();
        }
        return this.dfufiledetail.getDir();
    }

    @Override
    protected boolean isComplete() {
        return true;
    }

    @Override
    protected void fastRefresh() {
        this.fullRefresh();
    }

    @Override
    protected void fullRefresh() {
        try {
            HPCCWsDFUClient wsDfuClient = this.platform.getWsClient().getWsDFUClient();
            DFUInfoWrapper fileInfo = wsDfuClient.getFileInfo(this.dfulogicalfile.getName(), null);
            this.update(fileInfo.getFileDetail());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.notifyObservers((Object)Notification.LOGICALFILE);
    }

    public void update(DFULogicalFile lf) {
        if (this.dfulogicalfile.getName().equals(lf.getName())) {
            this.dfulogicalfile = lf;
        }
    }

    void update(DFUFileDetailWrapper fd) {
        if (fd != null && this.dfufiledetail.getName().equals(fd.getName())) {
            this.dfufiledetail = fd;
        }
    }

    public void Update(ECLSourceFile sf) {
        if (this.eclsourcefile.getName().equals(sf.getName())) {
            this.eclsourcefile = sf;
        }
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof LogicalFile)) {
            return false;
        }
        LogicalFile that = (LogicalFile)aThat;
        return EqualsUtil.areEqual(this.platform, that.platform) && EqualsUtil.areEqual(this.dfulogicalfile.getName(), that.dfulogicalfile.getName());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.platform);
        result = HashCodeUtil.hash(result, this.dfulogicalfile.getName());
        return result;
    }

    public static enum Notification {
        LOGICALFILE;

    }
}

