/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform.test;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import org.hpccsystems.commons.annotations.RemoteTests;
import org.hpccsystems.ws.client.HPCCWsClient;
import org.hpccsystems.ws.client.platform.Platform;
import org.hpccsystems.ws.client.utils.Connection;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={RemoteTests.class})
public abstract class BaseRemoteTest {
    protected static Platform platform;
    protected static HPCCWsClient wsclient;
    protected static final String connString;
    protected static final String thorcluster;
    protected static final String defaultUserName = "JunitUser";
    protected static Connection connection;
    protected static final String hpccUser;
    protected static final String hpccPass;
    protected static final String connTO;
    protected static final String sockTO;
    public static final String DEFAULTHPCCFILENAME = "benchmark::all_types::200kb";
    public static final String DEFAULTHPCCSUPERFILENAME = "benchmark::all_types::superfile";

    static {
        connString = System.getProperty("hpccconn", "http://localhost:8010");
        thorcluster = System.getProperty("thorcluster", "mythor");
        connection = null;
        hpccUser = System.getProperty("hpccuser", defaultUserName);
        hpccPass = System.getProperty("hpccpass", "");
        connTO = System.getProperty("connecttimeoutmillis");
        sockTO = System.getProperty("sockettimeoutmillis");
        try {
            InetAddress ip = InetAddress.getLocalHost();
            String hostname = ip.getHostName();
            System.out.println("RemoteTest executing on: " + hostname + "(" + ip + ")");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (System.getProperty("hpccconn") == null) {
            System.out.println("RemoteTest: No 'hpccconn' provided, defaulting to http://localhost:8010");
        } else {
            System.out.println("RemoteTest: 'hpccconn' set to: '" + connString + "'");
        }
        if (System.getProperty("hpccuser") == null) {
            System.out.println("RemoteTest: No 'hpccuser' provided, defaulting to 'JunitUser'");
        } else {
            System.out.println("RemoteTest: 'hpccuser' set to: '" + hpccUser + "'");
        }
        if (System.getProperty("hpccpass") == null) {
            System.out.println("RemoteTest: No 'hpccpass' provided.");
        }
        if (System.getProperty("thorcluster") == null) {
            System.out.println("RemoteTest: No 'thorcluster' provided, using 'mythor'");
        } else {
            System.out.println("RemoteTest: 'thorcluster' set to: '" + thorcluster + "'");
        }
        if (platform == null) {
            try {
                connection = new Connection(connString);
            }
            catch (MalformedURLException e) {
                Assert.fail("Could not adquire connection object based on: '" + connString + "' - " + e.getLocalizedMessage());
            }
            Assert.assertNotNull("Could not adquire connection object", connection);
            connection.setCredentials(hpccUser, hpccPass);
            if (connTO != null) {
                connection.setConnectTimeoutMilli(Integer.valueOf(connTO));
            }
            if (sockTO != null) {
                connection.setSocketTimeoutMilli(Integer.valueOf(sockTO));
            }
            platform = Platform.get(connection);
            Assert.assertNotNull("Could not adquire platform object", platform);
        }
        try {
            wsclient = platform.checkOutHPCCWsClient();
        }
        catch (Exception e) {
            Assert.fail("Could not adquire wsclient object: " + e.getMessage());
        }
        Assert.assertNotNull("Could not adquire wsclient object", wsclient);
    }
}

