/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers.wsworkunits;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_56.WUQuery;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ApplicationValue;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ArrayOfApplicationValue;
import org.hpccsystems.ws.client.utils.Utils;
import org.hpccsystems.ws.client.wrappers.ApplicationValueWrapper;
import org.hpccsystems.ws.client.wrappers.WUState;

public class WUQueryWrapper {
    private String cluster;
    private boolean descending = false;
    private Boolean archived;
    private String ECL;
    private Date endDate;
    private String jobname;
    private String logicalFile;
    private LogicalFileSearchType logicalFileSearchType = LogicalFileSearchType.Input;
    private String owner;
    private Long pageSize;
    private Long pageStartFrom;
    private SortBy sortby;
    private Date startDate;
    private WUState state;
    private String wuid;
    private static String ARCHIVED_STR = "archived workunits";
    private static String NONARCHIVED_STR = "non-archived workunits";
    private static String CREATED_LF_STR = "created";
    private List<ApplicationValueWrapper> applicationValues = new ArrayList<ApplicationValueWrapper>();

    public WUQueryWrapper() {
    }

    public WUQueryWrapper(org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuery raw) throws Exception {
        if (raw.getApplicationValues() != null) {
            ApplicationValue[] applicationValuearray = raw.getApplicationValues().getApplicationValue();
            for (int i = 0; i < applicationValuearray.length; ++i) {
                this.applicationValues.add(new ApplicationValueWrapper(applicationValuearray[i]));
            }
        }
        this.cluster = raw.getCluster();
        this.descending = raw.getDescending();
        this.ECL = raw.getECL();
        try {
            this.endDate = Utils.UTCStringToDate(raw.getEndDate());
        }
        catch (Exception e) {
            throw new Exception("Invalid end date value " + raw.getEndDate());
        }
        this.jobname = raw.getJobname();
        this.logicalFile = raw.getLogicalFile();
        if (CREATED_LF_STR.equalsIgnoreCase(raw.getLogicalFileSearchType())) {
            this.logicalFileSearchType = LogicalFileSearchType.Output;
        }
        this.owner = raw.getOwner();
        this.pageSize = raw.getPageSize();
        this.pageStartFrom = raw.getPageStartFrom();
        this.sortby = SortBy.valueOf(raw.getSortby());
        try {
            this.startDate = Utils.UTCStringToDate(raw.getStartDate());
        }
        catch (Exception e) {
            throw new Exception("Invalid start date value " + raw.getStartDate());
        }
        this.state = WUState.valueOf(raw.getState());
        if (raw.getType() != null) {
            if (ARCHIVED_STR.equals(raw.getType())) {
                this.archived = true;
            } else if (NONARCHIVED_STR.equals(raw.getType())) {
                this.archived = false;
            }
        }
        this.wuid = raw.getWuid();
    }

    public String getCluster() {
        return this.cluster;
    }

    public WUQueryWrapper setCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public boolean getDescending() {
        return this.descending;
    }

    public WUQueryWrapper setDescending(boolean descending) {
        this.descending = descending;
        return this;
    }

    public String getECL() {
        return this.ECL;
    }

    public WUQueryWrapper setECL(String eCL) {
        this.ECL = eCL;
        return this;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getJobname() {
        return this.jobname;
    }

    public WUQueryWrapper setJobname(String jobname) {
        this.jobname = jobname;
        return this;
    }

    public String getLogicalFile() {
        return this.logicalFile;
    }

    public WUQueryWrapper setLogicalFile(String logicalFile) {
        if (logicalFile != null && logicalFile.startsWith("~")) {
            logicalFile = logicalFile.substring(1);
        }
        this.logicalFile = logicalFile;
        return this;
    }

    public LogicalFileSearchType getLogicalFileSearchType() {
        return this.logicalFileSearchType;
    }

    public WUQueryWrapper setOutputLogicalFilesOnly(LogicalFileSearchType lf) {
        this.logicalFileSearchType = lf;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public WUQueryWrapper setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public WUQueryWrapper setPageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Long getPageStartFrom() {
        return this.pageStartFrom;
    }

    public WUQueryWrapper setPageStartFrom(Long pageStartFrom) {
        this.pageStartFrom = pageStartFrom;
        return this;
    }

    public SortBy getSortby() {
        return this.sortby;
    }

    public WUState getState() {
        return this.state;
    }

    public String getWuid() {
        return this.wuid;
    }

    public WUQueryWrapper setWuid(String wuid) {
        this.wuid = wuid;
        return this;
    }

    public List<ApplicationValueWrapper> getApplicationValues() {
        return this.applicationValues;
    }

    public WUQueryWrapper setApplicationValues(List<ApplicationValueWrapper> applicationValues) {
        this.applicationValues = applicationValues;
        return this;
    }

    public WUQueryWrapper setSortBy(SortBy sort) {
        this.sortby = sort;
        return this;
    }

    public WUQueryWrapper setState(WUState stateenum) {
        this.state = stateenum;
        return this;
    }

    public WUQueryWrapper setStartDate(Date date) {
        this.startDate = date;
        return this;
    }

    public WUQueryWrapper setEndDate(Date date) {
        this.endDate = date;
        return this;
    }

    public WUQueryWrapper setArchived(Boolean b) {
        this.archived = b;
        return this;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void validate() throws Exception {
        if (this.applicationValues != null) {
            for (ApplicationValueWrapper v : this.applicationValues) {
                if (v.getApplication() == null || v.getApplication().isEmpty() || v.getName() != null && !v.getName().isEmpty() || v.getValue() != null && !v.getValue().isEmpty()) continue;
                throw new Exception("Application set but no name/value given");
            }
        }
    }

    public org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuery getRaw() {
        return this.getRaw1_75();
    }

    public org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuery getRaw1_75() {
        org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuery raw = new org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.WUQuery();
        if (this.applicationValues.size() > 0) {
            ApplicationValue[] appvalues = new ApplicationValue[this.applicationValues.size()];
            ArrayOfApplicationValue arrayofappvalues = new ArrayOfApplicationValue();
            for (int i = 0; i < this.applicationValues.size(); ++i) {
                ApplicationValueWrapper wrapped = this.applicationValues.get(i);
                ApplicationValue item = new ApplicationValue();
                item.setApplication(wrapped.getApplication());
                item.setName(wrapped.getName());
                item.setValue(wrapped.getValue());
                appvalues[i] = item;
            }
            arrayofappvalues.setApplicationValue(appvalues);
            raw.setApplicationValues(arrayofappvalues);
        }
        raw.setCluster(this.cluster);
        raw.setDescending(this.descending);
        raw.setECL(this.ECL);
        raw.setEndDate(Utils.dateToUTCString(this.endDate));
        raw.setJobname(this.jobname);
        raw.setLogicalFile(this.logicalFile);
        if (this.logicalFile != null && this.logicalFileSearchType != null && LogicalFileSearchType.Output.equals((Object)this.logicalFileSearchType)) {
            raw.setLogicalFileSearchType(CREATED_LF_STR);
        }
        raw.setOwner(this.owner);
        if (this.pageSize != null) {
            raw.setPageSize(this.pageSize);
        }
        if (this.pageStartFrom != null) {
            raw.setPageStartFrom(this.pageStartFrom);
        }
        if (this.sortby != null) {
            raw.setSortby(this.sortby.toString());
        }
        raw.setStartDate(Utils.dateToUTCString(this.startDate));
        if (this.state != null) {
            raw.setState(this.state.toString());
        }
        if (this.archived != null) {
            if (!this.archived.booleanValue()) {
                raw.setType(NONARCHIVED_STR);
            } else if (this.archived.booleanValue()) {
                raw.setType(ARCHIVED_STR);
            }
        }
        raw.setWuid(this.wuid);
        return raw;
    }

    public WUQuery getRaw156(int appvalue) throws Exception {
        WUQuery raw = new WUQuery();
        if (this.cluster != null) {
            raw.setCluster(this.cluster);
        }
        if (this.archived != null) {
            if (!this.archived.booleanValue()) {
                raw.setType(NONARCHIVED_STR);
            } else if (this.archived.booleanValue()) {
                raw.setType(ARCHIVED_STR);
            }
        }
        raw.setStartDate(Utils.dateToUTCString(this.startDate));
        if (this.state != null) {
            raw.setState(this.state.toString());
        }
        raw.setEndDate(Utils.dateToUTCString(this.endDate));
        raw.setWuid(this.wuid);
        raw.setJobname(this.jobname);
        raw.setOwner(this.owner);
        raw.setPageSize(this.pageSize);
        if (this.sortby != null) {
            raw.setSortby(this.sortby.toString());
        }
        raw.setDescending(this.descending);
        if (this.applicationValues.size() > 0) {
            if (appvalue >= this.applicationValues.size()) {
                throw new Exception("Can't use application value at 0-based index " + appvalue + ", there are only " + this.applicationValues.size() + " values");
            }
            raw.setApplicationName(this.applicationValues.get(appvalue).getApplication());
            raw.setApplicationKey(this.applicationValues.get(appvalue).getName());
            raw.setApplicationData(this.applicationValues.get(appvalue).getValue());
        }
        return raw;
    }

    public static enum LogicalFileSearchType {
        Input,
        Output;

    }

    public static enum SortBy {
        WUID,
        Owner,
        Jobname,
        Cluster,
        Protected,
        State;

    }
}

