/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingHelper {
    private static final Log log = LogFactory.getLog(AddressingHelper.class);

    public static boolean isSyncReplyAllowed(MessageContext messageContext) {
        EndpointReference replyTo = messageContext.getReplyTo();
        if (replyTo == null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(messageContext.getLogIDString() + " isSyncReplyAllowed: ReplyTo is null. Returning true");
            }
            return true;
        }
        return replyTo.hasAnonymousAddress() || replyTo.hasNoneAddress();
    }

    public static boolean isSyncFaultAllowed(MessageContext messageContext) {
        EndpointReference faultTo = messageContext.getFaultTo();
        if (faultTo == null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(messageContext.getLogIDString() + " isSyncFaultAllowed: FaultTo is null. Returning isSyncReplyAllowed");
            }
            return AddressingHelper.isSyncReplyAllowed(messageContext);
        }
        return faultTo.hasAnonymousAddress() || faultTo.hasNoneAddress();
    }

    public static boolean isReplyRedirected(MessageContext messageContext) {
        EndpointReference replyTo = messageContext.getReplyTo();
        if (replyTo == null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(messageContext.getLogIDString() + " isReplyRedirected: ReplyTo is null. Returning false");
            }
            return false;
        }
        return !replyTo.hasAnonymousAddress();
    }

    public static boolean isFaultRedirected(MessageContext messageContext) {
        EndpointReference faultTo = messageContext.getFaultTo();
        if (faultTo == null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(messageContext.getLogIDString() + " isFaultRedirected: FaultTo is null. Returning isReplyRedirected");
            }
            return AddressingHelper.isReplyRedirected(messageContext);
        }
        return !faultTo.hasAnonymousAddress();
    }

    public static boolean shouldSendFaultToFaultTo(MessageContext messageContext) {
        Object faultInfoForHeaders = messageContext.getLocalProperty("FaultHeaders");
        boolean doNotSendFaultUsingFaultTo = false;
        if (faultInfoForHeaders != null) {
            String problemHeaderName = (String)((Map)faultInfoForHeaders).get("ProblemHeaderQName");
            doNotSendFaultUsingFaultTo = problemHeaderName != null && "wsa:FaultTo".equals(problemHeaderName);
        }
        return !doNotSendFaultUsingFaultTo;
    }

    public static String getAddressingRequirementParemeterValue(AxisDescription axisDescription) {
        String value = "";
        if (axisDescription != null) {
            value = Utils.getParameterValue(axisDescription.getParameter("addressingRequirementParameter"));
            if (value != null) {
                value = value.trim();
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug("getAddressingRequirementParemeterValue: value: '" + value + "'");
            }
        }
        if (value == null || "".equals(value)) {
            value = "unspecified";
        }
        return value;
    }

    public static String getRequestAddressingRequirementParameterValue(MessageContext response) {
        String value = "";
        if (response != null) {
            HashMap<String, MessageContext> operationMessageContexts = response.getOperationContext().getMessageContexts();
            for (MessageContext messageContext : operationMessageContexts.values()) {
                if (messageContext.equals(response)) continue;
                value = (String)messageContext.getProperty("addressingRequirementParameter");
                if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) break;
                log.debug("getRequestAddressingRequirementParameterValue: got value from MessageContext " + messageContext + ", value: '" + value + "'");
                break;
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug("getRequestAddressingRequirementParameterValue: value: '" + value + "'");
            }
        }
        if (value == null || "".equals(value)) {
            value = "unspecified";
        }
        return value;
    }

    public static String getInvocationPatternParameterValue(AxisOperation axisOperation) {
        String value = "";
        if (axisOperation != null) {
            value = Utils.getParameterValue(axisOperation.getParameter("wsamInvocationPattern"));
            if (value != null) {
                value = value.trim();
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug("getInvocationPatternParameterValue: value: '" + value + "'");
            }
        }
        if (value == null || "".equals(value)) {
            value = "both";
        }
        return value;
    }

    public static void setInvocationPatternParameterValue(AxisOperation axisOperation, String value) {
        block11: {
            if (value == null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug("setInvocationPatternParameterValue: value passed in is null. return");
                }
                return;
            }
            Parameter param = axisOperation.getParameter("wsamInvocationPattern");
            if (param != null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug("setInvocationPatternParameterValue: Parameter already exists");
                }
                if (!param.isLocked()) {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug("setInvocationPatternParameterValue: Parameter not locked. Setting value: " + value);
                    }
                    param.setValue(value);
                }
            } else {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug("setInvocationPatternParameterValue: Parameter does not exist");
                }
                param = new Parameter();
                param.setName("wsamInvocationPattern");
                param.setValue(value);
                try {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug("setInvocationPatternParameterValue: Adding parameter with value: " + value);
                    }
                    axisOperation.addParameter(param);
                }
                catch (AxisFault af) {
                    if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) break block11;
                    log.debug("setInvocationPatternParameterValue: addParameter failed: " + af.getMessage());
                }
            }
        }
    }

    public static void setAddressingRequirementParemeterValue(AxisDescription axisDescription, String value) {
        block11: {
            if (value == null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug("setAddressingRequirementParemeterValue: value passed in is null. return");
                }
                return;
            }
            Parameter param = axisDescription.getParameter("addressingRequirementParameter");
            if (param != null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug("setAddressingRequirementParemeterValue: Parameter already exists");
                }
                if (!param.isLocked()) {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug("setAddressingRequirementParemeterValue: Parameter not locked. Setting value: " + value);
                    }
                    param.setValue(value);
                }
            } else {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug("setAddressingRequirementParemeterValue: Parameter does not exist");
                }
                param = new Parameter();
                param.setName("addressingRequirementParameter");
                param.setValue(value);
                try {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug("setAddressingRequirementParemeterValue: Adding parameter with value: " + value);
                    }
                    axisDescription.addParameter(param);
                }
                catch (AxisFault af) {
                    if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) break block11;
                    log.debug("setAddressingRequirementParemeterValue: addParameter failed: " + af.getMessage());
                }
            }
        }
    }

    public static OMElement getAddressingIdentityParameterValue(AxisEndpoint endpoint) {
        OMElement identityElement = (OMElement)endpoint.getParameterValue("addressingIdentity");
        if (identityElement != null && identityElement.getLocalName().equals("parameter")) {
            identityElement = identityElement.getFirstElement();
        }
        if (identityElement != null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(String.format("getAddressingIdentityParameterValue: %s parameter from AxisEndpoint '%s': %s", "addressingIdentity", endpoint.getName(), identityElement.toString()));
            }
            return identityElement;
        }
        AxisBinding binding = endpoint.getBinding();
        if (binding != null) {
            identityElement = (OMElement)binding.getParameterValue("addressingIdentity");
        }
        if (identityElement != null && identityElement.getLocalName().equals("parameter")) {
            identityElement = identityElement.getFirstElement();
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug(String.format("getAddressingIdentityParameterValue: %s parameter from AxisBinding '%s': %s", "addressingIdentity", binding.getName(), identityElement == null ? "N/A" : identityElement.toString()));
        }
        return identityElement;
    }
}

