/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointReference
implements Externalizable,
SafeSerializable {
    private static final long serialVersionUID = 5278892171162372439L;
    private static final Log log = LogFactory.getLog(EndpointReference.class);
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    private static final String myClassName = "EndpointReference";
    private String logCorrelationIDString;
    private static volatile List<String> anonymousEquivalentURIs = new ArrayList<String>();
    private String name;
    private String address;
    private ArrayList<OMAttribute> addressAttributes;
    private ArrayList<OMNode> metaData;
    private ArrayList<OMAttribute> metaDataAttributes;
    private Map<QName, OMElement> referenceParameters;
    private ArrayList<OMElement> extensibleElements;
    private ArrayList<OMAttribute> attributes;

    public EndpointReference() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAnonymousEquivalentURI(String anonymousEquivalentURI) {
        if (log.isTraceEnabled()) {
            log.trace("addAnonymousEquivalentURI: " + anonymousEquivalentURI);
        }
        List<String> list = anonymousEquivalentURIs;
        synchronized (list) {
            ArrayList<String> newList = new ArrayList<String>(anonymousEquivalentURIs);
            newList.add(anonymousEquivalentURI);
            anonymousEquivalentURIs = newList;
        }
    }

    public EndpointReference(String address) {
        this.address = address;
    }

    public void addReferenceParameter(OMElement omElement) {
        if (omElement == null) {
            return;
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new HashMap<QName, OMElement>();
        }
        this.referenceParameters.put(omElement.getQName(), omElement);
    }

    public void addReferenceParameter(QName qname2, String value) {
        if (qname2 == null) {
            return;
        }
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(qname2, null);
        omElement.setText(value);
        this.addReferenceParameter(omElement);
    }

    public Map<QName, OMElement> getAllReferenceParameters() {
        return this.referenceParameters;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public ArrayList<OMAttribute> getAddressAttributes() {
        return this.addressAttributes;
    }

    public void setAddressAttributes(ArrayList<OMAttribute> al) {
        this.addressAttributes = al;
    }

    public ArrayList<OMAttribute> getMetadataAttributes() {
        return this.metaDataAttributes;
    }

    public void setMetadataAttributes(ArrayList<OMAttribute> al) {
        this.metaDataAttributes = al;
    }

    public boolean isWSAddressingAnonymous() {
        return "http://www.w3.org/2005/08/addressing/anonymous".equals(this.address) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(this.address);
    }

    public boolean hasAnonymousAddress() {
        List<String> localList;
        boolean result = this.isWSAddressingAnonymous();
        if (!result && this.address != null && !(localList = anonymousEquivalentURIs).isEmpty()) {
            Iterator<String> it = localList.iterator();
            while (it.hasNext() && !(result = this.address.startsWith(it.next()))) {
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("hasAnonymousAddress: " + this.address + " is Anonymous: " + result);
        }
        return result;
    }

    public boolean hasNoneAddress() {
        boolean result = "http://www.w3.org/2005/08/addressing/none".equals(this.address);
        if (log.isTraceEnabled()) {
            log.trace("hasNoneAddress: " + this.address + " is None: " + result);
        }
        return result;
    }

    public void addAttribute(String localName, OMNamespace ns, String value) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(OMAbstractFactory.getOMFactory().createOMAttribute(localName, ns, value));
    }

    public ArrayList<OMAttribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(OMAttribute omAttribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(omAttribute);
    }

    public ArrayList<OMElement> getExtensibleElements() {
        return this.extensibleElements;
    }

    public void setExtensibleElements(ArrayList<OMElement> extensibleElements) {
        this.extensibleElements = extensibleElements;
    }

    public void addExtensibleElement(OMElement extensibleElement) {
        if (extensibleElement != null) {
            if (this.extensibleElements == null) {
                this.extensibleElements = new ArrayList();
            }
            this.extensibleElements.add(extensibleElement);
        }
    }

    public ArrayList<OMNode> getMetaData() {
        return this.metaData;
    }

    public void addMetaData(OMNode metaData) {
        if (metaData != null) {
            if (this.metaData == null) {
                this.metaData = new ArrayList();
            }
            this.metaData.add(metaData);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReferenceParameters(Map<QName, OMElement> referenceParameters) {
        this.referenceParameters = referenceParameters;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Address: " + this.address);
        if (this.addressAttributes != null) {
            buffer.append(", Address Attributes: ").append(this.addressAttributes);
        }
        if (this.metaData != null) {
            buffer.append(", Metadata: ").append(this.metaData);
        }
        if (this.metaDataAttributes != null) {
            buffer.append(", Metadata Attributes: ").append(this.metaDataAttributes);
        }
        if (this.referenceParameters != null) {
            buffer.append(", Reference Parameters: ").append(this.referenceParameters);
        }
        if (this.extensibleElements != null) {
            buffer.append(", Extensibility elements: ").append(this.extensibleElements);
        }
        if (this.attributes != null) {
            buffer.append(", Attributes: ").append(this.attributes);
        }
        return buffer.toString();
    }

    public boolean isEquivalent(EndpointReference epr) {
        if (this.name != null && epr.getName() != null) {
            if (!this.name.equals(epr.getName())) {
                return false;
            }
        } else if (this.name != null || epr.getName() != null) {
            return false;
        }
        if (this.address != null && epr.getAddress() != null) {
            if (!this.address.equals(epr.getAddress())) {
                return false;
            }
        } else if (this.address != null || epr.getAddress() != null) {
            return false;
        }
        ArrayList<OMNode> eprMetaData = epr.getMetaData();
        if (this.metaData != null && eprMetaData != null) {
            if (!this.metaData.equals(eprMetaData)) {
                return false;
            }
        } else if (this.metaData != null || eprMetaData != null) {
            return false;
        }
        ArrayList<OMElement> eprExtensibleElements = epr.getExtensibleElements();
        if (this.extensibleElements != null && eprExtensibleElements != null) {
            if (!this.extensibleElements.equals(eprExtensibleElements)) {
                return false;
            }
        } else if (this.extensibleElements != null || eprExtensibleElements != null) {
            return false;
        }
        ArrayList<OMAttribute> eprAttributes = epr.getAttributes();
        if (this.attributes != null && eprAttributes != null) {
            if (!this.attributes.equals(eprAttributes)) {
                return false;
            }
        } else if (this.attributes != null || eprAttributes != null) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeInt(2);
        String logCorrelationIDString = this.getLogCorrelationIDString();
        out.writeObject(logCorrelationIDString);
        out.writeUTF("start xml");
        OMElement om = EndpointReferenceHelper.toOM(OMAbstractFactory.getOMFactory(), this, new QName("urn:axis2", "omepr", "ser"), "http://www.w3.org/2005/08/addressing");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            om.serialize(baos);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to serialize the EndpointReference with logCorrelationID [" + logCorrelationIDString + "]");
            ioe.initCause(e);
            if (log.isDebugEnabled()) {
                log.debug("writeObject(): Unable to serialize the EPR with logCorrelationID [" + logCorrelationIDString + "]   original error [" + e.getClass().getName() + "]  message [" + e.getMessage() + "]", e);
            }
            throw ioe;
        }
        out.writeInt(baos.size());
        out.write(baos.toByteArray());
        out.writeUTF("end xml");
        if (log.isDebugEnabled()) {
            byte[] buffer = baos.toByteArray();
            String content = new String(buffer);
            log.debug("writeObject(): EPR logCorrelationID [" + logCorrelationIDString + "]     EPR content size [" + baos.size() + "]    EPR content [" + content + "]");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        int bytesRead;
        int numberOfBytesLastRead;
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        int revID = in.readInt();
        if (revID != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        this.logCorrelationIDString = (String)in.readObject();
        in.readUTF();
        int numBytes = in.readInt();
        byte[] serBytes = new byte[numBytes];
        for (bytesRead = 0; bytesRead < numBytes; bytesRead += numberOfBytesLastRead) {
            numberOfBytesLastRead = in.read(serBytes, bytesRead, numBytes - bytesRead);
            if (numberOfBytesLastRead != -1) continue;
            if (log.isDebugEnabled()) {
                log.debug("readObject(): EPR logCorrelationID [" + this.logCorrelationIDString + "]  ***WARNING*** unexpected end to data:    data read from input stream [" + bytesRead + "]    expected data size [" + numBytes + "]");
            }
            IOException ioe = new IOException("Unable to deserialize the EndpointReference with logCorrelationID [" + this.logCorrelationIDString + "]  Cause: Unexpected end to data from input stream");
            throw ioe;
        }
        if (bytesRead == 0) {
            IOException ioe = new IOException("Unable to deserialize the EndpointReference with logCorrelationID [" + this.logCorrelationIDString + "]  Cause: No data from input stream");
            throw ioe;
        }
        in.readUTF();
        ByteArrayInputStream bais = new ByteArrayInputStream(serBytes);
        if (log.isDebugEnabled()) {
            String content = new String(serBytes);
            log.debug("readObject(): EPR logCorrelationID [" + this.logCorrelationIDString + "]     expected content size [" + numBytes + "]    content size [" + content.length() + "]    EPR buffered content [" + content + "]");
        }
        XMLStreamReader xmlReader = null;
        try {
            try {
                OMElement om = OMXMLBuilderFactory.createOMBuilder(bais).getDocumentElement();
                om.build();
                if (log.isDebugEnabled()) {
                    log.debug("EndpointReference:readObject():   EPR [" + this.logCorrelationIDString + "] EPR OM content [" + om.toString() + "]");
                }
                EndpointReferenceHelper.fromOM(this, om, "http://www.w3.org/2005/08/addressing");
            }
            catch (Exception e) {
                IOException ioe = new IOException("Unable to deserialize the EndpointReference with logCorrelationID [" + this.logCorrelationIDString + "]");
                ioe.initCause(e);
                if (!log.isDebugEnabled()) throw ioe;
                log.debug("readObject(): Unable to deserialize the EPR with logCorrelationID [" + this.logCorrelationIDString + "]   original error [" + e.getClass().getName() + "]  message [" + e.getMessage() + "]", e);
                throw ioe;
            }
            Object var13_14 = null;
            if (xmlReader == null) return;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (xmlReader == null) throw throwable;
            try {
                xmlReader.close();
                throw throwable;
            }
            catch (Exception e2) {
                IOException ioe2 = new IOException("Unable to close the XMLStreamReader for the EndpointReference with logCorrelationID [" + this.logCorrelationIDString + "]");
                ioe2.initCause(e2);
                if (!log.isDebugEnabled()) throw ioe2;
                log.debug("readObject(): Unable to close the XMLStreamReader for the EPR with logCorrelationID [" + this.logCorrelationIDString + "]   original error [" + e2.getClass().getName() + "]  message [" + e2.getMessage() + "]", e2);
                throw ioe2;
            }
        }
        try {}
        catch (Exception e2) {
            IOException ioe2 = new IOException("Unable to close the XMLStreamReader for the EndpointReference with logCorrelationID [" + this.logCorrelationIDString + "]");
            ioe2.initCause(e2);
            if (!log.isDebugEnabled()) throw ioe2;
            log.debug("readObject(): Unable to close the XMLStreamReader for the EPR with logCorrelationID [" + this.logCorrelationIDString + "]   original error [" + e2.getClass().getName() + "]  message [" + e2.getMessage() + "]", e2);
            throw ioe2;
        }
        xmlReader.close();
    }

    public String getLogCorrelationIDString() {
        if (this.logCorrelationIDString == null) {
            this.logCorrelationIDString = "EndpointReference@" + UIDGenerator.generateUID();
        }
        return this.logCorrelationIDString;
    }
}

