/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.externalize.ActivateUtils;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationContext
extends AbstractContext
implements Externalizable,
SafeSerializable {
    private static final Log log = LogFactory.getLog(OperationContext.class);
    private static final String myClassName = "OperationContext";
    private static boolean debugEnabled = log.isDebugEnabled();
    private String logCorrelationIDString = null;
    private static final long serialVersionUID = -7264782778333554350L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    private boolean isComplete;
    private String key;
    private transient AxisOperation axisOperation;
    private transient HashMap<String, MessageContext> messageContexts = new HashMap();
    private transient boolean needsToBeReconciled = false;
    private transient boolean suppressWarnings = false;
    private transient MetaDataEntry metaAxisOperation = null;
    private transient MetaDataEntry metaAxisService = null;
    private transient ServiceContext metaParent = null;
    private HashMap metaMessageContextMap = null;
    private transient HashMap isolatedMessageContexts = null;
    private transient HashMap workingSet = null;

    public OperationContext() {
        super(null);
    }

    public OperationContext(AxisOperation axisOperation, ServiceContext serviceContext) {
        super(serviceContext);
        this.axisOperation = axisOperation;
        this.setParent(serviceContext);
    }

    public void addMessageContext(MessageContext msgContext) throws AxisFault {
        if (this.axisOperation != null) {
            this.axisOperation.addMessageContext(msgContext, this);
            this.touch();
        }
    }

    public void cleanup() {
        ServiceContext serv = this.getServiceContext();
        if (serv != null) {
            serv.getConfigurationContext().unregisterOperationContext(this.key);
        }
    }

    public AxisOperation getAxisOperation() {
        if (this.needsToBeReconciled && !this.suppressWarnings && debugEnabled) {
            log.debug(this.getLogCorrelationIDString() + ":getAxisOperation(): ****WARNING**** OperationContext.activate(configurationContext) needs to be invoked.");
        }
        return this.axisOperation;
    }

    public ConfigurationContext getConfigurationContext() {
        if (this.parent != null) {
            return ((ServiceContext)this.parent).getConfigurationContext();
        }
        return null;
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        if (this.messageContexts == null) {
            return null;
        }
        return this.messageContexts.get(messageLabel);
    }

    public void removeMessageContext(String label) throws AxisFault {
        MessageContext mc = this.getMessageContext(label);
        if (mc != null) {
            this.messageContexts.remove(label);
            this.setComplete(false);
            this.touch();
        }
    }

    public HashMap<String, MessageContext> getMessageContexts() {
        return this.messageContexts;
    }

    public ServiceContext getServiceContext() {
        return (ServiceContext)this.parent;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeLong(-7264782778333554350L);
        out.writeInt(2);
        out.writeLong(this.getLastTouchedTime());
        out.writeBoolean(this.isComplete);
        out.writeObject(this.key);
        out.writeObject(this.logCorrelationIDString);
        out.writeUTF("properties");
        out.writeMap(this.getProperties());
        out.writeUTF("metaAxisOperation");
        this.metaAxisOperation = null;
        if (this.axisOperation != null) {
            this.metaAxisOperation = new MetaDataEntry(this.axisOperation.getClass().getName(), this.axisOperation.getName().toString());
        }
        out.writeObject(this.metaAxisOperation);
        out.writeUTF("metaAxisService");
        this.metaAxisService = null;
        AxisService axisService = this.axisOperation.getAxisService();
        if (axisService != null) {
            String serviceAndPortNames = ActivateUtils.getAxisServiceExternalizeExtraName(axisService);
            this.metaAxisService = new MetaDataEntry(axisService.getClass().getName(), axisService.getName(), serviceAndPortNames);
        }
        out.writeObject(this.metaAxisService);
        out.writeUTF("parent");
        out.writeObject(this.getServiceContext());
        HashMap<String, MessageContext> tmpMsgCtxMap = null;
        if (this.messageContexts != null && !this.messageContexts.isEmpty()) {
            this.workingSet = new HashMap();
            tmpMsgCtxMap = new HashMap<String, MessageContext>();
            Set<String> keySet = this.messageContexts.keySet();
            for (String keyObj : keySet) {
                String idIsol;
                MessageContext valueIsolated;
                MessageContext value = this.messageContexts.get(keyObj);
                boolean addToWorkingSet = true;
                if (this.isolatedMessageContexts != null && !this.isolatedMessageContexts.isEmpty() && (valueIsolated = (MessageContext)this.isolatedMessageContexts.get(keyObj)) != null && (idIsol = valueIsolated.getMessageID()) != null && idIsol.equals(value.getMessageID())) {
                    addToWorkingSet = false;
                }
                if (!addToWorkingSet) continue;
                this.workingSet.put(keyObj, value);
            }
            Set keySet2 = this.workingSet.keySet();
            for (String keyObj2 : keySet2) {
                MessageContext mc = (MessageContext)this.workingSet.get(keyObj2);
                MessageContext copyMC = mc.extractCopyMessageContext();
                copyMC.setEnvelope(null);
                tmpMsgCtxMap.put(keyObj2, copyMC);
                if (!log.isTraceEnabled()) continue;
                log.trace(this.getLogCorrelationIDString() + ":writeExternal():  getting working set entry  key [" + keyObj2 + "]   message context ID[" + copyMC.getMessageID() + "]");
            }
        }
        out.writeUTF("messagecontexts");
        out.writeMap(tmpMsgCtxMap);
        out.writeUTF("metaMessageContextMap");
        out.writeMap(this.metaMessageContextMap);
    }

    @Override
    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        this.needsToBeReconciled = true;
        log.trace("OperationContext:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  ");
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != -7264782778333554350L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        long time = in.readLong();
        this.setLastTouchedTime(time);
        this.isComplete = in.readBoolean();
        this.key = (String)in.readObject();
        this.logCorrelationIDString = (String)in.readObject();
        if (log.isTraceEnabled()) {
            log.trace("OperationContext:readExternal():  reading input stream for [" + this.getLogCorrelationIDString() + "]  ");
        }
        in.readUTF();
        this.properties = in.readMap(new HashMap());
        this.axisOperation = null;
        in.readUTF();
        this.metaAxisOperation = (MetaDataEntry)in.readObject();
        in.readUTF();
        this.metaAxisService = (MetaDataEntry)in.readObject();
        in.readUTF();
        this.metaParent = (ServiceContext)in.readObject();
        this.messageContexts = new HashMap();
        in.readUTF();
        this.workingSet = in.readHashMap();
        in.readUTF();
        this.metaMessageContextMap = in.readHashMap();
    }

    public void activate(ConfigurationContext cc) {
        boolean registrationSuceeded;
        String mepString;
        if (!this.needsToBeReconciled) {
            return;
        }
        AxisConfiguration axisConfig = cc.getAxisConfiguration();
        AxisService axisService = null;
        if (this.metaAxisService != null) {
            axisService = ActivateUtils.findService(axisConfig, this.metaAxisService.getClassName(), this.metaAxisService.getQNameAsString(), this.metaAxisService.getExtraName());
        }
        if (this.metaAxisOperation != null) {
            this.axisOperation = axisService != null ? ActivateUtils.findOperation(axisService, this.metaAxisOperation.getClassName(), this.metaAxisOperation.getQName()) : ActivateUtils.findOperation(axisConfig, this.metaAxisOperation.getClassName(), this.metaAxisOperation.getQName());
        }
        if (this.metaParent != null) {
            OperationContext existingOC;
            String groupName = this.metaParent.getGroupName();
            String serviceName = this.metaParent.getName();
            ServiceContext existingSC = null;
            ServiceGroupContext sgc = cc.getServiceGroupContext(groupName);
            if (sgc != null) {
                existingSC = sgc.findServiceContext(serviceName);
            }
            if (existingSC == null && (existingOC = cc.findOperationContext(this.getOperationName(), serviceName, groupName)) != null) {
                existingSC = (ServiceContext)existingOC.getParent();
            }
            if (existingSC == null) {
                this.metaParent.activate(cc);
                this.setParent(this.metaParent);
            } else {
                this.setParent(existingSC);
                this.metaParent.putContextProperties(existingSC, true);
            }
        } else {
            this.setParent(this.metaParent);
        }
        ServiceContext serv = this.getServiceContext();
        ConfigurationContext activeCC = serv != null ? serv.getConfigurationContext() : cc;
        if (this.key != null && ((mepString = this.getAxisOperation().getMessageExchangePattern()).equals("http://www.w3.org/ns/wsdl/out-only") || mepString.equals("http://www.w3.org/ns/wsdl/out-only") || (mepString.equals("http://www.w3.org/ns/wsdl/out-in") || mepString.equals("http://www.w3.org/ns/wsdl/out-in")) && !this.isComplete) && !(registrationSuceeded = activeCC.registerOperationContext(this.key, this, true)) && log.isTraceEnabled()) {
            log.trace(this.getLogCorrelationIDString() + ":activate():  OperationContext key [" + this.key + "] already exists in ConfigurationContext map.  This OperationContext [" + this.toString() + "] was not added to the table.");
        }
        if (this.workingSet != null && !this.workingSet.isEmpty()) {
            Set keySet = this.workingSet.keySet();
            for (String keyObj : keySet) {
                MessageContext value = (MessageContext)this.workingSet.get(keyObj);
                if (value != null) {
                    if (log.isTraceEnabled()) {
                        log.trace(this.getLogCorrelationIDString() + ":activate():  key [" + keyObj + "]  message id [" + value.getMessageID() + "]");
                    }
                    this.suppressWarnings = true;
                    value.activateWithOperationContext(this);
                    this.suppressWarnings = false;
                    if (this.messageContexts == null) {
                        this.messageContexts = new HashMap();
                    }
                }
                this.messageContexts.put(keyObj, value);
            }
        }
        this.needsToBeReconciled = false;
    }

    public void isolateMessageContext(MessageContext mc) {
        if (mc == null) {
            return;
        }
        if (this.messageContexts == null || this.messageContexts.isEmpty()) {
            return;
        }
        String messageID = mc.getMessageID();
        if (messageID == null) {
            return;
        }
        for (String keyObj : this.messageContexts.keySet()) {
            String valueID;
            MessageContext value = this.messageContexts.get(keyObj);
            if (value == null || (valueID = value.getMessageID()) == null || !valueID.equals(messageID)) continue;
            if (this.metaMessageContextMap == null) {
                this.metaMessageContextMap = new HashMap();
            }
            MetaDataEntry metaData = new MetaDataEntry(value.getClass().getName(), value.getMessageID(), keyObj.toString());
            this.metaMessageContextMap.put(keyObj, metaData);
            if (this.isolatedMessageContexts == null) {
                this.isolatedMessageContexts = new HashMap();
            }
            this.isolatedMessageContexts.put(keyObj, value);
            if (!log.isTraceEnabled()) break;
            log.trace(this.getLogCorrelationIDString() + ":isolateMessageContext():  set up message context id[" + valueID + "]  with key [" + keyObj.toString() + "] from messageContexts table to prepare for serialization.");
            break;
        }
    }

    public void restoreMessageContext(MessageContext msg) {
        if (this.needsToBeReconciled) {
            if (debugEnabled) {
                log.debug(this.getLogCorrelationIDString() + ":restoreMessageContext(): *** WARNING : need to invoke activate() prior to restoring the MessageContext to the list.");
            }
            return;
        }
        if (msg == null) {
            return;
        }
        String msgID = msg.getMessageID();
        if (msgID == null) {
            if (debugEnabled) {
                log.debug(this.getLogCorrelationIDString() + ":restoreMessageContext(): *** WARNING : MessageContext does not have a message ID.");
            }
            return;
        }
        if (this.metaMessageContextMap != null && !this.metaMessageContextMap.isEmpty()) {
            for (String keyM : this.metaMessageContextMap.keySet()) {
                String valueM_ID;
                MetaDataEntry valueM = (MetaDataEntry)this.metaMessageContextMap.get(keyM);
                if (valueM == null || !msgID.equals(valueM_ID = valueM.getQNameAsString())) continue;
                String label = valueM.getExtraName();
                if (this.messageContexts == null) {
                    this.messageContexts = new HashMap();
                }
                this.messageContexts.put(label, msg);
                this.metaMessageContextMap.remove(keyM);
                if (!log.isTraceEnabled()) break;
                log.trace(this.getLogCorrelationIDString() + ":restoreMessageContext():  restored   label [" + label + "]    message ID [" + msg.getMessageID() + "]");
                break;
            }
        } else if (this.messageContexts != null && !this.messageContexts.isEmpty()) {
            for (String key : this.messageContexts.keySet()) {
                String valueID;
                MessageContext value = this.messageContexts.get(key);
                if (value == null || !msgID.equals(valueID = value.getMessageID())) continue;
                this.messageContexts.put(key, msg);
            }
        }
    }

    public String getOperationName() {
        QName qname2;
        String opName = null;
        if (this.axisOperation != null && (qname2 = this.axisOperation.getName()) != null) {
            opName = qname2.getLocalPart();
        }
        return opName;
    }

    public String getServiceName() {
        String srvName = null;
        ServiceContext sc = (ServiceContext)this.getParent();
        if (sc == null) {
            sc = this.metaParent;
        }
        if (sc != null) {
            srvName = sc.getName();
        }
        return srvName;
    }

    public String getServiceGroupName() {
        String srvGroupName = null;
        ServiceContext sc = (ServiceContext)this.getParent();
        if (sc == null) {
            sc = this.metaParent;
        }
        if (sc != null) {
            srvGroupName = sc.getGroupName();
        }
        return srvGroupName;
    }

    public boolean isEquivalent(OperationContext ctx) {
        if (this.isComplete != ctx.isComplete()) {
            return false;
        }
        return this.axisOperation.equals(ctx.getAxisOperation());
    }

    public String getLogCorrelationIDString() {
        if (this.logCorrelationIDString == null) {
            this.logCorrelationIDString = "OperationContext@" + UIDGenerator.generateUID();
        }
        return this.logCorrelationIDString;
    }

    @Override
    public ConfigurationContext getRootContext() {
        return this.getConfigurationContext();
    }
}

