/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axis2.datasource.jaxb.JAXBCustomBuilderMonitor;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.axis2.datasource.jaxb.JAXBDataSource;
import org.apache.axis2.jaxws.handler.HandlerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBCustomBuilder
implements CustomBuilder {
    private static final Log log = LogFactory.getLog(JAXBCustomBuilder.class);
    JAXBDSContext jdsContext;

    public JAXBCustomBuilder(JAXBDSContext context) {
        this.jdsContext = context;
        JAXBCustomBuilderMonitor.updateTotalBuilders();
    }

    public OMElement create(String namespace, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory) throws OMException {
        if (log.isDebugEnabled()) {
            log.debug("create namespace = " + namespace);
            log.debug("  localPart = " + localPart);
            log.debug("  reader = " + reader.getClass());
        }
        if (!this.shouldUnmarshal(namespace, localPart)) {
            JAXBCustomBuilderMonitor.updateTotalFailedCreates();
            return null;
        }
        try {
            OMNamespace ns = factory.createOMNamespace(namespace, null);
            Object jaxb = this.jdsContext.unmarshal(reader);
            if (log.isDebugEnabled()) {
                log.debug("Successfully unmarshalled jaxb object " + jaxb);
            }
            JAXBDataSource ds = new JAXBDataSource(jaxb, this.jdsContext);
            if (log.isDebugEnabled()) {
                log.debug("The JAXBDataSource is " + ds);
            }
            OMSourcedElement omse = factory.createOMElement(ds, localPart, ns);
            parent.addChild(omse);
            JAXBCustomBuilderMonitor.updateTotalCreates();
            return omse;
        }
        catch (JAXBException e) {
            JAXBCustomBuilderMonitor.updateTotalFailedCreates();
            throw new OMException(e);
        }
    }

    private boolean shouldUnmarshal(String namespace, String localPart) {
        boolean isHighFidelity = HandlerUtils.isHighFidelity(this.jdsContext.getMessageContext());
        if (isHighFidelity) {
            if (log.isDebugEnabled()) {
                log.debug("JAXB payload streaming disabled because high fidelity messages are requested.");
            }
            return false;
        }
        if (localPart == null || namespace == null || namespace.length() == 0 || "http://schemas.xmlsoap.org/soap/envelope/".equals(namespace) || "http://www.w3.org/2003/05/soap-envelope".equals(namespace)) {
            return false;
        }
        return !localPart.equals("EncryptedData");
    }
}

