/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.util.DetachableInputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.api.MessageAccessorFactory;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContext {
    private static Log log = LogFactory.getLog(MessageContext.class);
    private InvocationContext invocationCtx;
    private org.apache.axis2.context.MessageContext axisMsgCtx;
    private EndpointDescription endpointDesc;
    private OperationDescription operationDesc;
    private QName operationName;
    private Message message;
    private Service.Mode mode;
    private boolean isOutbound;
    private boolean isServer = false;
    private MEPContext mepCtx;
    private Throwable localException = null;
    private AxisFault causedByException = null;

    public MessageContext() {
        this.axisMsgCtx = new org.apache.axis2.context.MessageContext();
        this.isOutbound = true;
        MessageAccessorFactory factory = (MessageAccessorFactory)FactoryRegistry.getFactory(MessageAccessorFactory.class);
        if (factory != null) {
            this.setProperty("jaxws.message.accessor", factory.createMessageAccessor(this));
        }
    }

    public MessageContext(org.apache.axis2.context.MessageContext mc) throws WebServiceException {
        MessageAccessorFactory factory;
        this.isOutbound = false;
        if (mc != null) {
            this.axisMsgCtx = mc;
            this.message = MessageUtils.getMessageFromMessageContext(mc);
            if (this.message != null) {
                this.message.setMessageContext(this);
            }
        } else {
            this.axisMsgCtx = new org.apache.axis2.context.MessageContext();
        }
        if ((factory = (MessageAccessorFactory)FactoryRegistry.getFactory(MessageAccessorFactory.class)) != null) {
            this.setProperty("jaxws.message.accessor", factory.createMessageAccessor(this));
        }
    }

    public InvocationContext getInvocationContext() {
        return this.invocationCtx;
    }

    public void setInvocationContext(InvocationContext ic) {
        this.invocationCtx = ic;
    }

    public Map<String, Object> getProperties() {
        Iterator<String> names = this.axisMsgCtx.getPropertyNames();
        HashMap<String, Object> tempProps = new HashMap<String, Object>();
        while (names.hasNext()) {
            String name = names.next();
            tempProps.put(name, this.axisMsgCtx.getProperty(name));
        }
        return tempProps;
    }

    public void setProperties(Map<String, Object> _properties) {
        _properties.put("CopyProperties", true);
        this.axisMsgCtx.setProperties(_properties);
    }

    public Object getProperty(String key) {
        return this.axisMsgCtx.getLocalProperty(key, false);
    }

    public boolean containsKey(Object key) {
        return key instanceof String && this.getProperty((String)key) != null;
    }

    public Object setProperty(String key, Object value) {
        Object retval = this.axisMsgCtx.getLocalProperty(key, false);
        this.axisMsgCtx.setProperty(key, value);
        return retval;
    }

    public void setPropertyNoReturn(String key, Object value) {
        this.axisMsgCtx.setProperty(key, value);
    }

    public EndpointDescription getEndpointDescription() {
        return this.endpointDesc;
    }

    public void setEndpointDescription(EndpointDescription ed) {
        this.endpointDesc = ed;
    }

    public OperationDescription getOperationDescription() {
        return this.operationDesc;
    }

    public void setOperationDescription(OperationDescription od) {
        this.operationDesc = od;
    }

    public Service.Mode getMode() {
        return this.mode;
    }

    public void setMode(Service.Mode m) {
        this.mode = m;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName op) {
        this.operationName = op;
    }

    public void setMessage(Message msg) {
        this.message = msg;
        msg.setMessageContext(this);
    }

    public Message getMessage() {
        return this.message;
    }

    public org.apache.axis2.context.MessageContext getAxisMessageContext() {
        return this.axisMsgCtx;
    }

    public ClassLoader getClassLoader() {
        AxisService svc = this.axisMsgCtx.getAxisService();
        if (svc != null) {
            return svc.getClassLoader();
        }
        return null;
    }

    public boolean isMaintainSession() {
        boolean maintainSession = false;
        Boolean value = (Boolean)this.getProperty("javax.xml.ws.session.maintain");
        if (value != null && value.booleanValue()) {
            maintainSession = true;
        }
        return maintainSession;
    }

    public Throwable getLocalException() {
        return this.localException;
    }

    public void setLocalException(Throwable t) {
        this.localException = t;
    }

    public void setCausedByException(AxisFault t) {
        this.causedByException = t;
    }

    public AxisFault getCausedByException() {
        return this.causedByException;
    }

    public void setMEPContext(MEPContext mepCtx) {
        if (this.mepCtx == null) {
            this.mepCtx = mepCtx;
            this.mepCtx.setResponseMessageContext(this);
        }
    }

    public MEPContext getMEPContext() {
        if (this.mepCtx == null) {
            this.setMEPContext(new MEPContext(this));
        }
        return this.mepCtx;
    }

    public boolean isOutbound() {
        return this.isOutbound;
    }

    public void setOutbound(boolean isOutbound) {
        this.isOutbound = isOutbound;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public void setServer(boolean isServer) {
        this.isServer = isServer;
    }

    public void freeInputStream() throws IOException {
        DetachableInputStream is = (DetachableInputStream)this.getProperty("org.apache.axiom.om.util.DetachableInputStream");
        if (is != null) {
            if (log.isDebugEnabled()) {
                log.debug("Detaching inbound input stream " + is);
            }
            is.detach();
        }
    }
}

