/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.concurrent.Executor;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointReferenceUtils;
import org.apache.axis2.jaxws.client.PropertyMigrator;
import org.apache.axis2.jaxws.client.dispatch.JAXBDispatch;
import org.apache.axis2.jaxws.client.dispatch.XMLDispatch;
import org.apache.axis2.jaxws.client.proxy.JAXWSProxyHandler;
import org.apache.axis2.jaxws.context.listener.ProviderOMContextListener;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.handler.HandlerResolverImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.spi.BindingProvider;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.axis2.jaxws.util.WSDLWrapper;
import org.apache.axis2.jaxws.utility.ExecutorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDelegate
extends javax.xml.ws.spi.ServiceDelegate {
    private static final Log log = LogFactory.getLog(ServiceDelegate.class);
    private static ThreadLocal<DescriptionBuilderComposite> sparseServiceCompositeThreadLocal = new ThreadLocal();
    private static ThreadLocal<DescriptionBuilderComposite> sparsePortCompositeThreadLocal = new ThreadLocal();
    private Executor executor;
    private ServiceDescription serviceDescription;
    private QName serviceQname;
    private ServiceClient serviceClient = null;
    private HandlerResolver handlerResolver = null;

    public static void setServiceMetadata(DescriptionBuilderComposite composite) {
        sparseServiceCompositeThreadLocal.set(composite);
    }

    static DescriptionBuilderComposite getServiceMetadata() {
        return sparseServiceCompositeThreadLocal.get();
    }

    static void resetServiceMetadata() {
        sparseServiceCompositeThreadLocal.set(null);
    }

    public static void setPortMetadata(DescriptionBuilderComposite composite) {
        sparsePortCompositeThreadLocal.set(composite);
    }

    static DescriptionBuilderComposite getPortMetadata() {
        return sparsePortCompositeThreadLocal.get();
    }

    static void resetPortMetadata() {
        sparsePortCompositeThreadLocal.set(null);
    }

    public ServiceDelegate(URL url, QName qname2, Class clazz, WebServiceFeature ... features) throws WebServiceException {
        this.serviceQname = qname2;
        if (!this.isValidServiceName()) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDelegateConstruct0", ""));
        }
        if (features != null && features.length != 0) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDelegateConstruct2", this.serviceQname.toString()));
        }
        DescriptionBuilderComposite sparseComposite = ServiceDelegate.getServiceMetadata();
        ServiceDelegate.resetServiceMetadata();
        this.serviceDescription = sparseComposite != null ? DescriptionFactory.createServiceDescription(url, this.serviceQname, clazz, sparseComposite, this) : DescriptionFactory.createServiceDescription(url, this.serviceQname, clazz);
        if (this.isValidWSDLLocation() && !this.isServiceDefined(this.serviceQname)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDelegateConstruct0", this.serviceQname.toString(), url.toString()));
        }
        ConfigurationContext context = this.serviceDescription.getAxisConfigContext();
        ApplicationContextMigratorUtil.addApplicationContextMigrator(context, "org.apache.axis2.jaxws.spi.ApplicationContextMigrators", new PropertyMigrator());
    }

    @Override
    public void addPort(QName portName, String bindingId, String endpointAddress) throws WebServiceException {
        this.verifyServiceDescriptionActive();
        if (log.isDebugEnabled()) {
            log.debug("Calling addPort : (" + portName + "," + bindingId + "," + endpointAddress + ")");
        }
        if (endpointAddress != null && endpointAddress.trim().length() == 0) {
            ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortErr1", portName != null ? portName.getLocalPart() : "", endpointAddress));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint(this.serviceDescription, null, portName, DescriptionFactory.UpdateType.ADD_PORT, this, bindingId, endpointAddress);
        endpointDesc.setEndpointAddress(endpointAddress);
        endpointDesc.setClientBindingID(bindingId);
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) throws WebServiceException {
        return this.createDispatch(portName, type, mode, (WebServiceFeature[])null);
    }

    @Override
    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode) {
        return this.createDispatch(portName, context, mode, (WebServiceFeature[])null);
    }

    @Override
    public <T> Dispatch<T> createDispatch(EndpointReference jaxwsEPR, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        if (log.isDebugEnabled()) {
            log.debug("Create Dispatch with epr: " + jaxwsEPR);
        }
        this.verifyServiceDescriptionActive();
        if (jaxwsEPR == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchNoEndpointReference"));
        }
        if (!this.isValidDispatchType(type)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchInvalidType"));
        }
        if (!this.isValidDispatchTypeWithMode(type, mode)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchInvalidTypeWithMode"));
        }
        org.apache.axis2.addressing.EndpointReference axis2EPR = EndpointReferenceUtils.createAxis2EndpointReference("");
        String addressingNamespace = null;
        try {
            addressingNamespace = EndpointReferenceUtils.convertToAxis2(axis2EPR, jaxwsEPR);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invalidEndpointReference", e.toString()));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint(this.serviceDescription, null, axis2EPR, addressingNamespace, DescriptionFactory.UpdateType.CREATE_DISPATCH, (Object)this);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("endpointDescriptionConstructionFailure", jaxwsEPR.toString()));
        }
        XMLDispatch dispatch = new XMLDispatch(this, endpointDesc, axis2EPR, addressingNamespace, features);
        if (mode != null) {
            dispatch.setMode(mode);
        } else {
            dispatch.setMode(Service.Mode.PAYLOAD);
        }
        if (this.serviceClient == null) {
            this.serviceClient = this.getServiceClient(endpointDesc.getPortQName());
        }
        if (type == OMElement.class) {
            if (log.isDebugEnabled()) {
                log.debug("This a Dispatch<OMElement>. The custom builder is installed.");
            }
            ProviderOMContextListener.create(this.serviceClient.getServiceContext());
        }
        dispatch.setServiceClient(this.serviceClient);
        dispatch.setType(type);
        return dispatch;
    }

    @Override
    public Dispatch<Object> createDispatch(EndpointReference jaxwsEPR, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        if (log.isDebugEnabled()) {
            log.debug("Create Dispatch with epr 2: " + jaxwsEPR);
        }
        this.verifyServiceDescriptionActive();
        if (jaxwsEPR == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchNoEndpointReference"));
        }
        org.apache.axis2.addressing.EndpointReference axis2EPR = EndpointReferenceUtils.createAxis2EndpointReference("");
        String addressingNamespace = null;
        try {
            addressingNamespace = EndpointReferenceUtils.convertToAxis2(axis2EPR, jaxwsEPR);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invalidEndpointReference", e.toString()));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint(this.serviceDescription, null, axis2EPR, addressingNamespace, DescriptionFactory.UpdateType.CREATE_DISPATCH, (Object)this);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("endpointDescriptionConstructionFailure", jaxwsEPR.toString()));
        }
        JAXBDispatch dispatch = new JAXBDispatch(this, endpointDesc, axis2EPR, addressingNamespace, features);
        if (mode != null) {
            dispatch.setMode(mode);
        } else {
            dispatch.setMode(Service.Mode.PAYLOAD);
        }
        if (this.serviceClient == null) {
            this.serviceClient = this.getServiceClient(endpointDesc.getPortQName());
        }
        dispatch.setJAXBContext(context);
        dispatch.setServiceClient(this.serviceClient);
        return dispatch;
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        if (log.isDebugEnabled()) {
            log.debug("Create Dispatch with portName: " + portName);
        }
        this.verifyServiceDescriptionActive();
        if (portName == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail0"));
        }
        if (!this.isValidDispatchType(type)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchInvalidType"));
        }
        if (!this.isValidDispatchTypeWithMode(type, mode)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchInvalidTypeWithMode"));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint(this.serviceDescription, null, portName, DescriptionFactory.UpdateType.CREATE_DISPATCH, this);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail2", portName.toString()));
        }
        XMLDispatch dispatch = new XMLDispatch(this, endpointDesc, features);
        if (mode != null) {
            dispatch.setMode(mode);
        } else {
            dispatch.setMode(Service.Mode.PAYLOAD);
        }
        if (this.serviceClient == null) {
            this.serviceClient = this.getServiceClient(portName);
        }
        if (type == OMElement.class) {
            if (log.isDebugEnabled()) {
                log.debug("This a Dispatch<OMElement>. The custom builder is installed.");
            }
            ProviderOMContextListener.create(this.serviceClient.getServiceContext());
        }
        dispatch.setServiceClient(this.serviceClient);
        dispatch.setType(type);
        return dispatch;
    }

    @Override
    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        if (log.isDebugEnabled()) {
            log.debug("Create Dispatch with jaxbcontext and portName: " + portName);
        }
        this.verifyServiceDescriptionActive();
        if (portName == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail0"));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint(this.serviceDescription, null, portName, DescriptionFactory.UpdateType.CREATE_DISPATCH, this);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail2", portName.toString()));
        }
        JAXBDispatch dispatch = new JAXBDispatch(this, endpointDesc, features);
        if (mode != null) {
            dispatch.setMode(mode);
        } else {
            dispatch.setMode(Service.Mode.PAYLOAD);
        }
        if (this.serviceClient == null) {
            this.serviceClient = this.getServiceClient(portName);
        }
        dispatch.setJAXBContext(context);
        dispatch.setServiceClient(this.serviceClient);
        return dispatch;
    }

    @Override
    public <T> T getPort(Class<T> sei) throws WebServiceException {
        return this.getPort((QName)null, sei, (WebServiceFeature[])null);
    }

    @Override
    public <T> T getPort(QName portName, Class<T> sei) throws WebServiceException {
        return this.getPort(portName, sei, (WebServiceFeature[])null);
    }

    @Override
    public <T> T getPort(Class<T> sei, WebServiceFeature ... features) {
        return this.getPort((QName)null, sei, features);
    }

    @Override
    public <T> T getPort(EndpointReference jaxwsEPR, Class<T> sei, WebServiceFeature ... features) {
        if (log.isTraceEnabled()) {
            log.trace("getPort: jaxwsEPR = " + jaxwsEPR);
        }
        if (!this.isValidWSDLLocation()) {
            // empty if block
        }
        if (jaxwsEPR == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dispatchNoEndpointReference2"));
        }
        if (sei == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("getPortInvalidSEI", jaxwsEPR.toString(), "null"));
        }
        org.apache.axis2.addressing.EndpointReference axis2EPR = EndpointReferenceUtils.createAxis2EndpointReference("");
        String addressingNamespace = null;
        try {
            addressingNamespace = EndpointReferenceUtils.convertToAxis2(axis2EPR, jaxwsEPR);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invalidEndpointReference", e.toString()));
        }
        if (log.isTraceEnabled()) {
            log.trace("getPort: Converted jaxwsEPR to axis2EPR = " + axis2EPR);
        }
        return this.getPort(axis2EPR, addressingNamespace, sei, features);
    }

    @Override
    public <T> T getPort(QName portName, Class<T> sei, WebServiceFeature ... features) {
        this.verifyServiceDescriptionActive();
        if (!this.isValidWSDLLocation()) {
            // empty if block
        }
        if (sei == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("getPortInvalidSEI", portName.toString(), "null"));
        }
        DescriptionBuilderComposite sparseComposite = ServiceDelegate.getPortMetadata();
        ServiceDelegate.resetPortMetadata();
        EndpointDescription endpointDesc = null;
        endpointDesc = sparseComposite != null ? DescriptionFactory.updateEndpoint(this.serviceDescription, sei, portName, DescriptionFactory.UpdateType.GET_PORT, sparseComposite, (Object)this) : DescriptionFactory.updateEndpoint(this.serviceDescription, sei, portName, DescriptionFactory.UpdateType.GET_PORT, null, (Object)this);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("portErr", portName.toString()));
        }
        String[] interfacesNames = new String[]{sei.getName(), BindingProvider.class.getName()};
        Class[] interfaces = null;
        ClassLoader classLoader = ServiceDelegate.getClassLoader(sei);
        try {
            interfaces = ServiceDelegate.loadClasses(classLoader, interfacesNames);
        }
        catch (ClassNotFoundException e1) {
            classLoader = ServiceDelegate.getContextClassLoader();
            try {
                interfaces = ServiceDelegate.loadClasses(classLoader, interfacesNames);
            }
            catch (ClassNotFoundException e2) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("portErr1"), e2);
            }
        }
        JAXWSProxyHandler proxyHandler = new JAXWSProxyHandler(this, interfaces[0], endpointDesc, features);
        Object proxyClass = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)proxyHandler);
        return sei.cast(proxyClass);
    }

    @Override
    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.getDefaultExecutor();
        }
        return this.executor;
    }

    @Override
    public HandlerResolver getHandlerResolver() {
        this.verifyServiceDescriptionActive();
        if (this.handlerResolver == null) {
            this.handlerResolver = new HandlerResolverImpl(this.serviceDescription, this);
        }
        return this.handlerResolver;
    }

    @Override
    public Iterator<QName> getPorts() {
        this.verifyServiceDescriptionActive();
        return this.getServiceDescription().getPorts(this).iterator();
    }

    @Override
    public QName getServiceName() {
        return this.serviceQname;
    }

    @Override
    public URL getWSDLDocumentLocation() {
        this.verifyServiceDescriptionActive();
        try {
            String wsdlLocation = ((ServiceDescriptionWSDL)((Object)this.serviceDescription)).getWSDLLocation();
            if (wsdlLocation == null) {
                return null;
            }
            return new URL(wsdlLocation);
        }
        catch (MalformedURLException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    @Override
    public void setExecutor(Executor e) {
        if (e == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("cannotSetExcutorToNull"));
        }
        this.executor = e;
    }

    @Override
    public void setHandlerResolver(HandlerResolver handlerresolver) {
        this.handlerResolver = handlerresolver;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    public ServiceClient getServiceClient(QName portQName) throws WebServiceException {
        this.verifyServiceDescriptionActive();
        return this.serviceDescription.getServiceClient(portQName, this);
    }

    public <T> T getPort(org.apache.axis2.addressing.EndpointReference axis2EPR, String addressingNamespace, Class<T> sei, WebServiceFeature ... features) {
        this.verifyServiceDescriptionActive();
        DescriptionBuilderComposite sparseComposite = ServiceDelegate.getPortMetadata();
        ServiceDelegate.resetPortMetadata();
        EndpointDescription endpointDesc = null;
        endpointDesc = sparseComposite != null ? DescriptionFactory.updateEndpoint(this.serviceDescription, sei, axis2EPR, addressingNamespace, DescriptionFactory.UpdateType.GET_PORT, sparseComposite, this) : DescriptionFactory.updateEndpoint(this.serviceDescription, sei, axis2EPR, addressingNamespace, DescriptionFactory.UpdateType.GET_PORT, null, this);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDelegateNoPort", axis2EPR.toString()));
        }
        String[] interfacesNames = new String[]{sei.getName(), BindingProvider.class.getName()};
        Class[] interfaces = null;
        ClassLoader classLoader = ServiceDelegate.getClassLoader(sei);
        try {
            interfaces = ServiceDelegate.loadClasses(classLoader, interfacesNames);
        }
        catch (ClassNotFoundException e1) {
            classLoader = ServiceDelegate.getContextClassLoader();
            try {
                interfaces = ServiceDelegate.loadClasses(classLoader, interfacesNames);
            }
            catch (ClassNotFoundException e2) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDelegateProxyError", e2.getMessage()));
            }
        }
        JAXWSProxyHandler proxyHandler = new JAXWSProxyHandler(this, interfaces[0], endpointDesc, axis2EPR, addressingNamespace, features);
        Object proxyClass = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)proxyHandler);
        return sei.cast(proxyClass);
    }

    private Executor getDefaultExecutor() {
        ExecutorFactory executorFactory = (ExecutorFactory)FactoryRegistry.getFactory(ExecutorFactory.class);
        return executorFactory.getExecutorInstance(0);
    }

    private boolean isValidServiceName() {
        return this.serviceQname != null && !"".equals(this.serviceQname.toString().trim());
    }

    private boolean isValidWSDLLocation() {
        URL wsdlLocation = this.getWSDLDocumentLocation();
        return wsdlLocation != null && !"".equals(wsdlLocation.toString().trim());
    }

    private WSDLWrapper getWSDLWrapper() {
        this.verifyServiceDescriptionActive();
        return ((ServiceDescriptionWSDL)((Object)this.serviceDescription)).getWSDLWrapper();
    }

    private boolean isServiceDefined(QName serviceName) {
        return this.getWSDLWrapper().getService(serviceName) != null;
    }

    private boolean isValidDispatchType(Class clazz) {
        return clazz != null && (clazz == String.class || clazz == Source.class || clazz == DataSource.class || clazz == SOAPMessage.class || clazz == OMElement.class);
    }

    private boolean isValidDispatchTypeWithMode(Class clazz, Service.Mode mode) {
        return clazz != null && (clazz != SOAPMessage.class || !mode.equals((Object)Service.Mode.PAYLOAD));
    }

    private static ClassLoader getClassLoader(final Class cls) {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return cls.getClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classLoader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classLoader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static Class[] loadClasses(ClassLoader classLoader, String[] classNames) throws ClassNotFoundException {
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            classes[i] = ServiceDelegate.forName(classNames[i], true, classLoader);
        }
        return classes;
    }

    public static void releaseService(Service service) {
        ServiceDelegate serviceDelegate = ServiceDelegate.getServiceDelegateForService(service);
        serviceDelegate.releaseServiceResources();
    }

    private static ServiceDelegate getServiceDelegateForService(Service service) {
        ServiceDelegate returnServiceDelegate = null;
        try {
            try {
                Field serviceDelgateField = service.getClass().getDeclaredField("delegate");
                serviceDelgateField.setAccessible(true);
                returnServiceDelegate = (ServiceDelegate)serviceDelgateField.get(service);
            }
            catch (NoSuchFieldException e) {
                Field serviceDelegateField = service.getClass().getSuperclass().getDeclaredField("delegate");
                serviceDelegateField.setAccessible(true);
                returnServiceDelegate = (ServiceDelegate)serviceDelegateField.get(service);
            }
        }
        catch (SecurityException e) {
            if (log.isDebugEnabled()) {
                log.debug("Attempt to get service delegate for service caught exception.", e);
            }
            throw ExceptionFactory.makeWebServiceException(e);
        }
        catch (IllegalAccessException e) {
            if (log.isDebugEnabled()) {
                log.debug("Attempt to get service delegate for service caught exception.", e);
            }
            throw ExceptionFactory.makeWebServiceException(e);
        }
        catch (NoSuchFieldException e) {
            if (log.isDebugEnabled()) {
                log.debug("Attempt to get service delegate for service caught exception.", e);
            }
            throw ExceptionFactory.makeWebServiceException(e);
        }
        return returnServiceDelegate;
    }

    private void releaseServiceResources() {
        if (log.isDebugEnabled()) {
            log.debug("ServiceDelegate.releaseServiceResouces entry");
        }
        if (this.serviceDescription != null) {
            this.serviceDescription.releaseResources(this);
            this.serviceDescription = null;
        }
    }

    private void verifyServiceDescriptionActive() {
        if (this.serviceDescription == null) {
            throw ExceptionFactory.makeWebServiceException("Attempt to use Service after it was released");
        }
    }

    protected void finalize() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("ServiceDelegate.finalize entered for " + this);
        }
        try {
            this.releaseServiceResources();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("ServiceDelgate Finalizer caught exception", e);
            }
        }
        finally {
            super.finalize();
        }
        if (log.isDebugEnabled()) {
            log.debug("ServiceDelegate.finalize exited");
        }
    }
}

