/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.wsdl.Definition;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.common.config.WSDLExtensionValidator;
import org.apache.axis2.jaxws.common.config.WSDLValidatorElement;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLExtensionValidatorUtil {
    private static final Log log = LogFactory.getLog(WSDLExtensionValidatorUtil.class);
    private static final boolean debug = log.isDebugEnabled();

    public static void addWSDLExtensionValidator(ConfigurationContext configurationContext, WSDLExtensionValidator validator) throws AxisFault {
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        WSDLExtensionValidatorUtil.addWSDLExtensionValidator(axisConfiguration, validator);
    }

    public static void addWSDLExtensionValidator(AxisConfiguration axisConfiguration, WSDLExtensionValidator validator) throws AxisFault {
        Parameter param = axisConfiguration.getParameter("JAXWS-WSDLExtensionValidator-List");
        if (param == null) {
            param = new Parameter("JAXWS-WSDLExtensionValidator-List", new LinkedList());
            axisConfiguration.addParameter(param);
        }
        List validatorList = (List)param.getValue();
        validatorList.add(validator);
        if (debug) {
            log.debug("Registered WSDLExtensionValidator [" + validator + "] with AxisConfiguration: " + axisConfiguration);
        }
    }

    public static void performValidation(AxisConfiguration axisConfiguration, Set<WSDLValidatorElement> extensionSet, Definition wsdlDefinition, EndpointDescription endpointDescription) {
        if (debug) {
            log.debug("Entered performValidation(AxisConfiguration, Set<WSDLValidatorElement>, Definition, EndpointDescription)");
            log.debug("axisConfiguration=" + axisConfiguration);
        }
        if (axisConfiguration == null) {
            if (debug) {
                log.debug("The AxisConfiguration was null, so we can't fetch any validators");
            }
            return;
        }
        if (extensionSet == null || extensionSet.isEmpty()) {
            if (debug) {
                log.debug("There were no extensions to validate");
            }
            return;
        }
        Parameter param = axisConfiguration.getParameter("JAXWS-WSDLExtensionValidator-List");
        if (param != null) {
            List validatorList = (List)param.getValue();
            ListIterator wsdlExtensionValidators = validatorList.listIterator();
            while (wsdlExtensionValidators.hasNext()) {
                WSDLExtensionValidator wev = (WSDLExtensionValidator)wsdlExtensionValidators.next();
                if (debug) {
                    log.debug("Calling validate() on WSDLExtensionValidator: " + wev);
                }
                wev.validate(extensionSet, wsdlDefinition, endpointDescription);
                if (!debug) continue;
                log.debug("Returned from WSDLExtensionValidator: " + wev);
            }
        }
    }
}

