/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.commons.benchmarking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hpccsystems.commons.benchmarking.IMetric;
import org.hpccsystems.commons.benchmarking.IMetricSetTransformer;
import org.hpccsystems.commons.benchmarking.SimpleMetric;

public class MetricSumTransformer
implements IMetricSetTransformer {
    @Override
    public List<IMetric> transform(List<IMetric> metrics) {
        if (metrics.size() == 0) {
            return metrics;
        }
        Comparator<IMetric> compare = new Comparator<IMetric>(){

            @Override
            public int compare(IMetric m1, IMetric m2) {
                return m1.getName().compareTo(m2.getName());
            }
        };
        Collections.sort(metrics, compare);
        ArrayList<IMetric> summedMetrics = new ArrayList<IMetric>();
        SimpleMetric workingMetric = new SimpleMetric(metrics.get(0));
        summedMetrics.add(workingMetric);
        for (int i = 1; i < metrics.size(); ++i) {
            IMetric curMetric = metrics.get(i);
            if (workingMetric.getName() != curMetric.getName()) {
                workingMetric = new SimpleMetric(curMetric);
                summedMetrics.add(workingMetric);
                continue;
            }
            workingMetric.setValue(workingMetric.getValue() + curMetric.getValue());
        }
        return summedMetrics;
    }
}

