/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.dfs.client.AvroRecordTranslator;
import org.hpccsystems.dfs.client.AvroSchemaTranslator;
import org.hpccsystems.dfs.client.HPCCRecord;
import org.hpccsystems.dfs.client.HPCCRecordAccessor;
import org.hpccsystems.dfs.client.IRecordAccessor;

public class AvroGenericRecordAccessor
implements IRecordAccessor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(AvroGenericRecordAccessor.class);
    private Schema avroSchema = null;
    private GenericRecord avroRecord = null;
    private FieldDef translatedRecordDef = null;
    private HPCCRecordAccessor translatedRecordAccessor = null;
    private HPCCRecord translatedRecord = null;

    public AvroGenericRecordAccessor(Schema recordSchema) throws Exception {
        this.avroSchema = recordSchema;
        this.translatedRecordDef = AvroSchemaTranslator.toHPCC(recordSchema, recordSchema.getName());
    }

    @Override
    public IRecordAccessor setRecord(Object rec) {
        if (!(rec instanceof GenericRecord)) {
            String msg = "AvroGenericRecordAccessor: Invalid record type provided. Record should be of type: " + GenericRecord.class.getName();
            log.error(msg);
            throw new RuntimeException(msg);
        }
        this.avroRecord = (GenericRecord)rec;
        try {
            this.translatedRecord = (HPCCRecord)AvroRecordTranslator.toHPCC(this.avroSchema, null, this.translatedRecordDef, this.avroRecord);
        }
        catch (Exception e) {
            String msg = "AvroGenericRecordAccessor: Invalid record type provided. Record should be of type: " + GenericRecord.class.getName();
            log.error(msg);
            throw new RuntimeException(msg);
        }
        this.translatedRecordAccessor.setRecord(this.translatedRecord);
        return this;
    }

    @Override
    public int getNumFields() {
        return this.translatedRecordDef.getNumDefs();
    }

    @Override
    public Object getFieldValue(int index) {
        return this.translatedRecordAccessor.getFieldValue(index);
    }

    @Override
    public FieldDef getFieldDefinition(int index) {
        return this.translatedRecordDef.getDef(index);
    }

    @Override
    public IRecordAccessor getChildRecordAccessor(int index) {
        return this.translatedRecordAccessor.getChildRecordAccessor(index);
    }
}

