/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.dfs.client.HPCCRecord;

public class AvroRecordTranslator {
    private static final ArrayList<Object> EMPTY_ARRAY_LIST = new ArrayList();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String EMPTY_STRING = "";
    private static final Boolean DEFAULT_BOOLEAN = false;
    private static final Integer DEFAULT_INTEGER = 0;
    private static final Long DEFAULT_LONG = 0L;
    private static final Double DEFAULT_DOUBLE = 0.0;
    private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);

    static int littleEndianFromByteArray(byte[] bytes, int offset) {
        return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 0] & 0xFF) << 0;
    }

    static void littleEndianToByteArray(Integer val, byte[] bytes, int offset) {
        bytes[offset + 3] = (byte)((val & 0xFF000000) >> 24);
        bytes[offset + 2] = (byte)((val & 0xFF0000) >> 16);
        bytes[offset + 1] = (byte)((val & 0xFF00) >> 8);
        bytes[offset + 0] = (byte)(val & 0);
    }

    public static Object toAvro(Schema schema, FieldDef fd, Object field) throws Exception {
        switch (schema.getType()) {
            case ARRAY: {
                if (fd.getFieldType() != FieldType.SET && fd.getFieldType() != FieldType.DATASET) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                List hpccArray = (List)field;
                ArrayList<Object> ret = new ArrayList<Object>();
                for (int i = 0; i < hpccArray.size(); ++i) {
                    ret.add(AvroRecordTranslator.toAvro(schema.getElementType(), fd.getDef(0), hpccArray.get(i)));
                }
                return ret;
            }
            case BOOLEAN: {
                if (fd.getFieldType() != FieldType.BOOLEAN) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                return field;
            }
            case BYTES: {
                if (fd.getFieldType() != FieldType.BINARY) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                byte[] data = (byte[])field;
                ByteBuffer ret = ByteBuffer.allocate(data.length);
                ret.put(data);
                return ret;
            }
            case DOUBLE: {
                if (fd.getFieldType() != FieldType.REAL) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (field instanceof Double) {
                    return field;
                }
                if (field instanceof Float) {
                    Float fltVal = (Float)field;
                    return (double)fltVal.floatValue();
                }
                throw new Exception("AvroFieldTranslator toAvro: Double: Unexpected value type: " + field.getClass());
            }
            case ENUM: {
                if (fd.getFieldType() != FieldType.INTEGER) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                Integer enumVal = -1;
                if (!(field instanceof Integer)) {
                    throw new Exception("AvroFieldTranslator toAvro: Enum: Unexpected value type: " + field.getClass());
                }
                enumVal = (Integer)field;
                GenericData.EnumSymbol enumSymbol = new GenericData.EnumSymbol(schema, (String)schema.getEnumSymbols().get(enumVal));
                return enumSymbol;
            }
            case FIXED: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    if (fd.getFieldType() != FieldType.DECIMAL) {
                        throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getLogicalType() + "  to hpcc field type: " + fd.getFieldType());
                    }
                    BigDecimal decimalVal = BigDecimal.ZERO;
                    if (!(field instanceof BigDecimal)) {
                        throw new Exception("AvroFieldTranslator toAvro: LogicalType.Decimal: Unexpected value type: " + field.getClass());
                    }
                    decimalVal = (BigDecimal)field;
                    LogicalTypes.Decimal decimalInfo = (LogicalTypes.Decimal)schema.getLogicalType();
                    decimalVal = decimalVal.setScale(decimalInfo.getScale());
                    GenericData.Fixed fixedVal = new GenericData.Fixed(schema, decimalVal.unscaledValue().toByteArray());
                    return fixedVal;
                }
                if (schema.getLogicalType().getName().equals("duration")) {
                    if (fd.getFieldType() != FieldType.RECORD) {
                        throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getLogicalType() + "  to hpcc field type: " + fd.getFieldType());
                    }
                    if (field instanceof HPCCRecord) {
                        HPCCRecord recValue = (HPCCRecord)field;
                        Integer months = (Integer)recValue.getField(0);
                        Integer days = (Integer)recValue.getField(1);
                        Integer millis = (Integer)recValue.getField(2);
                        byte[] data = new byte[12];
                        AvroRecordTranslator.littleEndianToByteArray(months, data, 0);
                        AvroRecordTranslator.littleEndianToByteArray(days, data, 4);
                        AvroRecordTranslator.littleEndianToByteArray(millis, data, 8);
                        GenericData.Fixed fixedVal = new GenericData.Fixed(schema, data);
                        return fixedVal;
                    }
                    throw new Exception("AvroFieldTranslator toAvro: LogicalType.Duration: Unexpected value type: " + field.getClass());
                }
                if (fd.getFieldType() != FieldType.BINARY) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (field instanceof byte[]) {
                    byte[] data = (byte[])field;
                    return new GenericData.Fixed(schema, data);
                }
                throw new Exception("AvroFieldTranslator toAvro: GenericFixed: Unexpected value type: " + field.getClass());
            }
            case FLOAT: {
                if (fd.getFieldType() != FieldType.REAL) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (field instanceof Number) {
                    Number numVal = (Number)field;
                    return Float.valueOf(numVal.floatValue());
                }
                throw new Exception("AvroFieldTranslator toAvro: Float: Unexpected value type: " + field.getClass());
            }
            case INT: {
                if (fd.getFieldType() != FieldType.INTEGER) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (field instanceof Number) {
                    Number numVal = (Number)field;
                    return numVal.intValue();
                }
                throw new Exception("AvroFieldTranslator toAvro: Integer: Unexpected value type: " + field.getClass());
            }
            case LONG: {
                if (fd.getFieldType() != FieldType.INTEGER) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (field instanceof Number) {
                    Number numVal = (Number)field;
                    return numVal.longValue();
                }
                throw new Exception("AvroFieldTranslator toAvro: Long: Unexpected value type: " + field.getClass());
            }
            case MAP: {
                if (fd.getFieldType() != FieldType.DATASET) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (field instanceof List) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    List recordList = (List)field;
                    for (int i = 0; i < recordList.size(); ++i) {
                        HPCCRecord rec = (HPCCRecord)recordList.get(i);
                        if (rec.getNumFields() != 2) {
                            throw new Exception("AvroFieldTranslator toAvro: Map: Unexpected num fields in map record: " + rec.getNumFields());
                        }
                        String key = (String)rec.getField(0);
                        Object val = AvroRecordTranslator.toAvro(schema.getValueType(), fd.getDef(0).getDef(1), rec.getField(1));
                        map.put(key, val);
                    }
                    return map;
                }
                throw new Exception("AvroFieldTranslator toAvro: Map: Unexpected value type: " + field.getClass());
            }
            case NULL: {
                if (fd.getFieldType() != FieldType.BOOLEAN) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (field instanceof Boolean) {
                    return field;
                }
                throw new Exception("AvroFieldTranslator toAvro: Null: Unexpected value type: " + field.getClass());
            }
            case RECORD: {
                int totalFields;
                if (fd.getFieldType() != FieldType.RECORD) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (!(field instanceof HPCCRecord)) {
                    throw new Exception("AvroFieldTranslator toAvro: Record: Unexpected value type: " + field.getClass());
                }
                HPCCRecord record = (HPCCRecord)field;
                List schemaFields = schema.getFields();
                ArrayList<Object> translatedFields = new ArrayList<Object>();
                int fieldIndex = 0;
                for (Schema.Field schemaField : schemaFields) {
                    Object outField;
                    Object childField = record.getField(fieldIndex);
                    if (schemaField.schema().getType() == Schema.Type.UNION) {
                        outField = AvroRecordTranslator.hpccUnionToAvro(schemaField.schema(), fd.getDef(fieldIndex), childField, false);
                        translatedFields.add(outField);
                    } else {
                        outField = AvroRecordTranslator.toAvro(schemaField.schema(), fd.getDef(fieldIndex), childField);
                        translatedFields.add(outField);
                    }
                    ++fieldIndex;
                }
                int numNullBitFields = 0;
                if (schemaFields.size() != fd.getNumDefs()) {
                    numNullBitFields = (translatedFields.size() + 63) / 64;
                }
                if ((totalFields = numNullBitFields + translatedFields.size()) != fd.getNumDefs()) {
                    throw new Exception("AvroFieldTranslation: toAvro: Error: Mismatch between record and expected record definition.");
                }
                for (int i = 0; i < numNullBitFields; ++i) {
                    int hpccFieldIndex;
                    Long nullBitField = (Long)record.getField(i);
                    for (int j = 0; j < 64 && (hpccFieldIndex = i * 64 + j) < fd.getNumDefs(); ++j) {
                        if ((nullBitField & (long)(1 << j)) == 0L) continue;
                        translatedFields.set(hpccFieldIndex, null);
                    }
                }
                GenericRecordBuilder avroRecordBuilder = new GenericRecordBuilder(schema);
                fieldIndex = 0;
                for (Schema.Field schemaField : schemaFields) {
                    avroRecordBuilder.set(schemaField, translatedFields.get(fieldIndex));
                    ++fieldIndex;
                }
                return avroRecordBuilder.build();
            }
            case STRING: {
                if (fd.getFieldType() != FieldType.STRING) {
                    throw new Exception("AvroFieldTranslator toAvro: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (field instanceof String) {
                    return field;
                }
                throw new Exception("AvroFieldTranslator toAvro: String: Unexpected value type: " + field.getClass());
            }
            case UNION: {
                return AvroRecordTranslator.hpccUnionToAvro(schema, fd, field, true);
            }
        }
        throw new Exception("AvroFieldTranslator toAvro: Unhandled field type: " + schema.getType());
    }

    public static Object toHPCC(Schema schema, Schema.Field fieldMeta, FieldDef fd, Object field) throws Exception {
        switch (schema.getType()) {
            case ARRAY: {
                if (fd.getFieldType() != FieldType.SET && fd.getFieldType() != FieldType.DATASET) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                ArrayList<Object> ret = EMPTY_ARRAY_LIST;
                if (field != null) {
                    Schema elementSchema = schema.getElementType();
                    ret = new ArrayList();
                    Collection arrayCol = (Collection)field;
                    for (Object val : arrayCol) {
                        ret.add(AvroRecordTranslator.toHPCC(elementSchema, null, fd.getDef(0), val));
                    }
                }
                return ret;
            }
            case BOOLEAN: {
                if (fd.getFieldType() != FieldType.BOOLEAN) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                Boolean ret = DEFAULT_BOOLEAN;
                if (field != null) {
                    ret = (Boolean)field;
                } else if (fieldMeta != null) {
                    return fieldMeta.defaultVal();
                }
                return ret;
            }
            case BYTES: {
                if (fd.getFieldType() != FieldType.BINARY) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                byte[] ret = EMPTY_BYTE_ARRAY;
                if (field != null) {
                    ByteBuffer byteBuffer = (ByteBuffer)field;
                    ret = byteBuffer.array();
                } else if (fieldMeta != null) {
                    return fieldMeta.defaultVal();
                }
                return ret;
            }
            case DOUBLE: {
                if (fd.getFieldType() != FieldType.REAL) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                Double ret = DEFAULT_DOUBLE;
                if (field != null) {
                    ret = (Double)field;
                } else if (fieldMeta != null) {
                    return fieldMeta.defaultVal();
                }
                return ret;
            }
            case ENUM: {
                if (fd.getFieldType() != FieldType.INTEGER) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                Integer ret = -1;
                if (field != null) {
                    GenericEnumSymbol enumSymbol = (GenericEnumSymbol)field;
                    ret = schema.getEnumOrdinal(enumSymbol.toString());
                } else if (fieldMeta != null) {
                    return fieldMeta.defaultVal();
                }
                return ret;
            }
            case FIXED: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    if (fd.getFieldType() != FieldType.DECIMAL) {
                        throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getLogicalType() + "  to hpcc field type: " + fd.getFieldType());
                    }
                    LogicalTypes.Decimal decimalInfo = (LogicalTypes.Decimal)schema.getLogicalType();
                    BigDecimal ret = BigDecimal.ZERO;
                    if (field != null) {
                        byte[] data = ((GenericFixed)field).bytes();
                        BigInteger intValue = new BigInteger(data);
                        ret = new BigDecimal(intValue, decimalInfo.getScale());
                    }
                    return ret;
                }
                if (schema.getLogicalType().getName().equals("duration")) {
                    if (fd.getFieldType() != FieldType.RECORD) {
                        throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getLogicalType() + "  to hpcc field type: " + fd.getFieldType());
                    }
                    Object[] fields = new Object[]{DEFAULT_INTEGER, DEFAULT_INTEGER, DEFAULT_INTEGER};
                    if (field != null) {
                        byte[] data = ((GenericFixed)field).bytes();
                        Integer months = AvroRecordTranslator.littleEndianFromByteArray(data, 0);
                        Integer days = AvroRecordTranslator.littleEndianFromByteArray(data, 4);
                        Integer millis = AvroRecordTranslator.littleEndianFromByteArray(data, 8);
                        fields[0] = months;
                        fields[1] = days;
                        fields[2] = millis;
                    }
                    return new HPCCRecord(fields, fd);
                }
                if (fd.getFieldType() != FieldType.BINARY) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                byte[] ret = EMPTY_BYTE_ARRAY;
                if (field != null) {
                    ret = ((GenericFixed)field).bytes();
                } else if (fieldMeta != null) {
                    return fieldMeta.defaultVal();
                }
                return ret;
            }
            case FLOAT: {
                if (fd.getFieldType() != FieldType.REAL) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                Float ret = DEFAULT_FLOAT;
                if (field != null) {
                    ret = (Float)field;
                } else if (fieldMeta != null) {
                    return fieldMeta.defaultVal();
                }
                return ret;
            }
            case INT: {
                if (fd.getFieldType() != FieldType.INTEGER) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                Integer ret = DEFAULT_INTEGER;
                if (field != null) {
                    ret = (Integer)field;
                } else if (fieldMeta != null) {
                    return fieldMeta.defaultVal();
                }
                return ret;
            }
            case LONG: {
                if (fd.getFieldType() != FieldType.INTEGER) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                Long ret = DEFAULT_LONG;
                if (field != null) {
                    ret = (Long)field;
                } else if (fieldMeta != null) {
                    return fieldMeta.defaultVal();
                }
                return ret;
            }
            case MAP: {
                if (fd.getFieldType() != FieldType.DATASET) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                ArrayList<Object> ret = EMPTY_ARRAY_LIST;
                if (field != null) {
                    ret = new ArrayList();
                    Map map = (Map)field;
                    FieldDef elementFieldDef = fd.getDef(0);
                    for (Map.Entry entry : map.entrySet()) {
                        Object convertedFieldValue = AvroRecordTranslator.toHPCC(schema.getValueType(), null, elementFieldDef.getDef(1), entry.getValue());
                        HPCCRecord record = new HPCCRecord(new Object[]{entry.getKey(), convertedFieldValue}, elementFieldDef);
                        ret.add(record);
                    }
                }
                return ret;
            }
            case NULL: {
                if (fd.getFieldType() != FieldType.BOOLEAN) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                if (field != null) {
                    return (Boolean)field;
                }
                Boolean val = true;
                return val;
            }
            case RECORD: {
                int totalFields;
                if (fd.getFieldType() != FieldType.RECORD) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                List schemaFields = schema.getFields();
                boolean hasNullableFields = false;
                ArrayList<Object> translatedFields = new ArrayList<Object>();
                IndexedRecord avroRecord = (IndexedRecord)field;
                int fieldIndex = 0;
                for (Schema.Field schemaField : schemaFields) {
                    Object childField = avroRecord.get(fieldIndex);
                    if (schemaField.schema().getType() == Schema.Type.UNION) {
                        Boolean isNullable = false;
                        Boolean isNull = false;
                        Object outField = AvroRecordTranslator.avroUnionToHpcc(schemaField.schema(), fd.getDef(fieldIndex), childField, isNullable, isNull, false);
                        translatedFields.add(outField);
                        if (isNullable.booleanValue()) {
                            hasNullableFields = true;
                        }
                    } else {
                        Object outField = AvroRecordTranslator.toHPCC(schemaField.schema(), null, fd.getDef(fieldIndex), childField);
                        translatedFields.add(outField);
                    }
                    ++fieldIndex;
                }
                int numNullBitFields = 0;
                if (hasNullableFields) {
                    numNullBitFields = (translatedFields.size() + 63) / 64;
                }
                if ((totalFields = numNullBitFields + translatedFields.size()) != fd.getNumDefs()) {
                    throw new Exception("AvroFieldTranslation: Error: Mismatch between record and expected record definition.");
                }
                for (int i = 0; i < numNullBitFields; ++i) {
                    int avroFieldIndex;
                    long nullBitField = 0L;
                    for (int j = 0; j < 64 && (avroFieldIndex = i * 64 + j) < schemaFields.size(); ++j) {
                        if (avroRecord.get(avroFieldIndex) != null) continue;
                        nullBitField |= (long)(1 << j);
                    }
                    translatedFields.add(nullBitField);
                }
                return new HPCCRecord(translatedFields.toArray(), fd);
            }
            case STRING: {
                if (fd.getFieldType() != FieldType.STRING) {
                    throw new Exception("AvroFieldTranslator toHPCC: incompatible avro schema type: " + schema.getType() + "  to hpcc field type: " + fd.getFieldType());
                }
                String ret = EMPTY_STRING;
                if (field != null) {
                    ret = ((CharSequence)field).toString();
                } else if (fieldMeta != null) {
                    return fieldMeta.defaultVal();
                }
                return ret;
            }
            case UNION: {
                Boolean isNullable = true;
                Boolean isNull = true;
                return AvroRecordTranslator.avroUnionToHpcc(schema, fd, field, isNullable, isNull, true);
            }
        }
        throw new Exception("AvroFieldTranslator toHPCC: Unhandled field type: " + schema.getType());
    }

    static boolean objectIsOfType(Object val, Schema type) {
        if (val == null) {
            return false;
        }
        switch (type.getType()) {
            case ARRAY: {
                return val instanceof Collection;
            }
            case BOOLEAN: {
                return val instanceof Boolean;
            }
            case BYTES: {
                return val instanceof byte[];
            }
            case DOUBLE: {
                return val instanceof Double;
            }
            case ENUM: {
                return val instanceof GenericEnumSymbol;
            }
            case FIXED: {
                return val instanceof GenericFixed;
            }
            case FLOAT: {
                return val instanceof Float;
            }
            case INT: {
                return val instanceof Integer;
            }
            case LONG: {
                return val instanceof Long;
            }
            case MAP: {
                return val instanceof Map;
            }
            case NULL: {
                return false;
            }
            case RECORD: {
                return val instanceof IndexedRecord;
            }
            case STRING: {
                return val instanceof CharSequence;
            }
            case UNION: {
                return true;
            }
        }
        return false;
    }

    static Object avroUnionToHpcc(Schema schema, FieldDef fd, Object unionVal, Boolean isNullable, Boolean isNull, boolean inlineNull) throws Exception {
        List unionTypes = schema.getTypes();
        Integer actualTypeIndex = -1;
        int typeIndex = 0;
        ArrayList<Object> childFields = new ArrayList<Object>();
        for (Schema type : unionTypes) {
            if (type.getType() == Schema.Type.NULL) {
                isNullable = true;
                if (inlineNull) {
                    isNull = unionVal == null;
                    childFields.add(AvroRecordTranslator.toHPCC(type, null, fd.getDef(typeIndex), isNull));
                }
            } else if (AvroRecordTranslator.objectIsOfType(unionVal, type)) {
                childFields.add(AvroRecordTranslator.toHPCC(type, null, fd.getDef(typeIndex), unionVal));
                actualTypeIndex = typeIndex;
            } else {
                childFields.add(AvroRecordTranslator.toHPCC(type, null, fd.getDef(typeIndex), null));
            }
            ++typeIndex;
        }
        if (childFields.size() == 1) {
            return childFields.get(0);
        }
        if (actualTypeIndex == -1) {
            isNull = true;
        }
        childFields.add(actualTypeIndex);
        return new HPCCRecord(childFields.toArray(), fd);
    }

    static Object hpccUnionToAvro(Schema schema, FieldDef fd, Object unionVal, boolean inlineNull) throws Exception {
        Object translatedVal = null;
        List unionTypes = schema.getTypes();
        if (unionVal instanceof HPCCRecord) {
            int numExpectedFields = unionTypes.size() + 1;
            if (numExpectedFields != fd.getNumDefs()) {
                throw new Exception("AvroFieldTranslator toAvro: HPCC Union Record has unexpected number of fields: " + fd.getNumDefs() + " Expected: " + numExpectedFields);
            }
            HPCCRecord record = (HPCCRecord)unionVal;
            Integer typeIndex = (Integer)record.getField(numExpectedFields - 1);
            translatedVal = AvroRecordTranslator.toAvro((Schema)unionTypes.get(typeIndex), fd.getDef(typeIndex), record.getField(typeIndex));
        } else {
            if (unionTypes.size() != 2) {
                throw new Exception("AvroFieldTranslator toAvro: Avro Union schema has unexpected number of types: " + unionTypes.size() + " Expected: 2");
            }
            int typeIndex = 0;
            if (((Schema)unionTypes.get(0)).getType() == Schema.Type.NULL) {
                typeIndex = 1;
            }
            translatedVal = AvroRecordTranslator.toAvro((Schema)unionTypes.get(typeIndex), fd, unionVal);
        }
        return translatedVal;
    }
}

