/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.parquet.io.DelegatingPositionOutputStream;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;

public class ParquetOutputFile
implements OutputFile {
    private File file = null;

    ParquetOutputFile(File file) {
        this.file = file;
    }

    public PositionOutputStream create(long blockSizeHint) throws IOException {
        return new ParquetOutputStream(new FileOutputStream(this.file));
    }

    public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
        return new ParquetOutputStream(new FileOutputStream(this.file, false));
    }

    public boolean supportsBlockSize() {
        return false;
    }

    public long defaultBlockSize() {
        return 0L;
    }

    public String getPath() {
        return this.file.getAbsolutePath();
    }

    public static class ParquetOutputStream
    extends DelegatingPositionOutputStream {
        private FileOutputStream outputStream = null;

        ParquetOutputStream(FileOutputStream stream) {
            super((OutputStream)stream);
            this.outputStream = stream;
        }

        public long getPos() throws IOException {
            return this.outputStream.getChannel().position();
        }
    }
}

