/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import org.hpccsystems.ws.client.HPCCFileSprayClient;
import org.hpccsystems.ws.client.HPCCWsWorkUnitsClient;
import org.hpccsystems.ws.client.platform.LogicalFile;
import org.hpccsystems.ws.client.platform.Platform;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.DataSingletonCollection;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.wrappers.WUState;
import org.hpccsystems.ws.client.wrappers.gen.filespray.DFUWorkunitWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.EspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.GetDFUWorkunitResponseWrapper;

public class FileSprayWorkunit
extends DataSingleton {
    public static DataSingletonCollection All = new DataSingletonCollection();
    private Platform platform;
    private DFUWorkunitWrapper info;

    public static FileSprayWorkunit get(Platform platform, String wuid) {
        if (wuid == null || wuid.isEmpty()) {
            return null;
        }
        return (FileSprayWorkunit)All.get(new FileSprayWorkunit(platform, wuid));
    }

    FileSprayWorkunit(Platform platform, String id) {
        this.platform = platform;
        this.info = new DFUWorkunitWrapper();
        this.info.setID(id);
        this.setChanged();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getID() {
        return this.info.getID();
    }

    public WUState getStateID() {
        switch (this.info.getState()) {
            case 1: {
                return WUState.SCHEDULED;
            }
            case 2: {
                return WUState.WAIT;
            }
            case 3: {
                return WUState.RUNNING;
            }
            case 4: {
                return WUState.ABORTED;
            }
            case 5: {
                return WUState.FAILED;
            }
            case 6: {
                return WUState.COMPLETED;
            }
            case 7: {
                return WUState.COMPLETED;
            }
            case 8: {
                return WUState.ABORTING;
            }
            case 999: {
                return WUState.UNKNOWN_ONSERVER;
            }
        }
        return WUState.UNKNOWN;
    }

    synchronized LogicalFile getLogicalFile(String name) {
        return LogicalFile.get(this.platform, name);
    }

    public LogicalFile getLogicalFile() {
        String logicalFileName;
        if (this.info.getSourceLogicalName() == null || this.info.getDestLogicalName() == null) {
            this.fullRefresh();
        }
        if ((logicalFileName = this.info.getSourceLogicalName()) == null || logicalFileName.isEmpty()) {
            logicalFileName = this.info.getDestLogicalName();
        }
        if (logicalFileName == null || logicalFileName.isEmpty()) {
            return null;
        }
        return this.getLogicalFile(logicalFileName);
    }

    public String getFilePath() {
        String filePath;
        if (this.info.getSourceLogicalName() == null || this.info.getDestLogicalName() == null) {
            this.fullRefresh();
        }
        if ((filePath = this.info.getSourceFilePath()) == null || filePath.isEmpty()) {
            filePath = this.info.getDestFilePath();
        }
        if (filePath == null || filePath.isEmpty()) {
            return null;
        }
        return filePath;
    }

    public boolean isDespray() {
        if (this.info.getSourceLogicalName() == null || this.info.getDestLogicalName() == null) {
            this.fullRefresh();
        }
        return this.info.getSourceLogicalName() != null && this.info.getDestFilePath() != null;
    }

    @Override
    public boolean isComplete() {
        return HPCCWsWorkUnitsClient.isWorkunitComplete(this.getStateID());
    }

    public void refreshState() {
        this.fullRefresh();
    }

    @Override
    protected void fastRefresh() {
        this.fullRefresh();
    }

    @Override
    protected void fullRefresh() {
        block4: {
            try {
                HPCCFileSprayClient fileSprayClient = this.platform.getWsClient().getFileSprayClient();
                GetDFUWorkunitResponseWrapper response = fileSprayClient.getDFUWorkunit(this.info.getID());
                if (response.getResult() == null) {
                    for (EspExceptionWrapper e : response.getExceptions().getException()) {
                        if (!e.getCode().equals("20082")) continue;
                        this.info.setState(999);
                        this.setChanged();
                        this.notifyObservers((Object)Notification.LOGICALFILEWORKUNIT);
                        break block4;
                    }
                    break block4;
                }
                this.update(response.getResult());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean update(DFUWorkunitWrapper dfuWorkunitWrapper) {
        boolean retVal = false;
        if (dfuWorkunitWrapper != null && this.info.getID().equals(dfuWorkunitWrapper.getID()) && !this.info.equals(dfuWorkunitWrapper)) {
            if (this.updateState(dfuWorkunitWrapper)) {
                retVal = true;
                this.notifyObservers((Object)Notification.LOGICALFILEWORKUNIT);
            }
            if (this.updateLogicalFiles(dfuWorkunitWrapper)) {
                retVal = true;
                this.notifyObservers((Object)Notification.LOGICALFILEWORKUNIT);
            }
        }
        this.monitor();
        return retVal;
    }

    synchronized boolean updateState(DFUWorkunitWrapper dfuWorkunitWrapper) {
        if (dfuWorkunitWrapper != null && this.info.getID().equals(dfuWorkunitWrapper.getID()) && EqualsUtil.hasChanged(this.info.getState(), dfuWorkunitWrapper.getState())) {
            this.info.setState(dfuWorkunitWrapper.getState());
            this.setChanged();
            return true;
        }
        return false;
    }

    synchronized boolean updateLogicalFiles(DFUWorkunitWrapper dfuWorkunitWrapper) {
        if (dfuWorkunitWrapper != null && this.info.getID().equals(dfuWorkunitWrapper.getID()) && (EqualsUtil.hasChanged(this.info.getSourceLogicalName(), dfuWorkunitWrapper.getSourceLogicalName()) || EqualsUtil.hasChanged(this.info.getDestLogicalName(), dfuWorkunitWrapper.getDestLogicalName()))) {
            this.info = dfuWorkunitWrapper;
            this.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof FileSprayWorkunit)) {
            return false;
        }
        FileSprayWorkunit that = (FileSprayWorkunit)aThat;
        return EqualsUtil.areEqual(this.platform, that.platform) && EqualsUtil.areEqual(this.info.getID(), that.info.getID());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.platform);
        result = HashCodeUtil.hash(result, this.info.getID());
        return result;
    }

    public Object getClusterName() {
        if (this.info.getClusterName() == null) {
            this.fullRefresh();
        }
        return this.info.getClusterName();
    }

    public static enum Notification {
        LOGICALFILEWORKUNIT;

    }
}

