/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;

public class Connection {
    private static final Logger log = LogManager.getLogger(Connection.class);
    public static final String protDelimiter = "://";
    public static final char portDelimiter = ':';
    public static final char pathDelimiter = '/';
    public static final char firstOptDelimiter = '?';
    public static final char subsequentOptDelimiter = '&';
    public static final String protHttp = "http";
    public static final String protHttps = "https";
    private String protocol;
    private String host;
    private String port;
    private String path;
    private String[] options;
    private Credentials credentials = null;
    private boolean isHttps = false;
    private boolean allowInvalidCerts = false;
    private StringBuffer baseUrl;
    private StringBuffer uriAndParams;
    public static final String CONNECT_TIMEOUT_PARAM = "connecttimeoutmillis";
    public static final String READ_TIMEOUT_PARAM = "readtimeoutmillis";
    public static final String WRITE_TIMEOUT_PARAM = "writetimeoutmillis";
    public static final String SOCKET_TIMEOUT_PARAM = "sockettimeoutmillis";
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLI = 150000;
    public static final int DEFAULT_SO_TIMEOUT_MILLI = 150000;
    public static final int DEFAULT_WRITE_TIMEOUT_MILLI = 150000;
    public static final int DEFAULT_READ_TIMEOUT_MILLI = 180000;
    static final boolean DEFAULT_MAINTAIN_SESSION = true;
    protected int connectTimeoutMilli = 150000;
    protected int readTimeoutMilli = 180000;
    protected int writeTimeoutMilli = 150000;
    protected int socketTimeoutMilli = 150000;

    public static String getProtocol(boolean ssl) {
        return ssl ? protHttps : protHttp;
    }

    public static boolean isSslProtocol(String protocol) {
        return protHttps.equalsIgnoreCase(protocol);
    }

    public Connection(String connectionstring) throws MalformedURLException {
        URL theurl = new URL(connectionstring);
        this.setProtocol(theurl.getProtocol());
        this.host = theurl.getHost();
        if (theurl.getPort() < 0) {
            throw new MalformedURLException("Invalid port encountered: '" + theurl.getPort() + "'");
        }
        this.setPort(Integer.toString(theurl.getPort()));
        this.setURIPath(theurl.getPath());
        this.options = null;
        if (theurl.getQuery() != null) {
            this.options = theurl.getQuery().split("&");
            this.processOptions();
        }
        this.constructUrl();
        this.credentials = new Credentials();
    }

    public Connection(boolean ssl, String host, int port) {
        this(Connection.getProtocol(ssl), host, String.valueOf(port), null, null);
    }

    public Connection(String protocol, String host, String port) {
        this(protocol, host, port, null, null);
    }

    public Connection(String protocol, String host, String port, String path) {
        this(protocol, host, port, path, null);
    }

    public Connection(String protocol_, String host_, String port_, String path_, String[] options_) {
        this.setProtocol(protocol_);
        this.host = host_;
        this.setPort(port_);
        this.setURIPath(path_);
        this.options = options_;
        this.processOptions();
        this.constructUrl();
        this.credentials = new Credentials();
    }

    private void processOptions() {
        if (this.options != null && this.options.length != 0) {
            for (int i = 0; i < this.options.length; ++i) {
                String[] kvoptions = this.options[i].split("=");
                if (kvoptions.length != 2) continue;
                if (kvoptions[0].equalsIgnoreCase(CONNECT_TIMEOUT_PARAM)) {
                    this.connectTimeoutMilli = Integer.valueOf(kvoptions[1]);
                    continue;
                }
                if (kvoptions[0].equalsIgnoreCase(READ_TIMEOUT_PARAM)) {
                    this.readTimeoutMilli = Integer.valueOf(kvoptions[1]);
                    continue;
                }
                if (kvoptions[0].equalsIgnoreCase(WRITE_TIMEOUT_PARAM)) {
                    this.writeTimeoutMilli = Integer.valueOf(kvoptions[1]);
                    continue;
                }
                if (!kvoptions[0].equalsIgnoreCase(SOCKET_TIMEOUT_PARAM)) continue;
                this.socketTimeoutMilli = Integer.valueOf(kvoptions[1]);
            }
        }
    }

    private void setProtocol(String protocol_) {
        if (protocol_ != null && protocol_.length() > 0) {
            this.protocol = protocol_;
        } else {
            this.isHttps = true;
            this.protocol = protHttp;
        }
    }

    private void setPort(String port_) {
        this.port = port_ != null && port_.length() > 0 ? port_ : "";
    }

    private void setURIPath(String path) {
        this.path = path != null && path.length() > 0 ? (path.charAt(0) == '/' ? path : '/' + path) : "";
    }

    private void constructUrl() {
        this.baseUrl = new StringBuffer();
        this.baseUrl.append(this.protocol).append(protDelimiter);
        this.baseUrl.append(this.host);
        this.baseUrl.append(this.port.length() > 0 ? ':' + this.port : "");
        this.uriAndParams = new StringBuffer();
        this.uriAndParams.append(this.path);
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                if (i == 0) {
                    this.uriAndParams.append('?');
                } else {
                    this.uriAndParams.append('&');
                }
                try {
                    this.uriAndParams.append(URLEncoder.encode(this.options[i], "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    log.warn("Warning: could not encode URL option: " + this.options[i]);
                    this.uriAndParams.append(this.options[i]);
                }
            }
        }
    }

    public String getUrl() {
        return this.baseUrl.toString() + this.uriAndParams.toString();
    }

    public String getBaseUrl() {
        return this.baseUrl.toString();
    }

    public boolean hasCredentials() {
        return this.credentials.isPopulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncodedCredentials(String encodedcreds) throws Exception {
        Credentials credentials = this.credentials;
        synchronized (credentials) {
            this.credentials.setEncodedCreds(encodedcreds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBasicAuthString() {
        if (!this.credentials.isPopulated) {
            return null;
        }
        Credentials credentials = this.credentials;
        synchronized (credentials) {
            return "Basic " + this.credentials.getEncodedCreds();
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public int getPortInt() {
        if (this.port != null && !this.port.isEmpty()) {
            return Integer.valueOf(this.port);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() {
        Credentials credentials = this.credentials;
        synchronized (credentials) {
            return this.credentials.getUserName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserName(String userName) {
        Credentials credentials = this.credentials;
        synchronized (credentials) {
            this.credentials.setUserName(userName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() {
        Credentials credentials = this.credentials;
        synchronized (credentials) {
            return this.credentials.getPassword();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        Credentials credentials = this.credentials;
        synchronized (credentials) {
            this.credentials.setPassword(password);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Boolean getIsHttps() {
        return this.isHttps;
    }

    public boolean getAllowInvalidCerts() {
        return this.allowInvalidCerts;
    }

    public void setAllowInvalidCerts(boolean allowInvalidCerts) {
        this.allowInvalidCerts = allowInvalidCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(String username, String password) {
        Credentials credentials = this.credentials;
        synchronized (credentials) {
            this.credentials.setCredentials(username, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials() {
        Credentials credentials = this.credentials;
        synchronized (credentials) {
            return this.credentials;
        }
    }

    public URLConnection createConnection() throws IOException {
        return Connection.createConnection(new URL(this.baseUrl.toString()));
    }

    public static URLConnection createConnection(URL url) throws IOException {
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            httpConn.setRequestMethod("POST");
            HttpURLConnection.setFollowRedirects(false);
        }
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        urlConn.setDefaultUseCaches(false);
        urlConn.setRequestProperty("Connection", "Keep-Alive");
        urlConn.setRequestProperty("DNT", "1");
        urlConn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        urlConn.setRequestProperty("ENCTYPE", "multipart/form-data");
        urlConn.setAllowUserInteraction(false);
        return urlConn;
    }

    public static String buildUrl(String protocol, String host, String port) {
        return Connection.buildUrl(protocol, host, port, null, null);
    }

    public static String buildUrl(String protocol, String host, String port, String path) {
        return Connection.buildUrl(protocol, host, port, path, null);
    }

    public static String buildUrl(String protocol, String host, String port, String path, String[] options) {
        StringBuffer url = new StringBuffer();
        url.append(protocol != null && protocol.length() > 0 ? protocol : protHttp).append(protDelimiter);
        url.append(host);
        url.append(port != null && port.length() > 0 ? ':' + port : "");
        url.append(path != null && path.length() > 0 ? (path.charAt(0) == '/' ? path : '/' + path) : "");
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                if (i == 0) {
                    url.append('?');
                } else {
                    url.append('&');
                }
                try {
                    url.append(URLEncoder.encode(options[i], "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    log.warn("Warning: could not encode URL option: " + options[i]);
                    url.append(options[i]);
                }
            }
        }
        return url.toString();
    }

    public int getConnectTimeoutMilli() {
        return this.connectTimeoutMilli;
    }

    public void setConnectTimeoutMilli(int connectTimeoutMilli) {
        this.connectTimeoutMilli = connectTimeoutMilli;
    }

    public int getReadTimeoutMilli() {
        return this.readTimeoutMilli;
    }

    public void setReadTimeoutMilli(int readTimeoutMilli) {
        this.readTimeoutMilli = readTimeoutMilli;
    }

    public int getWriteTimeoutMilli() {
        return this.writeTimeoutMilli;
    }

    public void setWriteTimeoutMilli(int writeTimeoutMilli) {
        this.writeTimeoutMilli = writeTimeoutMilli;
    }

    public int getSocketTimeoutMilli() {
        return this.socketTimeoutMilli;
    }

    public void setSocketTimeoutMilli(int socketTimeoutMilli) {
        this.socketTimeoutMilli = socketTimeoutMilli;
    }

    public String toString() {
        return Connection.buildUrl(this.protocol, this.host, this.port, this.path, this.options);
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Connection)) {
            return false;
        }
        Connection that = (Connection)aThat;
        return EqualsUtil.areEqual(this.getUrl(), that.getUrl()) && EqualsUtil.areEqual(this.credentials, that.getCredentials());
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.getUrl());
        result = HashCodeUtil.hash(result, this.credentials);
        return result;
    }

    public String sendGetRequest(String uri) throws Exception {
        return this.sendHTTPRequest(uri, "GET");
    }

    public String sendHTTPRequest(String uri, String method) throws Exception {
        if (method == null || method.isEmpty()) {
            throw new Exception("Must provide valid HTTP method");
        }
        URL url = new URL(this.getBaseUrl() + (uri != null && uri.startsWith("/") ? "" : "/") + uri);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        log.info("Sending HTTP " + method + "Request to:" + url.toString());
        if (this.hasCredentials()) {
            httpURLConnection.setRequestProperty("Authorization", this.getBasicAuthString());
        }
        httpURLConnection.setRequestMethod(method);
        int responseCode = httpURLConnection.getResponseCode();
        log.info("HTTP Response code: " + responseCode);
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        throw new IOException("HTTP request failed! Code (" + responseCode + ") " + httpURLConnection.getResponseMessage());
    }

    private class Credentials {
        private String userName = null;
        private String password = null;
        private boolean isPopulated = false;

        private Credentials() {
        }

        public boolean isPopulated() {
            return this.isPopulated;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String username) {
            if (username != null && username.length() > 0) {
                this.userName = username;
                this.isPopulated = this.password != null;
            }
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            if (password != null) {
                this.password = password;
                this.isPopulated = this.userName != null && this.userName.length() > 0;
            }
        }

        public String getEncodedCreds() {
            if (!this.isPopulated) {
                return null;
            }
            Base64.Encoder encoder = Base64.getEncoder();
            return new String(encoder.encode((this.userName + ":" + this.password).getBytes()));
        }

        public void setEncodedCreds(String encodedCreds) throws Exception {
            if (encodedCreds != null && encodedCreds.length() > 0) {
                this.password = null;
                this.userName = null;
                Base64.Decoder decoder = Base64.getDecoder();
                String credstring = new String(decoder.decode(encodedCreds));
                String[] creds = credstring.split(":");
                if (creds.length != 2) {
                    throw new Exception("Invalid credentials: Should be base64-encoded <username>:<password>");
                }
                this.userName = creds[0];
                this.password = creds[1];
                this.isPopulated = true;
            }
        }

        public void setCredentials(String username, String password) {
            if (username != null && username.length() > 0 && password != null) {
                this.userName = username;
                this.password = password;
                this.isPopulated = true;
            }
        }

        public int hashCode() {
            int result = 23;
            result = HashCodeUtil.hash(result, Connection.this.getProtocol());
            result = HashCodeUtil.hash(result, Connection.this.getHost());
            result = HashCodeUtil.hash(result, Connection.this.getPortInt());
            result = HashCodeUtil.hash(result, this.getUserName());
            result = HashCodeUtil.hash(result, this.getPassword());
            return result;
        }
    }
}

