/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.InputStream;
import java.text.ParseException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.MIMEAwareBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.MessageProcessorSelector;

public class MIMEBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext msgContext) throws AxisFault {
        ContentType ct;
        Attachments attachments = BuilderUtil.createAttachmentsMap(msgContext, inputStream, contentType);
        try {
            ct = new ContentType(contentType);
        }
        catch (ParseException e) {
            throw new OMException("Invalid Content Type Field in the Mime Message", e);
        }
        String type = ct.getParameter("type");
        Builder builder = MessageProcessorSelector.getMessageBuilder(type, msgContext);
        if (builder instanceof MIMEAwareBuilder) {
            return ((MIMEAwareBuilder)builder).processMIMEMessage(attachments, type, msgContext);
        }
        String charSetEncoding = BuilderUtil.getCharSetEncoding(attachments.getRootPartContentType());
        if (charSetEncoding == null || "null".equalsIgnoreCase(charSetEncoding)) {
            charSetEncoding = "UTF-8";
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
        msgContext.setAttachmentMap(attachments);
        return builder.processDocument(attachments.getRootPartInputStream(false), type, msgContext);
    }
}

